<!DOCTYPE html>
<html>
<head>
    <title>GPV Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 10px;
            font-size: 12px;
            padding-top: 60px;
        }
        
        header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 50px;
            text-align: center;
            background-color: white;
            z-index: 1000;
            padding-top: 10px;
        }
        
        .report-filters {
            margin-bottom: 15px;
            padding: 8px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            font-size: 10px;
        }
        
        .filter-item { 
            margin-bottom: 3px; 
        }
        
        .filter-label { 
            font-weight: bold; 
            display: inline-block; 
            width: 100px; 
        }
        
        h1 {
            text-align: center;
            margin-bottom: 15px;
            font-size: 14px;
        }
        
        .table-container {
            width: 100%;
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0 auto;
            font-size: 9px;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 3px 2px;
            text-align: center;
        }
        
        th {
            background-color: #f2f2f2;
            font-weight: bold;
            font-size: 9px;
        }
        
        td {
            font-size: 9px;
        }
        
        .passed {
            font-weight: bold;
            color: green;
        }
        
        .failed {
            font-weight: bold;
            color: red;
        }
        
        /* Print styles */
        @media print {
            body {
                padding-top: 60px;
            }
            
            header {
                position: fixed;
                top: 0;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
        }
    </style>
</head>
<body>

    <header class="site-header">
        <p style="font-weight: bold; font-size: 15px; margin: 0;">Restricted</p>
    </header>

    <main>
        <div class="container">
            <div class="report-filters">
                @foreach($reportFilters as $label => $value)
                    <div class="filter-item">
                        <span class="filter-label">{{ $label }}:</span>
                        <span>{{ $value }}</span>
                    </div>
                @endforeach
            </div>
            
            <div class="header-info">
                <h1>General Performance Review (GPV) - {{ $phase->name }}</h1>
            </div>

            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>Army No.</th>
                            <th>Rank</th>
                            <th>Name</th>
                            <th>Theory</th>
                            <th>Practical</th>
                            <th>22CR</th>
                            <th>PR</th>
                            <th>Total</th>
                            <th>Grade</th>
                            <th>Comment</th>
                            <th>Remarks</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach(collect($studentsData)->sortByDesc('total')->values() as $index => $student)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $student['army_number'] }}</td>
                                <td>{{ $student['rank'] }}</td>
                                <td>{{ $student['name'] }}</td>
                                <td>{{ $student['theory'] }}</td>
                                <td>{{ $student['practical'] }}</td>
                                <td>{{ $student['cr_22'] }}</td>
                                <td>{{ $student['pr'] }}</td>
                                <td><strong>{{ $student['total'] }}%</strong></td>
                                <td>{{ $student['grade'] }}</td>
                                <td>{{ $student['comment'] }}</td>
                                <td class="{{ strtolower($student['remarks']) }}">{{ $student['remarks'] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </main>

</body>
</html>