@extends('layouts.app')

@section('content')
<div class="max-w-lg mx-auto mt-10 bg-white shadow-lg rounded-lg p-6">
    <h2 class="text-2xl font-bold text-center text-blue-600 mb-6">Add New Intake</h2>

    <!-- Warning Message -->
    <div class="bg-yellow-100 text-yellow-800 p-4 mb-6 rounded-lg border border-yellow-300 text-sm">
        <strong>Warning:</strong> Adding a new intake will remove all current students and hide their reports. 
        Please back up your data first. You can save the current phase by clicking <em>Save Report</em> in the GPV section before continuing.
    </div>

    <!-- Intake Form -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="bg-gray-100 px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800">Create New Intake</h3>
        </div>
        <div class="p-6">
            <form action="{{ route('intakes.store') }}" method="POST">
                @csrf
                
                <div class="mb-4">
                    <label for="year" class="block text-sm font-medium text-gray-700 mb-1">
                        Intake Year <span class="text-gray-500 text-xs">(Format: YY/YY)</span>
                    </label>
                    <input 
                        type="text"
                        id="year"
                        name="year"
                        value="{{ old('year') }}"
                        placeholder="e.g. 24/25"
                        pattern="\d{2}/\d{2}"
                        required
                        class="w-full px-3 py-2 border rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 @error('year') border-red-500 @enderror"
                    >
                    <p class="mt-1 text-xs text-gray-500">Use the format YY/YY (e.g., 24/25)</p>

                    @error('year')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mt-6 text-center">
                    <button 
                        type="submit" 
                        class="px-5 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2"
                    >
                        Create Intake
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
