@extends('layouts.app')

@section('content')
<div class="max-w-lg mx-auto mt-10 bg-white shadow-lg rounded-lg p-6">
    <h2 class="text-2xl font-bold text-center text-blue-600 mb-6">Edit Intake</h2>

    <form action="{{ route('intakes.update', $intake) }}" method="POST">
        @csrf @method('PUT')
        <label class="block font-semibold">Year</label>
        <input type="text" name="year" value="{{ $intake->year }}" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
        
        @error('year')
            <p class="text-red-500">{{ $message }}</p>
        @enderror

        <button type="submit" class="w-full bg-blue-600 text-white py-2 mt-4 rounded-lg hover:bg-blue-700">
            Update Intake
        </button>
    </form>
</div>
@endsection
