@extends('layouts.app')

@section('content')

    <h2 class="text-2xl font-bold text-center text-blue-600 mb-6">Intakes</h2>

    @if(session('success'))
        <div class="bg-green-100 text-green-700 p-4 mb-4 rounded">{{ session('success') }}</div>
    @endif

    <a href="{{ route('intakes.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded"> Add Intake</a>



    
    <table class="min-w-full bg-white border border-gray-300 rounded-lg mt-6">
        <thead>
            <tr class="bg-gray-200">
                <th class="border p-2">ID</th>
                <th class="border p-2">Year</th>
                <th class="border p-2">Actions</th>
            </tr>
        </thead>
        @foreach($intakes as $intake)
        <tr>
            <td class="border p-2">{{ $intake->id }}</td>
            <td class="border p-2">{{ $intake->year }}</td>
            <td class="border p-2">
                <a href="{{ route('intakes.edit', $intake) }}" class="text-blue-600">Edit</a>
                <form action="{{ route('intakes.destroy', $intake) }}" method="POST" class="inline">
                    @csrf @method('DELETE')
                    <button type="submit" class="text-red-600 ml-2" onclick="return confirm('Are you sure?')">Delete</button>
                </form>
            </td>
        </tr>
    @endforeach
    </table> 

@endsection
