<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laravel Loading Screen</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: #333;
        }
        
        .container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 500px;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        h1 {
            color: #764ba2;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        p {
            color: #666;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 50px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 500;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn:hover {
            background: #764ba2;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .btn-cancel {
            background: #e74c3c;
            box-shadow: 0 4px 15px rgba(231, 76, 60, 0.3);
        }
        
        .btn-cancel:hover {
            background: #c0392b;
            box-shadow: 0 6px 20px rgba(231, 76, 60, 0.4);
        }
        
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.85);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            color: white;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s, visibility 0.3s;
        }
        
        .loading-overlay.active {
            opacity: 1;
            visibility: visible;
        }
        
        .spinner {
            width: 70px;
            height: 70px;
            margin-bottom: 20px;
            position: relative;
        }
        
        .spinner:before {
            content: "";
            box-sizing: border-box;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            border: 3px solid transparent;
            border-top-color: #667eea;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .loading-text {
            font-size: 22px;
            margin-bottom: 25px;
            font-weight: 500;
        }
        
        .progress-container {
            width: 80%;
            max-width: 300px;
            height: 8px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 4px;
            margin-bottom: 25px;
            overflow: hidden;
        }
        
        .progress-bar {
            height: 100%;
            width: 0%;
            background: linear-gradient(to right, #667eea, #764ba2);
            border-radius: 4px;
            transition: width 0.3s ease;
        }
        
        .cancel-info {
            margin-top: 15px;
            font-size: 14px;
            color: rgba(255, 255, 255, 0.7);
        }
        
        .task-list {
            text-align: left;
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 8px;
            max-height: 200px;
            overflow-y: auto;
        }
        
        .task-item {
            padding: 8px 0;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
        }
        
        .task-item:last-child {
            border-bottom: none;
        }
        
        .task-checkbox {
            margin-right: 10px;
        }
        
        .completed {
            text-decoration: line-through;
            color: #888;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Laravel Application</h1>
        <p>This is a demo of a loading screen that prevents user interaction while processing. Click the button below to simulate a task that requires loading.</p>
        
        <div class="task-list">
            <h3>Sample Tasks</h3>
            <div class="task-item">
                <input type="checkbox" class="task-checkbox">
                <span>Update user profile</span>
            </div>
            <div class="task-item">
                <input type="checkbox" class="task-checkbox">
                <span>Process payment</span>
            </div>
            <div class="task-item">
                <input type="checkbox" class="task-checkbox">
                <span>Generate report</span>
            </div>
            <div class="task-item">
                <input type="checkbox" class="task-checkbox">
                <span>Send notifications</span>
            </div>
        </div>
        
        <button class="btn" id="simulateLoading">Simulate Process</button>
    </div>
    
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
        <div class="loading-text" id="loadingText">Processing your request</div>
        <div class="progress-container">
            <div class="progress-bar" id="progressBar"></div>
        </div>
        <button class="btn btn-cancel" id="cancelLoading">Cancel Process</button>
        <div class="cancel-info">You can cancel at any time</div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const simulateBtn = document.getElementById('simulateLoading');
            const cancelBtn = document.getElementById('cancelLoading');
            const loadingOverlay = document.getElementById('loadingOverlay');
            const progressBar = document.getElementById('progressBar');
            const loadingText = document.getElementById('loadingText');
            const taskCheckboxes = document.querySelectorAll('.task-checkbox');
            
            let loadingInterval;
            let progress = 0;
            
            // Function to simulate a loading process
            function simulateLoading() {
                // Show loading overlay
                loadingOverlay.classList.add('active');
                progress = 0;
                updateProgress(0);
                
                // Disable all checkboxes and buttons
                taskCheckboxes.forEach(checkbox => {
                    checkbox.disabled = true;
                });
                simulateBtn.disabled = true;
                
                // Simulate progress
                loadingInterval = setInterval(() => {
                    progress += Math.random() * 5;
                    if (progress >= 100) {
                        progress = 100;
                        completeLoading();
                    }
                    updateProgress(progress);
                }, 300);
            }
            
            // Update progress bar and text
            function updateProgress(value) {
                progressBar.style.width = value + '%';
                
                // Update text based on progress
                if (value < 30) {
                    loadingText.textContent = "Initializing process...";
                } else if (value < 60) {
                    loadingText.textContent = "Processing data...";
                } else if (value < 90) {
                    loadingText.textContent = "Finalizing...";
                } else {
                    loadingText.textContent = "Almost done...";
                }
            }
            
            // Complete the loading process
            function completeLoading() {
                clearInterval(loadingInterval);
                
                setTimeout(() => {
                    loadingOverlay.classList.remove('active');
                    simulateBtn.disabled = false;
                    taskCheckboxes.forEach(checkbox => {
                        checkbox.disabled = false;
                    });
                    alert("Process completed successfully!");
                }, 500);
            }
            
            // Cancel the loading process
            function cancelLoading() {
                clearInterval(loadingInterval);
                loadingOverlay.classList.remove('active');
                simulateBtn.disabled = false;
                taskCheckboxes.forEach(checkbox => {
                    checkbox.disabled = false;
                });
                alert("Process was cancelled.");
            }
            
            // Event listeners
            simulateBtn.addEventListener('click', simulateLoading);
            cancelBtn.addEventListener('click', cancelLoading);
            
            // Add interactivity to task items
            taskCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    const taskText = this.nextElementSibling;
                    if (this.checked) {
                        taskText.classList.add('completed');
                    } else {
                        taskText.classList.remove('completed');
                    }
                });
            });
        });
    </script>
</body>
</html>