<!-- filepath: /c:/xampp/htdocs/army_project2/resources/views/logs/index.blade.php -->
@php
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Route;
@endphp

@extends('layouts.app')




@section('content')

<div class="py-12">

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-4xl font-bold text-gray-800">Track Activity</h1>
                <p class="text-gray-600">Filter user activity by action, date range, and reset the filter. View details such as time, user, action, details, and IP address.</p>
            </div>
        </div>
        
        <div class="bg-white shadow-sm rounded-lg overflow-hidden">
            <div class="p-6 border-b border-gray-200">
                <!-- Filters -->
                <form method="GET" class="mb-6">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Action</label>
                            <select name="action" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">All Actions</option>
                                <option value="created" {{ request('action') == 'created' ? 'selected' : '' }}>Created</option>
                                <option value="updated" {{ request('action') == 'updated' ? 'selected' : '' }}>Updated</option>
                                <option value="deleted" {{ request('action') == 'deleted' ? 'selected' : '' }}>Deleted</option>
                                <option value="login" {{ request('action') == 'login' ? 'selected' : '' }}>Login</option>
                                <option value="logout" {{ request('action') == 'logout' ? 'selected' : '' }}>Logout</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Date From</label>
                            <input type="date" name="date_from" value="{{ request('date_from') }}" 
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Date To</label>
                            <input type="date" name="date_to" value="{{ request('date_to') }}"
                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div class="flex items-end space-x-2">
                            <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-md shadow hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50">
                                Filter
                            </button>
                            <a href="{{ route('activitylogs.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md shadow hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-opacity-50">
                                Reset
                            </a>
                        </div>
                    </div>
                </form>

                <!-- Logs Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-200">
                        <thead>
                            <tr class="bg-gray-50">
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase border-b">Time</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase border-b">User</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase border-b">Action</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase border-b">Details</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase border-b">IP</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @forelse ($logs as $log)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $log->created_at->format('Y-m-d H:i:s') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $log->user_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                                            {{ $log->action == 'created' ? 'bg-green-100 text-green-800' : '' }}
                                            {{ $log->action == 'updated' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                            {{ $log->action == 'deleted' ? 'bg-red-100 text-red-800' : '' }}
                                            {{ in_array($log->action, ['login', 'logout']) ? 'bg-blue-100 text-blue-800' : '' }}">
                                            {{ ucfirst($log->action) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900">
                                        @if(in_array($log->action, ['created', 'updated', 'deleted']))
                                            <button 
                                                type="button"
                                                data-log='@json($log)'
                                                class="view-log-details text-blue-600 hover:text-blue-800 hover:underline focus:outline-none">
                                                {{ class_basename($log->model_type) }} #{{ $log->model_id }}
                                            </button>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $log->ip_address }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                        No logs found
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $logs->withQueryString()->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="logModal" class="fixed inset-0 bg-gray-900 bg-opacity-50 hidden flex justify-center items-center z-50 overflow-y-auto p-4">
    <div class="bg-white rounded-lg w-full max-w-2xl mx-auto my-8 shadow-xl">
        <!-- Modal header (sticky) -->
        <div class="sticky top-0 bg-white px-6 py-4 border-b flex justify-between items-center">
            <h2 class="text-lg font-bold">Log Details</h2>
            <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700 focus:outline-none">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
        
        <!-- Scrollable content -->
        <div class="max-h-[70vh] overflow-y-auto">
            <!-- Header info -->
            <div class="p-4 border-b bg-gray-50">
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500">User</p>
                        <p id="logUser" class="font-medium"></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Action</p>
                        <p id="logAction" class="font-medium"></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Time</p>
                        <p id="logTime" class="font-medium"></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">IP Address</p>
                        <p id="logIP" class="font-medium"></p>
                    </div>
                </div>
            </div>
            
            <!-- Changes section -->
            <div class="p-4 border-b">
                <h3 class="font-medium mb-3">Changes</h3>
                <div id="noChanges" class="hidden text-gray-500 italic text-sm">No specific changes recorded</div>
                
                <div id="changesTable" class="hidden">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead>
                                <tr class="bg-gray-100">
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Field</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Old Value</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">New Value</th>
                                </tr>
                            </thead>
                            <tbody id="changesTableBody" class="divide-y divide-gray-200">
                                <!-- Changes will be inserted here -->
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Attributes section for created/deleted items -->
                <div id="attributesSection" class="hidden mt-4">
                    <h3 class="font-medium mb-3">Attributes</h3>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead>
                                <tr class="bg-gray-100">
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Field</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Value</th>
                                </tr>
                            </thead>
                            <tbody id="attributesTableBody" class="divide-y divide-gray-200">
                                <!-- Attributes will be inserted here -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <!-- Raw data toggle section -->
            <div class="p-4">
                <button id="toggleRawData" class="text-blue-600 text-sm hover:underline focus:outline-none">
                    Show raw data
                </button>
                <div id="rawDataContainer" class="hidden mt-2">
                    <pre id="rawDataContent" class="bg-gray-100 p-3 rounded-md text-xs overflow-x-auto max-h-40"></pre>
                </div>
            </div>
        </div>
    </div>
</div>


@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Find all log detail buttons and attach click handlers
    document.querySelectorAll('.view-log-details').forEach(button => {
        button.addEventListener('click', function() {
            const logData = JSON.parse(this.dataset.log);
            openModal(logData);
        });
    });

    window.openModal = function(log) {
    try {
        // Parse changes if it's a string
        let changes = typeof log.changes === 'string' ? JSON.parse(log.changes) : log.changes;
        let attributes = changes && changes.attributes ? changes.attributes : {};

        // Fill in the basic information
        document.getElementById('logUser').textContent = log.user_name;
        document.getElementById('logIP').textContent = log.ip_address;
        document.getElementById('logTime').textContent = new Date(log.created_at).toLocaleString();

        // Format the action with proper styling
        const actionEl = document.getElementById('logAction');
        actionEl.textContent = ucfirst(log.action) + ' ' + class_basename(log.model_type) + ' #' + log.model_id;

        // Add appropriate color class to the action
        actionEl.className = 'font-medium';
        if (log.action === 'created') actionEl.classList.add('text-green-600');
        if (log.action === 'updated') actionEl.classList.add('text-yellow-600');
        if (log.action === 'deleted') actionEl.classList.add('text-red-600');

        // Handle changes display
        const changesTable = document.getElementById('changesTable');
        const changesTableBody = document.getElementById('changesTableBody');
        const noChanges = document.getElementById('noChanges');
        const attributesSection = document.getElementById('attributesSection');
        const attributesTableBody = document.getElementById('attributesTableBody');

        // Clear previous content
        changesTableBody.innerHTML = '';
        attributesTableBody.innerHTML = '';

        // Handle displaying changes for "army_number," "rank," and "name"
        let fieldsDisplayed = true;

        // Fields to check
        const fieldsToCheck = ['army_number', 'rank', 'name'];
        fieldsToCheck.forEach(field => {
            if (attributes[field]) {
                fieldsDisplayed = true;
                const row = document.createElement('tr');
                row.className = 'hover:bg-gray-50';

                // Field name cell
                const fieldCell = document.createElement('td');
                fieldCell.className = 'px-4 py-2 text-sm font-medium';
                fieldCell.textContent = formatFieldName(field);
                row.appendChild(fieldCell);

                // Value cell
                const valueCell = document.createElement('td');
                valueCell.className = 'px-4 py-2 text-sm';
                valueCell.textContent = formatValue(attributes[field]);
                row.appendChild(valueCell);

                attributesTableBody.appendChild(row);
            }
        });

        // Handle displaying changes (old and new) for fields like email or others
        if (changes.changes && Object.keys(changes.changes).length > 0) {
            changesTable.classList.remove('hidden');
            noChanges.classList.add('hidden');

            // Create rows for each changed field
            Object.entries(changes.changes).forEach(([field, values]) => {
                if (fieldsToCheck.includes(field)) {
                    const row = document.createElement('tr');
                    row.className = 'hover:bg-gray-50';

                    // Field name cell
                    const fieldCell = document.createElement('td');
                    fieldCell.className = 'px-4 py-2 text-sm font-medium';
                    fieldCell.textContent = formatFieldName(field);
                    row.appendChild(fieldCell);

                    // Old value cell
                    const oldCell = document.createElement('td');
                    oldCell.className = 'px-4 py-2 text-sm';
                    oldCell.textContent = formatValue(values.old);
                    row.appendChild(oldCell);

                    // New value cell
                    const newCell = document.createElement('td');
                    newCell.className = 'px-4 py-2 text-sm';
                    newCell.textContent = formatValue(values.new);
                    row.appendChild(newCell);

                    changesTableBody.appendChild(row);
                }
            });
        } else {
            changesTable.classList.add('hidden');
            noChanges.classList.remove('hidden');
        }

        // Display attributes for created or deleted items
        if (attributesSection.classList.contains('hidden') && fieldsDisplayed) {
            attributesSection.classList.remove('hidden');
        }

        // Set raw data for the changes in JSON format
        const rawDataContent = document.getElementById('rawDataContent');
        rawDataContent.textContent = JSON.stringify(changes, null, 2);  // Convert to pretty JSON string

        // Show the modal
        const modal = document.getElementById('logModal');
        modal.classList.remove('hidden');
        document.body.style.overflow = 'hidden';
    } catch (error) {
        console.error('Error processing log data:', error);
        alert('Error displaying log details');
    }
};



    window.closeModal = function() {
        const modal = document.getElementById('logModal');
        modal.classList.add('hidden');
        document.body.style.overflow = 'auto';
    };
    
    // Toggle raw data visibility
    document.getElementById('toggleRawData').addEventListener('click', function() {
        const rawDataContainer = document.getElementById('rawDataContainer');
        const isHidden = rawDataContainer.classList.contains('hidden');
        
        if (isHidden) {
            rawDataContainer.classList.remove('hidden');
            this.textContent = 'Hide raw data';
        } else {
            rawDataContainer.classList.add('hidden');
            this.textContent = 'Show raw data';
        }
    });

    // Event listeners for modal
    const modal = document.getElementById('logModal');
    
    // Close on escape key
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape') {
            closeModal();
        }
    });

    // Close when clicking outside
    modal.addEventListener('click', function(event) {
        if (event.target === modal) {
            closeModal();
        }
    });
    
    // Helper functions
    function formatFieldName(field) {
        return field
            .replace(/_/g, ' ')
            .replace(/\w\S*/g, function(txt) {
                return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
            });
    }
    
    function formatValue(value) {
        if (value === null || value === undefined) return '—';
        if (typeof value === 'boolean') return value ? 'Yes' : 'No';
        if (typeof value === 'object') return JSON.stringify(value);
        return String(value);
    }
    
    function ucfirst(string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    }
    
    function class_basename(className) {
        return className.split('\\').pop();
    }
});
</script>
@endpush

@endsection

