@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto mt-10 bg-white shadow-lg rounded-lg p-6">
    <h2 class="text-2xl font-bold text-center text-blue-600 mb-6">Edit Marks</h2>

    <!-- Success/Error Messages -->
    <div id="successMessage" style="display: none;" class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4"></div>
    <div id="errorMessage" style="display: none;" class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4"></div>

    <!-- Search by Army Number -->

    <!-- Filters Section -->
    <form id="filterForm">
        @csrf
        
        <!-- First Row: School, Course, Intake, Phase -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div>
                <label class="block font-semibold">School</label>
                <select name="school_id" id="school_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Schools</option>
                    @foreach($schools as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block font-semibold">Course</label>
                <select name="course_id" id="course_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Courses</option>
                    @foreach($courses as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block font-semibold">Intake</label>
                <select name="intake_id" id="intake_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Intakes</option>
                    @foreach($intakes as $id => $year)
                        <option value="{{ $id }}">{{ $year }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block font-semibold">Phase</label>
                <select name="phase" id="phase" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Phases</option>
                    @foreach($phases as $phase)
                        <option value="{{ $phase->name }}">{{ $phase->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <!-- Second Row: Assessment Type, Group, Exam Type, Subject -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div>
                <label class="block font-semibold">Assessment Type</label>
                <select name="assessment_type" id="assessment_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Types</option>
                    <option value="MSK">MSK</option>
                    <option value="Character Assessment">Character Assessment</option>
                </select>
            </div>

            <div>
                <label class="block font-semibold">Assessment Group</label>
                <select name="assessment_group" id="assessment_group" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Groups</option>
                    <option value="Theory">Theory</option>
                    <option value="Practical">Practical</option>
                </select>
            </div>

            <div>
                <label class="block font-semibold">Exam Type</label>
                <select name="type" id="type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Exam Types</option>
                    <option value="Weekly">Weekly</option>
                    <option value="Monthly">Monthly</option>
                    <option value="End of Phase Exam">End of Phase Exam</option>
                </select>
            </div>

            <div>
                <label class="block font-semibold">Subject</label>
                <select name="subject_id" id="subject_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Subjects</option>
                    @foreach($subjects as $subject)
                        <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <!-- Third Row: Bn, Coy, Pl, Sec -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div>
                <label class="block font-semibold">Bn</label>
                <select name="bn" id="bn" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Bn</option>
                    @foreach($bn as $b)
                        <option value="{{ $b }}">{{ $b }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block font-semibold">Coy</label>
                <select name="coy" id="coy" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Coy</option>
                    @foreach($coy as $c)
                        <option value="{{ $c }}">{{ $c }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block font-semibold">Pl</label>
                <select name="pl" id="pl" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Pl</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                </select>
            </div>

            <div>
                <label class="block font-semibold">Sec</label>
                <select name="sec" id="sec" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">All Sec</option>
                    <option value="I">I</option>
                    <option value="II">II</option>
                    <option value="III">III</option>
                </select>
            </div>
        </div>

        <!-- Filter Button -->
        <div class="text-center mb-6">
            <button 
                type="button" 
                onclick="loadMarks()" 
                class="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700"
            >
                Load Marks
            </button>
        </div>
    </form>

    <!-- Marks List -->
    <div id="marksListContainer" class="mt-6" style="display: none;">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-semibold">Marks List</h3>
            <button 
                onclick="saveAllMarks()" 
                class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700"
            >
                Save All Changes
            </button>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full bg-white border">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 border">S/N</th>
                        <th class="px-4 py-2 border">Army Number</th>
                        <th class="px-4 py-2 border">Rank</th>
                        <th class="px-4 py-2 border">Name</th>
                        <th class="px-4 py-2 border">Bn</th>
                        <th class="px-4 py-2 border">Coy</th>
                        <th class="px-4 py-2 border">Pl</th>
                        <th class="px-4 py-2 border">Sec</th>
                        <th class="px-4 py-2 border">Marks</th>
                        <th class="px-4 py-2 border">Action</th>
                    </tr>
                </thead>
                <tbody id="marksList">
                    <!-- Dynamically populated -->
                </tbody>
            </table>
        </div>
    </div>

    <!-- Student Marks Modal (for single student search) -->
    <div id="studentMarksModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 shadow-lg rounded-md bg-white">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-semibold" id="studentModalTitle">Student Marks</h3>
                <button onclick="closeStudentModal()" class="text-gray-600 hover:text-gray-900 text-2xl">&times;</button>
            </div>
            
            <div id="studentMarksContent" class="overflow-x-auto">
                <!-- Dynamically populated -->
            </div>
        </div>
    </div>

    <!-- Loading Spinner -->
    <div id="loading" style="display: none;" class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-white p-5 rounded-lg flex items-center">
            <div class="loader ease-linear rounded-full border-4 border-t-4 border-gray-200 h-12 w-12"></div>
            <span class="ml-3 text-gray-700">Loading...</span>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Load marks based on filters
function loadMarks() {
    const filters = {
        school_id: $('#school_id').val(),
        course_id: $('#course_id').val(),
        intake_id: $('#intake_id').val(),
        phase: $('#phase').val(),
        assessment_type: $('#assessment_type').val(),
        assessment_group: $('#assessment_group').val(),
        type: $('#type').val(),
        subject_id: $('#subject_id').val(),
        bn: $('#bn').val(),
        coy: $('#coy').val(),
        pl: $('#pl').val(),
        sec: $('#sec').val()
    };

    $('#loading').show();

    $.ajax({
        url: "{{ route('marks.getFiltered') }}",
        method: 'GET',
        data: filters,
        success: function(marks) {
            displayMarks(marks);
            $('#marksListContainer').show();
            $('#loading').hide();
        },
        error: function(xhr) {
            $('#loading').hide();
            showError('Error loading marks: ' + xhr.responseText);
        }
    });
}

// Display marks in table
function displayMarks(marks) {
    const tbody = $('#marksList');
    tbody.empty();

    if (marks.length === 0) {
        tbody.html('<tr><td colspan="10" class="text-center py-4 text-gray-500">No marks found</td></tr>');
        return;
    }

    // Sort alphabetically by name
    marks.sort((a, b) => a.name.localeCompare(b.name));

    marks.forEach((mark, index) => {
        const isDecommissioned = mark.is_decommissioned;
        const rowClass = isDecommissioned ? 'bg-red-50' : '';
        
        tbody.append(`
            <tr class="${rowClass}" data-mark-id="${mark.id}">
                <td class="px-4 py-2 border text-center">${index + 1}</td>
                <td class="px-4 py-2 border">${mark.army_number}</td>
                <td class="px-4 py-2 border">${mark.rank}</td>
                <td class="px-4 py-2 border">${mark.name}</td>
                <td class="px-4 py-2 border text-center">${mark.bn}</td>
                <td class="px-4 py-2 border text-center">${mark.coy}</td>
                <td class="px-4 py-2 border text-center">${mark.pl}</td>
                <td class="px-4 py-2 border text-center">${mark.sec}</td>
                <td class="px-4 py-2 border">
                    <input 
                        type="number" 
                        class="mark-input w-20 px-2 py-1 border rounded ${isDecommissioned ? 'bg-gray-100' : ''}"
                        data-mark-id="${mark.id}"
                        value="${mark.marks}"
                        min="0"
                        max="100"
                        ${isDecommissioned ? 'disabled' : ''}
                    >
                </td>
                <td class="px-4 py-2 border text-center">
                    <button 
                        onclick="updateSingleMark(${mark.id})" 
                        class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600 text-sm"
                        ${isDecommissioned ? 'disabled' : ''}
                    >
                        Update
                    </button>
                </td>
            </tr>
        `);
    });
}

// Update single mark
function updateSingleMark(markId) {
    const input = $(`.mark-input[data-mark-id="${markId}"]`);
    const marks = input.val();

    if (!marks || marks < 0 || marks > 100) {
        showError('Please enter a valid mark (0-100)');
        return;
    }

    $('#loading').show();

    $.ajax({
        url: `{{ url('marks/update') }}/${markId}`,
        method: 'PUT',
        data: {
            _token: $('input[name="_token"]').val(),
            marks: marks
        },
        success: function(response) {
            $('#loading').hide();
            showSuccess('Mark updated successfully');
            input.addClass('border-green-500');
            setTimeout(() => input.removeClass('border-green-500'), 2000);
        },
        error: function(xhr) {
            $('#loading').hide();
            showError('Error updating mark: ' + xhr.responseText);
        }
    });
}

// Save all marks
function saveAllMarks() {
    const marksData = [];
    
    $('.mark-input:not([disabled])').each(function() {
        const markId = $(this).data('mark-id');
        const marks = $(this).val();
        
        if (marks && marks >= 0 && marks <= 100) {
            marksData.push({
                id: markId,
                marks: marks
            });
        }
    });

    if (marksData.length === 0) {
        showError('No valid marks to save');
        return;
    }

    $('#loading').show();

    $.ajax({
        url: "{{ route('marks.bulkUpdate') }}",
        method: 'POST',
        data: {
            _token: $('input[name="_token"]').val(),
            marks: marksData
        },
        success: function(response) {
            $('#loading').hide();
            showSuccess(response.message);
        },
        error: function(xhr) {
            $('#loading').hide();
            showError('Error saving marks: ' + xhr.responseText);
        }
    });
}

// Search by admission ID
function searchByAdmissionId() {
    const admissionId = $('#searchAdmissionId').val();
    
    if (!admissionId) {
        showError('Please enter an admission ID');
        return;
    }

    $('#loading').show();

    $.ajax({
        url: `{{ url('marks/student') }}/${admissionId}`,
        method: 'GET',
        success: function(marks) {
            $('#loading').hide();
            displayStudentMarks(marks);
        },
        error: function(xhr) {
            $('#loading').hide();
            showError('Student not found or no marks available');
        }
    });
}

// Display student marks in modal
function displayStudentMarks(marks) {
    if (marks.length === 0) {
        showError('No marks found for this student');
        return;
    }

    const studentInfo = marks[0].student_info;
    $('#studentModalTitle').text(`${studentInfo.army_number} - ${studentInfo.rank} ${studentInfo.name}`);

    let content = `
        <table class="min-w-full bg-white border">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-2 border">Phase</th>
                    <th class="px-4 py-2 border">Assessment</th>
                    <th class="px-4 py-2 border">Type</th>
                    <th class="px-4 py-2 border">Subject/Exercise</th>
                    <th class="px-4 py-2 border">Marks</th>
                    <th class="px-4 py-2 border">Action</th>
                </tr>
            </thead>
            <tbody>
    `;

    marks.forEach(mark => {
        content += `
            <tr>
                <td class="px-4 py-2 border">${mark.phase}</td>
                <td class="px-4 py-2 border">${mark.assessment_type} - ${mark.assessment_group}</td>
                <td class="px-4 py-2 border">${mark.type}</td>
                <td class="px-4 py-2 border">${mark.subject || mark.exercises || 'N/A'}</td>
                <td class="px-4 py-2 border">
                    <input 
                        type="number" 
                        class="modal-mark-input w-20 px-2 py-1 border rounded"
                        data-mark-id="${mark.id}"
                        value="${mark.marks}"
                        min="0"
                        max="100"
                    >
                </td>
                <td class="px-4 py-2 border text-center">
                    <button 
                        onclick="updateModalMark(${mark.id})" 
                        class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600 text-sm"
                    >
                        Update
                    </button>
                </td>
            </tr>
        `;
    });

    content += '</tbody></table>';
    $('#studentMarksContent').html(content);
    $('#studentMarksModal').removeClass('hidden');
}

// Update mark from modal
function updateModalMark(markId) {
    const input = $(`.modal-mark-input[data-mark-id="${markId}"]`);
    const marks = input.val();

    if (!marks || marks < 0 || marks > 100) {
        showError('Please enter a valid mark (0-100)');
        return;
    }

    $.ajax({
        url: `{{ url('marks/update') }}/${markId}`,
        method: 'PUT',
        data: {
            _token: $('input[name="_token"]').val(),
            marks: marks
        },
        success: function(response) {
            showSuccess('Mark updated successfully');
            input.addClass('border-green-500');
            setTimeout(() => input.removeClass('border-green-500'), 2000);
        },
        error: function(xhr) {
            showError('Error updating mark');
        }
    });
}

// Close modal
function closeStudentModal() {
    $('#studentMarksModal').addClass('hidden');
    $('#searchAdmissionId').val('');
}

// Helper functions
function showSuccess(message) {
    $('#successMessage').text(message).show();
    setTimeout(() => $('#successMessage').hide(), 5000);
}

function showError(message) {
    $('#errorMessage').text(message).show();
    setTimeout(() => $('#errorMessage').hide(), 5000);
}

// Auto-load marks when filters change
$(document).ready(function() {
    $('#filterForm select').change(function() {
        // Optional: Auto-load when filters change
        // loadMarks();
    });
});
</script>

<style>
.loader {
    border-top-color: #3498db;
    animation: spinner 1.5s linear infinite;
}

@keyframes spinner {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
</style>
@endpush
@endsection