@extends('layouts.app')

@section('content')
    <div class="container mx-auto p-4">
        <div class="mb-6">
            <h2 class="text-3xl font-bold text-gray-900">Marks Overview</h2>

            <!-- Search Form -->
            <div class="mt-4 mb-6">
                <form action="{{ route('marks.index2') }}" method="GET" class="space-y-6">
                    <!-- Search Input -->
                    <div class="flex gap-4 items-center">
                        <div class="flex-1">
                            <input
                                type="text"
                                name="search"
                                placeholder="Search by name, army number or rank..."
                                value="{{ request('search') }}"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500"
                            >
                        </div>
                        <button
                            type="submit"
                            class="px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2"
                        >
                            Search
                        </button>
                        @if(request()->hasAny(['search', 'assessment_type', 'assessment_group', 'type', 'weeks', 'subject_id', 'exercises', 'bn', 'coy', 'pl', 'sel']))
                            <a
                                href="{{ route('marks.index2') }}"
                                class="px-6 py-3 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2"
                            >
                                Clear All
                            </a>
                        @endif
                    </div>

                    <!-- Filters Grid -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Assessment Type -->
                        <div>
                            <label class="block font-semibold text-gray-700">Assessment Type</label>
                            <select name="assessment_type" id="choose_assessment_type" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Assessment Type</option>
                                <option value="MSK" {{ request('assessment_type') == 'MSK' ? 'selected' : '' }}>MSK</option>

                            </select>
                        </div>

                        <!-- Assessment Group -->
                        <div id="assessment_group" style="display: {{ request('assessment_group') ? 'block' : 'none' }};">
                            <label class="block font-semibold text-gray-700">Assessment Group</label>
                            <select name="assessment_group" id="choose_assessment_group" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Assessment Group</option>
                                <!-- Add your dynamic groups here -->
                            </select>
                        </div>

                        <!-- Exam Type -->
                        <div id="type" style="display: {{ request('type') ? 'block' : 'none' }};">
                            <label class="block font-semibold text-gray-700">Exam Type</label>
                            <select name="type" id="choose_type" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Exam Type</option>
                                <!-- Add your dynamic exam types here -->
                            </select>
                        </div>

                        <!-- Subject -->
                        <div id="subject" style="display: {{ request('subject_id') ? 'block' : 'none' }};">
                            <label class="block font-semibold text-gray-700">Subject</label>
                            <select name="subject_id" id="choose_subject" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Subject</option>
                                @foreach($subjects ?? [] as $subject)
                                    <option value="{{ $subject->id }}" {{ request('subject_id') == $subject->id ? 'selected' : '' }}>{{ $subject->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Weeks -->
                        <div id="weeks" style="display: {{ request('weeks') ? 'block' : 'none' }};">
                            <label class="block font-semibold text-gray-700">Weeks</label>
                            <select name="weeks" id="choose_weeks" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Week</option>
                                @for($i = 1; $i <= 10; $i++)
                                    <option value="week{{ $i }}" {{ request('weeks') == "week{$i}" ? 'selected' : '' }}>Week {{ $i }}</option>
                                @endfor
                            </select>
                        </div>

                        <!-- Exercises -->
                        <div id="exercises" style="display: {{ request('exercises') ? 'block' : 'none' }};">
                            <label class="block font-semibold text-gray-700">Exercises</label>
                            <select name="exercises" id="choose_exercises" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Exercise</option>
                                @foreach(['PT', 'SAA', 'DR', 'TAC', 'MU'] as $exercise)
                                    <option value="{{ $exercise }}" {{ request('exercises') == $exercise ? 'selected' : '' }}>{{ $exercise }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Bn/Regt -->
                        <div>
                            <label class="block font-semibold text-gray-700">Bn</label>
                            <select name="bn" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Bn</option>
                                @foreach(['kagera'] as $bnRegt)
                                    <option value="{{ $bnRegt }}" {{ request('bn') == $bnRegt ? 'selected' : '' }}>{{ ucfirst($bnRegt) }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Coy -->
                        <div>
                            <label class="block font-semibold text-gray-700">Coy</label>
                            <select name="coy" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Coy</option>
                                @foreach(['a', 'b', 'c'] as $coy)
                                    <option value="{{ $coy }}" {{ request('coy') == $coy ? 'selected' : '' }}>{{ strtoupper($coy) }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Pl -->
                        <div>
                            <label class="block font-semibold text-gray-700">Pl</label>
                            <select name="pl" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Pl</option>
                                @foreach(['1', '2', '3'] as $pl)
                                    <option value="{{ $pl }}" {{ request('pl') == $pl ? 'selected' : '' }}>{{ $pl }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Sec -->
                        <div>
                            <label class="block font-semibold text-gray-700">Sec</label>
                            <select name="sec" class="w-full mt-1 px-4 py-3 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Select Sec</option>
                                @foreach(['I', 'II', 'III'] as $sec)
                                    <option value="{{ $sec }}" {{ request('sec') == $sec ? 'selected' : '' }}>{{ $sec }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Filter Submit -->
                    <div class="mt-4">
                        <button type="submit" class="bg-blue-500 text-white px-6 py-2 rounded-lg">Apply Filters</button>
                    </div>


                </form>
            </div>

            <!-- Bulk Delete Button -->
            @if(Auth::user()->type == 'admin')
                <form id="bulk-delete-form" action="{{ route('marks.bulkDelete') }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <div class="flex justify-between items-center mb-6">
                        <button type="submit" class="bg-red-600 text-white px-6 py-3 rounded-lg hover:bg-red-700"
                                onclick="return confirm('Are you sure you want to delete selected records?');">
                            Bulk Delete
                        </button>
                    </div>
                </form>
            @endif

            <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead>
                        <tr class="bg-gray-50">
                            @if(Auth::user()->type == 'admin')
                                <th class="px-6 py-3">
                                    <input type="checkbox" id="select-all">
                                </th>
                            @endif
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Army Number
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Rank
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Cadet Name
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Marks & Weight
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Action
                            </th>
                        </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($marks as $studentData)
                            @php
                                $firstMark = $studentData->first();
                            @endphp
                            <tr class="hover:bg-gray-50">
                                @if(Auth::user()->type == 'admin')
                                    <td class="px-6 py-4">
                                        <input type="checkbox" name="selected_ids[]" value="{{ $firstMark->id }}" class="select-item">
                                    </td>
                                @endif
                                <td class="px-6 py-4">{{ $firstMark->admission->army_number }}</td>
                                <td class="px-6 py-4">{{ $firstMark->admission->rank }}</td>
                                <td class="px-6 py-4">{{ $firstMark->admission->name }}</td>
                                <td class="px-6 py-4">
                                    <ul class="space-y-2">
                                        @foreach($studentData as $mark)
                                            @php
                                                $weightedMark = ($mark->marks / 100) * $mark->weight;
                                            @endphp
                                            <li class="flex justify-between">
                                                <span>
                                                    {{ $mark->subject->code ?? '' }}
                                                    {{ $mark->exercises ?? '' }}

                                                    @if (!empty($mark->type))
                                                        @php
                                                            $words = explode(' ', $mark->type);

                                                            $initials = '';
                                                            foreach ($words as $word) {
                                                                $initials .= strtoupper($word[0]);
                                                            }
                                                        @endphp
                                                        ({{ $initials }}{{!empty($mark->week) ? substr($mark->week, -1) : ' '}})

                                                    @endif

                                                    {{ $mark->marks }}%
                                                </span>
                                                <span>{{ number_format($weightedMark, 2) }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </td>
                                <td class="px-6 py-4">
                                    <ul class="space-y-2">
                                        @foreach($studentData as $mark)
                                            <li class="flex justify-start items-center">
                                                <a href="{{ route('marks.edit', $mark->id) }}" class="text-blue-600 hover:underline">Edit</a>
                                                @if(Auth::user()->type == 'admin')
                                                    <form action="{{ route('marks.destroy', $mark->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this assessment?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="ml-4 text-red-600 hover:underline">Delete</button>
                                                    </form>
                                                @endif
                                            </li>
                                        @endforeach
                                    </ul>
                                </td>
                            </tr>
                        @endforeach
                        @if($marks->isEmpty())
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                                    No assessments found
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="mt-6">
                {{ $marks->appends(request()->query())->links() }}
            </div>



            <!-- Rows Per Page -->
            <form method="GET" action="{{ route('marks.index2') }}" class="mb-4 flex space-x-4 mt-10">
                <select name="per_page" onchange="this.form.submit()" class="border-gray-300 rounded-lg p-2">
                    @foreach([25, 50, 100, 250, 500] as $size)
                        <option value="{{ $size }}" {{ request('per_page', 25) == $size ? 'selected' : '' }}>
                            Show {{ $size }} rows
                        </option>
                    @endforeach
                </select>
            </form>

            <!-- Pagination -->

        </div>
    </div>

    <script>
        document.getElementById('select-all').addEventListener('change', function () {
            const checkboxes = document.querySelectorAll('.select-item');
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
        });


        function toggleContainer(id, show) {
            document.getElementById(id).style.display = show ? 'block' : 'none';
        }

        // Handle changes in assessment type, assessment group, etc.
        $('#choose_assessment_type').change(function () {
            const assessmentType = $(this).val();
            toggleContainer('assessment_group', !!assessmentType);
            toggleContainer('type', false);
            toggleContainer('weeks', false);
            toggleContainer('subject', false);
            toggleContainer('exercises', false);

            let options = '<option value="">Select Assessment Group</option>';
            if (assessmentType === 'MSK') {
                options += '<option value="Theory">Theory</option><option value="Practical">Practical</option>';
            } else if (assessmentType === 'Character Assessment') {
                options += '<option value="22 CR">22 CR</option><option value="PR">PR</option>';
            }
            $('#choose_assessment_group').html(options);
        });

        // Handle assessment group change
        $('#choose_assessment_group').change(function () {
            const assessmentGroup = $(this).val();
            toggleContainer('type', !!assessmentGroup);
            toggleContainer('weeks', false);
            toggleContainer('subject', false);
            toggleContainer('exercises', false);

            if (assessmentGroup === 'Theory') {
                $('#choose_type').html('<option value="">Select Exam Type</option><option value="Weekly">Weekly</option><option value="Monthly">Monthly</option><option value="End of Phase Exam">End of Phase Exam</option>');
            } else if (assessmentGroup === 'Practical') {
                $('#choose_type').html('<option value="">Select Exam Type</option><option value="Weekly">Weekly</option>');
            }
        });

        // Handle Exam Type change to show subjects
        $('#choose_type').change(function () {
            const examType = $(this).val();
            const assessmentGroup = $('#choose_assessment_group').val();

            if (assessmentGroup === 'Theory' && examType === 'End of Phase Exam') {
                toggleContainer('subject', true);
            } else {
                toggleContainer('subject', false);
            }
        });

        // Function to show/hide filter containers
        function toggleContainer(id, show) {
            document.getElementById(id).style.display = show ? 'block' : 'none';
        }

        // Handle changes in assessment type
        $('#choose_assessment_type').change(function () {
            const assessmentType = $(this).val();
            toggleContainer('assessment_group', !!assessmentType);
            toggleContainer('type', false);
            toggleContainer('weeks', false);
            toggleContainer('subject', false);
            toggleContainer('exercises', false);

            let options = '<option value="">Select Assessment Group</option>';
            if (assessmentType === 'MSK') {
                options += '<option value="Theory">Theory</option><option value="Practical">Practical</option>';
            } else if (assessmentType === 'Character Assessment') {
                options += '<option value="22 CR">22 CR</option><option value="PR">PR</option>';
            }
            $('#choose_assessment_group').html(options);
        });

        // Handle changes in assessment group
        $('#choose_assessment_group').change(function () {
            const assessmentGroup = $(this).val();
            toggleContainer('type', !!assessmentGroup);
            toggleContainer('weeks', false);
            toggleContainer('subject', false);
            toggleContainer('exercises', false);

            let options = '<option value="">Select Exam Type</option>';
            if (assessmentGroup === 'Theory') {
                options += '<option value="Weekly">Weekly</option><option value="Monthly">Monthly</option><option value="End of Phase Exam">End of Phase Exam</option>';
            } else if (assessmentGroup === 'Practical') {
                options += '<option value="Weekly">Weekly</option>';
            }
            $('#choose_type').html(options);
        });

        // Handle changes in exam type
        $('#choose_type').change(function () {
            const examType = $(this).val();
            const assessmentGroup = $('#choose_assessment_group').val();

            toggleContainer('subject', false);
            toggleContainer('exercises', false);

            if (assessmentGroup === 'Theory' && examType === 'End of Phase Exam') {
                toggleContainer('subject', true);
            } else if (assessmentGroup === 'Practical' && examType === 'Weekly') {
                toggleContainer('exercises', true);
            }
        });

        // Function to show/hide filter containers
        function toggleContainer(id, show) {
            document.getElementById(id).style.display = show ? 'block' : 'none';
        }
    </script>

@endsection
