<!-- Table Cell -->
<td class="py-1.5 px-2 border relative group transition-colors duration-150 {{ isset($isMonthly) ? 'bg-blue-50 hover:bg-blue-100' : (isset($isEope) ? 'bg-purple-50 hover:bg-purple-100' : 'hover:bg-gray-50') }}">
    @if(isset($weeklyMarks[$week]) && count($weeklyMarks[$week]) > 0)
        <div class="space-y-1">
            <!-- Sort Controls -->
            <div class="flex justify-end mb-1">
                <button onclick="sortMarks(this, 'asc')" class="text-xs text-gray-500 hover:text-gray-700 px-1">↑</button>
                <button onclick="sortMarks(this, 'desc')" class="text-xs text-gray-500 hover:text-gray-700 px-1">↓</button>
            </div>
            <div class="marks-container">
                @foreach($weeklyMarks[$week]->sortBy('marks') as $mark)
                    <div class="text-xs leading-tight relative rounded p-1 hover:bg-white hover:shadow-sm transition-all duration-200">
                        <!-- Header: Subject/Exercise Code -->
                        <div class="flex justify-between items-center mb-0.5">
                            <span class="{{ $mark->assessment_group === 'Theory' ? 'text-blue-600' : 'text-green-600' }} font-semibold truncate max-w-[90%]" title="{{ $mark->assessment_group === 'Theory' ? ($mark->subject->name ?? '') : ($mark->exercises ?? '') }}">
                                {{ $mark->assessment_group === 'Theory' ? ($mark->subject->code ?? '') : ($mark->exercises ?? '') }}
                            </span>
                        </div>

                        <!-- Marks Display -->
                        <a href="{{ route('marks.edit', $mark->id) }}"
                           class="flex justify-between items-center cursor-pointer rounded transition-colors duration-150 hover:bg-gray-50">
                            <div class="font-medium {{ isset($isMonthly) ? 'text-blue-700' : (isset($isEope) ? 'text-purple-700' : 'text-gray-700') }}">
                                <span class="mark-value">{{ number_format($mark->marks, 1) }}% @if($mark->month) ({{$mark->month}}) @endif</span>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    @else
        <div class="h-6 flex items-center justify-center">
            <span class="text-gray-400 text-xs">No marks</span>
        </div>
    @endif
</td>

<!-- Add this script at the bottom of the file -->
<script>
function sortMarks(button, direction) {
    const container = button.closest('td').querySelector('.marks-container');
    const marks = Array.from(container.children);
    
    marks.sort((a, b) => {
        const valueA = parseFloat(a.querySelector('.mark-value').textContent);
        const valueB = parseFloat(b.querySelector('.mark-value').textContent);
        return direction === 'asc' ? valueA - valueB : valueB - valueA;
    });
    
    marks.forEach(mark => container.appendChild(mark));
}
</script>