@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="bg-white shadow-md rounded-lg overflow-hidden mt-6">
        <div class="flex items-center justify-between px-6 py-4 border-b border-gray-200">
            <h5 class="text-lg font-semibold text-gray-800">Edit Phase Configuration</h5>
            <a href="{{ route('phase-config.index') }}" class="bg-gray-500 text-white text-sm px-3 py-1.5 rounded hover:bg-gray-600 inline-flex items-center">
                <i class="fas fa-arrow-left mr-1"></i> Back to Phase Configurations
            </a>
        </div>

        <div class="px-6 py-4">
            @if ($errors->any())
                <div class="bg-red-100 text-red-800 px-4 py-3 rounded mb-4">
                    <ul class="list-disc pl-5">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form method="POST" action="{{ route('phase-config.update', $phase->id) }}">
                @csrf
                @method('PUT')

                <!-- Phase Name -->
                <div class="mb-4">
                    <label for="phase_name" class="block font-medium text-sm text-gray-700">Phase Name</label>
                    <input id="phase_name" name="phase_name" type="text" value="{{ old('phase_name', $phase->phase_name) }}" required
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 @error('phase_name') border-red-500 @enderror">
                    @error('phase_name')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Section Configs -->
                @php
                    $configs = [
                        'MSK Theory' => ['theory_max_score' => $phase->msk_theory_config['max_score'], 'theory_pass_mark' => $phase->msk_theory_config['pass_mark']],
                        'MSK Practical' => ['practical_max_score' => $phase->msk_practical_config['max_score'], 'practical_pass_mark' => $phase->msk_practical_config['pass_mark']],
                        'Character 22CR' => ['cr22_max_score' => $phase->character_22cr_config['max_score'], 'cr22_pass_mark' => $phase->character_22cr_config['pass_mark']],
                        'Character PR' => ['pr_max_score' => $phase->character_pr_config['max_score'], 'pr_pass_mark' => $phase->character_pr_config['pass_mark']],
                    ];
                @endphp

                @foreach ($configs as $section => $fields)
                    <h5 class="text-lg font-semibold text-gray-700 mt-6 mb-3 border-b pb-2">{{ $section }} Configuration</h5>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach ($fields as $name => $value)
                            <div>
                                <label for="{{ $name }}" class="block font-medium text-sm text-gray-700">
                                    {{ ucwords(str_replace('_', ' ', $name)) }}
                                </label>
                                <input id="{{ $name }}" name="{{ $name }}" type="number" step="0.01"
                                       value="{{ old($name, $value) }}"
                                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 @error($name) border-red-500 @enderror" required>
                                @error($name)
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        @endforeach
                    </div>
                @endforeach

                <!-- Active Checkbox -->
                <div class="mt-6">
                    <label class="inline-flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1"
                               class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                               {{ old('is_active', $phase->is_active) ? 'checked' : '' }}>
                        <span class="ml-2 text-sm text-gray-600">Set as active phase (will deactivate any currently active phase)</span>
                    </label>
                </div>

                <!-- Buttons -->
                <div class="mt-6 flex gap-3">
                    <button type="submit"
                            class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700"
                            onclick="return confirm('Are you sure you want to update this phase configuration? This will affect student evaluation calculations.')">
                        <i class="fas fa-save mr-1"></i> Update Phase Configuration
                    </button>
                    <a href="{{ route('phase-config.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">
                        <i class="fas fa-times mr-1"></i> Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
