@extends('layouts.app')
@section('title', 'P')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-center">
        <div class="w-full">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <div class="flex items-center justify-between px-6 py-4 border-b border-gray-200">

                
                    <h5 class="text-lg font-semibold text-gray-800">Phase Configurations</h5>
                    <div class="flex gap-2">
                        <a href="{{ route('phase-config.create') }}" class="bg-blue-600 text-white text-sm px-3 py-1.5 rounded hover:bg-blue-700 inline-flex items-center">
                            <i class="fas fa-plus mr-1"></i> Create New Phase
                        </a>
                        <a href="{{ route('phase-config.edit-grades') }}" class="bg-cyan-600 text-white text-sm px-3 py-1.5 rounded hover:bg-cyan-700 inline-flex items-center">
                            <i class="fas fa-graduation-cap mr-1"></i> Edit Grade Scales
                        </a>
                    </div>
                </div>

                <div class="px-6 py-4">
                    <div class="bg-yellow-100 text-yellow-800 px-4 py-3 rounded mb-4 flex items-start gap-2">
                        <i class="fas fa-exclamation-triangle mt-1"></i>
                        <div>
                            <strong>Warning:</strong> Editing these configurations will directly affect how student evaluations are calculated.
                            Incorrect configurations may result in erroneous assessment results. Please ensure changes are accurate and properly approved.
                        </div>
                    </div>

                    @if (session('success'))
                        <div class="bg-green-100 text-green-800 px-4 py-3 rounded mb-4">
                            {{ session('success') }}
                        </div>
                    @endif

                    <h5 class="text-lg font-semibold text-gray-700 mb-3">Phase Configurations</h5>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white border border-gray-200 text-sm">
                            <thead class="bg-gray-800 text-white">
                                <tr>
                                    <th class="px-4 py-2 text-left">Phase Name</th>
                                    <th class="px-4 py-2 text-left">Theory (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">Practical (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">22CR (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">PR (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">Status</th>
                                    <th class="px-4 py-2 text-left">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($phases as $phase)
                                <tr>
                                    <td class="px-4 py-2">{{ $phase->phase_name }}</td>
                                    <td class="px-4 py-2">{{ $phase->msk_theory_config['max_score'] }} / {{ $phase->msk_theory_config['pass_mark'] }}</td>
                                    <td class="px-4 py-2">{{ $phase->msk_practical_config['max_score'] }} / {{ $phase->msk_practical_config['pass_mark'] }}</td>
                                    <td class="px-4 py-2">{{ $phase->character_22cr_config['max_score'] }} / {{ $phase->character_22cr_config['pass_mark'] }}</td>
                                    <td class="px-4 py-2">{{ $phase->character_pr_config['max_score'] }} / {{ $phase->character_pr_config['pass_mark'] }}</td>
                                    <td class="px-4 py-2">
                                        @if($phase->is_active)
                                            <span class="inline-block px-2 py-1 text-xs font-semibold text-green-800 bg-green-200 rounded">Active</span>
                                        @else
                                            <span class="inline-block px-2 py-1 text-xs font-semibold text-gray-600 bg-gray-200 rounded">Inactive</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-2 space-x-2">
                                        <a href="{{ route('phase-config.edit', $phase->id) }}" class="inline-block bg-blue-500 text-white text-xs px-3 py-1 rounded hover:bg-blue-600">
                                            <i class="fas fa-edit mr-1"></i> Edit
                                        </a>
                                        {{-- @if(!$phase->is_active)
                                            <a href="{{ route('phase-config.set-active', $phase->id) }}"
                                               class="inline-block bg-green-600 text-white text-xs px-3 py-1 rounded hover:bg-green-700"
                                               onclick="return confirm('Are you sure you want to set this phase as active? This will deactivate all other phases.')">
                                                <i class="fas fa-check mr-1"></i> Set Active
                                            </a>
                                        @endif --}}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <h5 class="text-lg font-semibold text-gray-700 mt-8 mb-3">Grade Scales</h5>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white border border-gray-200 text-sm">
                            <thead class="bg-gray-800 text-white">
                                <tr>
                                    <th class="px-4 py-2 text-left">Grade</th>
                                    <th class="px-4 py-2 text-left">Minimum Score (%)</th>
                                    <th class="px-4 py-2 text-left">Comment</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($gradeScales as $grade)
                                <tr>
                                    <td class="px-4 py-2">{{ $grade->grade }}</td>
                                    <td class="px-4 py-2">{{ $grade->min_score }}</td>
                                    <td class="px-4 py-2">{{ $grade->comment }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
