@extends('layouts.app')
@section('title', 'Create New Phase')
@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Create New Phase</h2>

    <form action="{{ route('phase.store') }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        <div class="mb-4">
            <label for="name" class="block text-gray-700 font-semibold mb-2">Phase</label>
            <input type="text" name="name" id="name" class="w-full p-3 border border-gray-300 rounded" required>
        </div>
        <div class="mb-4">
            <label for="weeks" class="block text-gray-700 font-semibold mb-2">Weeks</label>
            <input type="number" name="weeks" id="weeks" class="w-full p-3 border border-gray-300 rounded" required>
        </div>


        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Create Phase</button>
    </form>
</div>
@endsection
