@extends('layouts.app')
@section('title', 'Edit Cres')
@section('content')
    <div class="container mx-auto py-8">
        <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Cres</h2>

        <form action="{{ route('phase.update', $phase) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
            @csrf
            @method('PUT')
            <div class="mb-4">
                <label for="name" class="block text-gray-700 font-semibold mb-2">Phase</label>
                <input disabled type="text" name="name" id="name" value="{{ old('name', $phase->name) }}" class="w-full p-3 border border-gray-300 rounded" required>
            </div>



                    <div class="mb-4">
                        <label for="cres_weight" class="block text-gray-700 font-semibold mb-2">cres_weight</label>
                        <input type="number" name="cres_weight" id="cres_weight" value="{{ old('cres_weight', $phase->cres_weight) }}" class="w-full p-3 border border-gray-300 rounded" required>
                    </div>


            <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Update Cres</button>
        </form>
    </div>
@endsection
