@extends('layouts.app')
@section('title', 'Edit Phase')
@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Phase</h2>

    <form action="{{ route('phase.update', $phase) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        @method('PUT')
        <div class="mb-4">
            <label for="name" class="block text-gray-700 font-semibold mb-2">Pl</label>
            <input readonly type="text" name="name" id="name" value="{{ old('name', $phase->name) }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

        <div class="mb-4">
            <label for="weeks" class="block text-gray-700 font-semibold mb-2">Weeks</label>
            <input type="number" name="weeks" id="weeks" value="{{ old('weeks', $phase->weeks) }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

{{--        <div class="mb-4">--}}
{{--            <label for="cres_weight" class="block text-gray-700 font-semibold mb-2">cres_weight</label>--}}
{{--            <input type="number" name="cres_weight" id="cres_weight" value="{{ old('cres_weight', $phase->cres_weight) }}" class="w-full p-3 border border-gray-300 rounded" required>--}}
{{--        </div>--}}
{{--        <div class="mb-4">--}}
{{--            <label for="pr_weight" class="block text-gray-700 font-semibold mb-2">pr_weight</label>--}}
{{--            <input type="number" name="pr_weight" id="pr_weight" value="{{ old('pr_weight', $phase->pr_weight) }}" class="w-full p-3 border border-gray-300 rounded" required>--}}
{{--        </div>--}}

        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Update Phase</button>
    </form>
</div>
@endsection
