@extends('layouts.app')
@section('title', 'Edit Pl')
@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Pl</h2>

    {{-- Error & Success Messages --}}
    @if ($errors->any())
        <div class="mb-4 p-4 bg-red-100 text-red-700 rounded-lg">
            <strong>Whoops! Something went wrong.</strong>
            <ul class="mt-2">
                @foreach ($errors->all() as $error)
                    <li>- {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if (session('error'))
        <div class="mb-4 p-4 bg-red-100 text-red-700 rounded-lg">
            <strong>Error:</strong> {{ session('error') }}
        </div>
    @endif

    @if (session('success'))
        <div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">
            <strong>Success:</strong> {{ session('success') }}
        </div>
    @endif

    {{-- Form --}}
    <form action="{{ route('pl.update', $pl) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            {{-- Select Bn --}}
            <div>
                <label for="bn_id" class="block text-gray-700 font-semibold mb-2">Select Bn</label>
                <select name="bn_id" id="bn_id" class="w-full p-3 border border-gray-300 rounded" required>
                    <option value="">Choose a Bn</option>
                    @foreach($bns as $bn)
                        <option value="{{ $bn->id }}" {{ old('bn_id', $pl->bn_id) == $bn->id ? 'selected' : '' }}>{{ $bn->name }}</option>
                    @endforeach
                </select>
            </div>

            {{-- Select Coy --}}
            <div>
                <label for="coy_id" class="block text-gray-700 font-semibold mb-2">Select Coy</label>
                <select name="coy_id" id="coy_id" class="w-full p-3 border border-gray-300 rounded" required>
                    <option value="">Choose a Coy</option>
                    @foreach($coys as $coy)
                        <option value="{{ $coy->id }}" {{ old('coy_id', $pl->coy_id) == $coy->id ? 'selected' : '' }}>{{ $coy->name }}</option>
                    @endforeach
                </select>
            </div>

            {{-- Select Platoon --}}
            <div>
                <label for="name" class="block text-gray-700 font-semibold mb-2">Pl</label>
                <select name="name" id="name" class="w-full p-3 border border-gray-300 rounded" required>
                    <option value="">Select Pl</option>
                    <option value="1" {{ old('name', $pl->name) == '1' ? 'selected' : '' }}>1</option>
                    <option value="2" {{ old('name', $pl->name) == '2' ? 'selected' : '' }}>2</option>
                    <option value="3" {{ old('name', $pl->name) == '3' ? 'selected' : '' }}>3</option>
                </select>
            </div>

            {{-- Commander Rank --}}
            <div>
                <label for="comd_rank" class="block text-gray-700 font-medium mb-2">Rank</label>
                <select name="comd_rank" id="comd_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
                    @php
                        $ranks = [
                            'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                            'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                            'L/Cpl', 'Pte'
                        ];
                    @endphp
                    @foreach($ranks as $rank)
                        <option value="{{ $rank }}" {{ old('comd_rank', $pl->comd_rank) == $rank ? 'selected' : '' }}>{{ $rank }}</option>
                    @endforeach
                </select>
            </div>

            {{-- Commander Name --}}
            <div>
                <label for="comd_name" class="block text-gray-700 font-medium mb-2">Pl Comd Name</label>
                <input type="text" name="comd_name" id="comd_name" value="{{ old('comd_name', $pl->comd_name) }}" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
            </div>

            {{-- Pl Sgt --}}
            <div>
                <label for="pl_sgt" class="block text-gray-700 font-medium mb-2">Pl Sgt</label>
                <input type="text" name="pl_sgt" id="pl_sgt" value="{{ old('pl_sgt', $pl->pl_sgt) }}" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
            </div>

            <div>
                <label for="pl_sgt_rank" class="block text-gray-700 font-medium mb-2">Pl Sgt Rank</label>
                <select name="pl_sgt_rank" id="pl_sgt_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
                    @php
                        $ranks = [
                            'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                            'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                            'L/Cpl', 'Pte'
                        ];
                    @endphp
                    @foreach($ranks as $rank)
                        <option value="{{ $rank }}" {{ old('pl_sgt_rank', $pl->pl_sgt_rank) == $rank ? 'selected' : '' }}>{{ $rank }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="flex flex-col sm:flex-row gap-4 mt-6">
            <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600 flex-1">Update Pl</button>
            <a href="{{ route('bn.index') }}" class="bg-gray-500 text-white px-6 py-3 rounded hover:bg-gray-600 text-center flex-1">Cancel</a>
        </div>
    </form>
</div>

@endsection

@push('scripts')
<script>
    // When the Bn is selected, make an AJAX request to get the corresponding Coys
    $('#bn_id').on('change', function() {
        var bn_id = $(this).val();
        
        if (bn_id) {
            $.ajax({
                url: '{{ route('getCoysByBn') }}', // Ensure this route exists in your routes/web.php
                type: 'GET',
                data: { bn_id: bn_id },
                success: function(data) {
                    $('#coy_id').empty(); // Clear existing Coy options
                    $('#coy_id').append('<option value="">Choose a Coy</option>'); // Add default option
                    $.each(data, function(key, value) {
                        $('#coy_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });

                    // Re-select the current Coy value
                    var currentCoyId = '{{ old('coy_id', $pl->coy_id) }}';
                    if (currentCoyId) {
                        $('#coy_id').val(currentCoyId);
                        $('#coy_id').trigger('change'); // Trigger change to update Platoons
                    }
                }
            });
        } else {
            $('#coy_id').empty();
            $('#coy_id').append('<option value="">Choose a Coy</option>');
        }
    });

    // When the Coy is selected, make an AJAX request to get the corresponding Platoons
    $('#coy_id').on('change', function() {
        var coy_id = $(this).val();

        if (coy_id) {
            $.ajax({
                url: '{{ route('getPlsByCoy') }}', // Ensure this route exists in your routes/web.php
                type: 'GET',
                data: { coy_id: coy_id },
                success: function(data) {
                    $('#name').empty(); // Clear existing Platoon options
                    $('#name').append('<option value="">Select Pl</option>'); // Add default option
                    $.each(data, function(key, value) {
                        $('#name').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });

                    // Re-select the current Platoon value
                    var currentPlId = '{{ old('name', $pl->name) }}';
                    if (currentPlId) {
                        $('#name').val(currentPlId);
                    }
                }
            });
        } else {
            $('#name').empty();
            $('#name').append('<option value="">Select Pl</option>');
        }
    });

    // Trigger change event to load Coys when the page loads (if a Bn is already selected)
    $(document).ready(function() {
        var selectedBnId = $('#bn_id').val();
        if (selectedBnId) {
            $('#bn_id').trigger('change');
        }
    });
</script>
@endpush
