@extends('layouts.app')
@section('title', 'PR')
@section('content')
<div class="container mx-auto px-4 py-6 max-w-7xl">
    <!-- Header Section -->
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-gray-800 mb-2">PR</h1>
        <p class="text-gray-600 text-sm leading-relaxed">
            Select battalion, company, and platoon to filter the PR list.<br>
            Search by Army Number, and manage performance ratings for each cadet.
        </p>
    </div>

    <!-- Main Card -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <!-- Filters Section -->
        <div class="p-5 border-b border-gray-200 bg-gray-50/50">
            <div class="flex flex-wrap items-center gap-3">
                <!-- BN Select -->
                <div class="relative">
                    <select id="bn" class="appearance-none bg-white border border-gray-300 text-gray-700 py-2 pl-3 pr-8 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500">
                        <option value="">Select BN</option>
                        @foreach ($bn as $bns)
                            <option value="{{ $bns }}">{{ $bns }}</option>
                        @endforeach
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                </div>

                <!-- COY Select -->
                <div class="relative">
                    <select id="coy" class="appearance-none bg-white border border-gray-300 text-gray-700 py-2 pl-3 pr-8 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500">
                        <option value="">Select COY</option>
                        @foreach ($coy as $coys)
                            <option value="{{ $coys }}">{{ $coys }}</option>
                        @endforeach
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                </div>

                <!-- PL Select -->
                <div class="relative">
                    <select id="pl" class="appearance-none bg-white border border-gray-300 text-gray-700 py-2 pl-3 pr-8 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500">
                        <option value="">Select PL</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                </div>

                <!-- Filter Button -->
                <button id="filterBtn" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-150 shadow-sm">
                    Filter
                </button>
            </div>

            <!-- Search -->
            <div class="mt-4 relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <svg class="h-4 w-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                </div>
                <input type="text" id="searchArmyNumber" 
                       class="block w-full pl-9 pr-3 py-2 border border-gray-300 rounded-lg text-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500" 
                       placeholder="Search Army Number...">
            </div>
        </div>

        <!-- Table -->
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">SN</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">ARMY NO</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">RANK</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">NAME</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">BN</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">COY</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">PL</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">ACTION</th>
                    </tr>
                </thead>
                <tbody id="tableBody" class="bg-white divide-y divide-gray-200">
                    @foreach($admissions as $index => $admission)
                        <tr class="hover:bg-gray-50 transition-colors duration-150">
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $index + 1 }}</td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">
                                {{ $admission->army_number }}
                                @if($admission->is_decommissioned)
                                    <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">
                                        Discontinued
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->rank }}</td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->name }}</td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->bn }}</td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->coy }}</td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">{{ $admission->pl }}</td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm">
                                @if($admission->is_decommissioned)
                                    <span class="text-gray-400 cursor-not-allowed">Add PR</span>
                                @else
                                    <a href="{{ route('pr.create', ['admissionId' => $admission->id]) }}" class="text-blue-600 hover:text-blue-800 font-medium">
                                        Add PR
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Loading State (hidden by default) -->
        <div id="loadingSpinner" class="hidden py-8 text-center">
            <svg class="animate-spin h-6 w-6 text-blue-600 mx-auto" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        </div>

        <!-- Pagination -->
        <div class="px-4 py-3 border-t border-gray-200 bg-gray-50/50">
            {{ $admissions->withQueryString()->links() }}
        </div>
    </div>
</div>

<!-- Ajax and Filter Script -->
<!-- Ajax and Filter Script -->
<script>
$(document).ready(function() {
    let searchTimeout;

    function showLoading() {
        $('#tableBody').addClass('opacity-50');
        $('#loadingSpinner').removeClass('hidden');
    }

    function hideLoading() {
        $('#tableBody').removeClass('opacity-50');
        $('#loadingSpinner').addClass('hidden');
    }

    function fetchFilteredData() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            var bn = $('#bn').val();
            var coy = $('#coy').val();
            var pl = $('#pl').val();
            var armyNumber = $('#searchArmyNumber').val();

            showLoading();

            $.ajax({
              url: "/admissions/filter",
                // If the above doesn't work, try this instead:
                // url: "/admissions/filter",
                method: 'GET',
                data: {
                    bn: bn || '',
                    coy: coy || '',
                    pl: pl || '',
                    army_number: armyNumber || ''
                },
                success: function(response) {
                    var tableBody = $('#tableBody');
                    tableBody.empty();

                    if (response.data.length === 0) {
                        tableBody.append(`
                            <tr>
                                <td colspan="8" class="text-center py-6 text-sm text-gray-500">
                                    No results found matching the search criteria.
                                </td>
                            </tr>
                        `);
                    } else {
                        response.data.forEach(function(data, index) {
                            var actionContent = '';
                            var discoBadge = '';

                            if (data.is_decommissioned == 1) {
                                actionContent = `<span class="text-gray-400">Add PR</span>`;
                                discoBadge = `<span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">Discontinued</span>`;
                            } else {
                                actionContent = `<a href="{{ url('pr/create') }}/${data.id}" class="text-blue-600 hover:text-blue-800 font-medium">Add PR</a>`;
                            }

                            var tableRow = `
                                <tr class="hover:bg-gray-50 transition-colors duration-150">
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${index + 1}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${data.army_number} ${discoBadge}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${data.rank}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${data.name}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${data.bn}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${data.coy}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">${data.pl}</td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm">${actionContent}</td>
                                </tr>
                            `;
                            tableBody.append(tableRow);
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", error);
                    console.error("Response:", xhr.responseText);
                    
                    var tableBody = $('#tableBody');
                    tableBody.empty();
                    tableBody.append(`
                        <tr>
                            <td colspan="8" class="text-center py-6 text-sm text-red-600">
                                Error fetching data. Please try again.
                            </td>
                        </tr>
                    `);
                },
                complete: function() {
                    hideLoading();
                }
            });
        }, 300);
    }

    // Event listeners
    $('#filterBtn').on('click', function() {
        fetchFilteredData();
    });

    $('#searchArmyNumber').on('keyup', function() {
        fetchFilteredData();
    });

    $('#bn, #coy, #pl').on('change', function() {
        fetchFilteredData();
    });
});
</script>
@endsection