@extends('layouts.app')

@section('content')


<div class="container mx-auto p-4">

        <div class="container mx-auto p-4">
            <div class="flex justify-between items-center mb-8">
                <div>
                    <h1 class="text-4xl font-bold text-gray-800">PR List</h1>
                    <p class="text-gray-600">Filter performance ratings by battalion, company, and platoon. <br>View individual scores, mean scores, and ratings for each cadet.</p>
                </div>
            </div>
            
            <div class="bg-white rounded-lg shadow-md p-6">
        

                <!-- Add Filters Section -->
             <div class="mb-6">
    <form action="{{ route('pr.raters') }}" method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <div>
            <label for="bn" class="block text-sm font-medium text-gray-700 mb-1">Bn</label>
            <select name="bn" id="bn" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                <option value="">All Bn</option>
                @foreach($battalions as $battalion)
                    <option value="{{ $battalion }}" {{ request('bn') == $battalion ? 'selected' : '' }}>
                        {{ $battalion }}
                    </option>
                @endforeach
            </select>
        </div>
        
        <div>
            <label for="coy" class="block text-sm font-medium text-gray-700 mb-1">Coy</label>
            <select name="coy" id="coy" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                <option value="">All Coy</option>
                @foreach($companies as $company)
                    <option value="{{ $company }}" {{ request('coy') == $company ? 'selected' : '' }}>
                        {{ $company }}
                    </option>
                @endforeach
            </select>
        </div>
        
        <div>
            <label for="pl" class="block text-sm font-medium text-gray-700 mb-1">Pl</label>
            <select name="pl" id="pl" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                <option value="">All Pl</option>
                <option value="1" {{ request('pl') == '1' ? 'selected' : '' }}>1</option>
                <option value="2" {{ request('pl') == '2' ? 'selected' : '' }}>2</option>
                <option value="3" {{ request('pl') == '3' ? 'selected' : '' }}>3</option>
            </select>
        </div>
        
        <!-- New Phase Filter -->
        {{-- <div>
            <label for="phase" class="block text-sm font-medium text-gray-700 mb-1">Phase</label>
            <select name="phase" id="phase" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                <option value="">All Phases</option>
                @foreach($phases as $phase)
                    <option value="{{ $phase->name }}" {{ request('phase') == $phase->name ? 'selected' : '' }}>
                        {{ $phase->name }}
                    </option>
                @endforeach
            </select>
        </div> --}}
        
        <div class="flex items-end">
            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                Filter Results
            </button>
        </div>
    </form>
</div>

                <!-- Existing table code... -->

        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                {{ session('error') }}
            </div>
        @endif

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">SN</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'army_number', 'direction' => request('sort') === 'army_number' && request('direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center text-gray-500 hover:text-gray-700">
                                Army No
                                @if(request('sort') === 'army_number')
                                    <span class="ml-1">{{ request('direction') === 'asc' ? '↑' : '↓' }}</span>
                                @endif
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'name', 'direction' => request('sort') === 'name' && request('direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center text-gray-500 hover:text-gray-700">
                                Name
                                @if(request('sort') === 'name')
                                    <span class="ml-1">{{ request('direction') === 'asc' ? '↑' : '↓' }}</span>
                                @endif
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'rank', 'direction' => request('sort') === 'rank' && request('direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center text-gray-500 hover:text-gray-700">
                                Rank
                                @if(request('sort') === 'rank')
                                    <span class="ml-1">{{ request('direction') === 'asc' ? '↑' : '↓' }}</span>
                                @endif
                            </a>
                        </th>
                
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Scores</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Raters</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'total_score', 'direction' => request('sort') === 'total_score' && request('direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center text-gray-500 hover:text-gray-700">
                                Sum
                                @if(request('sort') === 'total_score')
                                    <span class="ml-1">{{ request('direction') === 'asc' ? '↑' : '↓' }}</span>
                                @endif
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider bg-yellow-200">
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'mean_score', 'direction' => request('sort') === 'mean_score' && request('direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center text-gray-500 hover:text-gray-700">
                                Mean
                                @if(request('sort') === 'mean_score')
                                    <span class="ml-1">{{ request('direction') === 'asc' ? '↑' : '↓' }}</span>
                                @endif
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider bg-green-200">
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'final_score', 'direction' => request('sort') === 'final_score' && request('direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center text-gray-500 hover:text-gray-700">
                                Score
                                @if(request('sort') === 'final_score')
                                    <span class="ml-1">{{ request('direction') === 'asc' ? '↑' : '↓' }}</span>
                                @endif
                            </a>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($ratersData as  $index => $rater)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $index + 1 }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">{{ $rater->army_number }}</td>
                            <td class="px-6 py-4 whitespace-nowrap" title="{{ $rater->name }}">
                                {{ \Illuminate\Support\Str::limit($rater->name, 12, '...') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">{{ $rater->rank }}</td>
                        
                     <!-- Update the data attributes in the scores section -->
                     <td class="px-6 py-4">
                        <div class="grid grid-cols-7 gap-1">
                            @foreach($rater->receivedRatings as $rating)
                                @if ($rating->rater)
                                    <div>
                                        <span
                                            class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium cursor-pointer hover:opacity-75
                                                {{ $rating->score == 2 ? 'bg-red-100 text-red-800' :
                                                  ($rating->score == 6 ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800') }}"
                                            onclick="showRaterDetails(this)"
                                            data-rater-details="{{ json_encode([
                                                'id' => $rating->id,
                                                'army_number' => $rating->rater->army_number,
                                                'name' => $rating->rater->name,
                                                'rank' => $rating->rater->rank,
                                                'score' => $rating->score,
                                                'admission_id' => $rating->admission_id
                                            ]) }}"
                                        >
                                            {{ $rating->score }}
                                        </span>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </td>
                    
                            <td>{{ $rater->total_peers}}</td>
                            <td class="px-6 py-4 whitespace-nowrap">{{ $rater->total_score }}</td>
                            <td class="px-6 py-4 whitespace-nowrap bg-yellow-100">
                                @if($rater->ratings_count > 0)
                                    <span class="font-medium {{ $rater->mean_score >= 5 ? 'text-red-600' : ($rater->mean_score <= 3 ? 'text-green-600' : 'text-yellow-600') }}">
                                        {{ $rater->mean_score }}
                                    </span>

                                @else
                                    <span class="text-gray-400">-</span>
                                @endif
                            </td>
                            <!-- Replace the Score column content -->
<td class="px-6 py-4 whitespace-nowrap bg-green-100">
    @if($rater->ratings_count > 0)
        <span class="font-medium {{ $rater->final_score >= 7 ? 'text-red-600' : ($rater->final_score <= 4 ? 'text-green-600' : 'text-yellow-600') }}">
            {{ $rater->final_score }}%
        </span>
    @else
        <span class="text-gray-400">-</span>
    @endif
</td>
                            {{-- <td class="px-6 py-4 whitespace-nowrap">
                                <a href="{{ route('pr.list', $rater->id) }}"
                                   class="text-blue-600 hover:text-blue-900">
                                    View Details
                                </a>
                            </td> --}}
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-4 text-center text-gray-500">
                                No peer ratings found
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Update the modal content -->
<div id="raterModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-2">Rater Details</h3>
            <div class="mt-2 px-7 py-3">
                <p class="text-sm text-gray-500 mb-1">Army Number: <span id="modalArmyNumber" class="font-medium text-gray-900"></span></p>
                <p class="text-sm text-gray-500 mb-1">Name: <span id="modalName" class="font-medium text-gray-900"></span></p>
                <p class="text-sm text-gray-500 mb-1">Rank: <span id="modalRank" class="font-medium text-gray-900"></span></p>
                <div class="mb-4">

              <!-- Replace the radio buttons section in the modal -->
<div class="mb-4">

    <div class="mt-2">
        <input type="number"
               id="rating_input"
               min="2"
               max="6"
               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
               onchange="updateRating(this.value)"
               oninput="validateRating(this)">
        <p class="mt-1 text-xs text-gray-500">Enter a number between 2 and 6</p>
    </div>
</div>
                </div>
            </div>
            <div class="flex gap-2 px-4 py-3">
    <button type="button"
            onclick="saveRating()"
            class="flex-1 px-4 py-2 bg-green-500 text-white text-base font-medium rounded-md shadow-sm hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-green-300">
        Save
    </button>
    <button type="button"
            onclick="closeModal()"
            class="flex-1 px-4 py-2 bg-gray-500 text-white text-base font-medium rounded-md shadow-sm hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-300">
        Cancel
    </button>
</div>
        </div>
    </div>
</div>


@push('scripts')
<script>
// Single declaration of currentRatingData
let currentRatingData = null;

function validateRating(input) {
    let value = parseInt(input.value);

    if (isNaN(value)) {
        input.value = 2;
        value = 2;
    }

    value = Math.max(2, Math.min(6, value));
    value = Math.round(value);
    input.value = value;
    updateRating(value);
}

function updateRating(value) {
    if (currentRatingData) {
        currentRatingData.newScore = parseInt(value);
    }
}

function showRaterDetails(element) {
    const details = JSON.parse(element.dataset.raterDetails);
    currentRatingData = {
        id: details.id,
        armyNumber: details.army_number,
        name: details.name,
        rank: details.rank,
        currentScore: parseInt(details.score) || 2,
        admissionId: details.admission_id
    };

    document.getElementById('modalArmyNumber').textContent = details.army_number;
    document.getElementById('modalName').textContent = details.name;
    document.getElementById('modalRank').textContent = details.rank;

    const input = document.getElementById('rating_input');
    input.value = currentRatingData.currentScore;
    validateRating(input);

    document.getElementById('raterModal').classList.remove('hidden');
}

// Add the missing saveRating function
async function saveRating() {
    if (!currentRatingData || !currentRatingData.newScore) {
        alert('Please select a rating');
        return;
    }

    if (currentRatingData.newScore === currentRatingData.currentScore) {
        closeModal();
        return;
    }

    try {
        const response = await fetch('{{ route("pr.updateRating") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                id: currentRatingData.id,
                current_score: currentRatingData.currentScore,
                new_score: currentRatingData.newScore,
                admission_id: currentRatingData.admissionId
            })
        });

        const data = await response.json();

        if (response.ok) {
            window.location.reload();
        } else {
            throw new Error(data.error || 'Failed to update rating');
        }
    } catch (error) {
        alert('Error updating rating: ' + error.message);
    }
}

function closeModal() {
    document.getElementById('raterModal').classList.add('hidden');
    document.getElementById('rating_input').value = '';
    currentRatingData = null;
}

// Event listener for clicking outside modal
document.getElementById('raterModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeModal();
    }
});
</script>
@endpush

@endsection



