@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-7xl mx-auto">
        <h1 class="text-2xl font-bold mb-6">Edit Registration</h1>
        @if (session('success'))
    <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
        <span class="block sm:inline">{{ session('success') }}</span>
    </div>
@endif

@if (session('error'))
    <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
        <span class="block sm:inline">{{ session('error') }}</span>
    </div>
@endif

@if ($errors->any())
    <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative">
        <ul class="list-disc list-inside">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


        <form action="{{ route('registrations.update', $registration) }}" method="POST" enctype="multipart/form-data" class="space-y-8">
            @csrf
            @method('PUT')

            <h6>Reg/No: {{ $registration->registration_number }} </h6>

            <!-- Military Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Military Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block font-semibold">Army Number <span class="text-red-500">*</span></label>
                        <input disabled type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="army_number" value="{{ $registration->army_number }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Name <span class="text-red-500">*</span></label>
                        <input disabled type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="name" value="{{ $registration->name }}" >
                    </div>
                    <div>
                        <label class="block font-semibold">Unit</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="unit" value="{{ $registration->unit }}">
                    </div>

                    <div>
                        <label class="block font-semibold">Photo</label>
                        <input type="file" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="photo">
                        @if($registration->photo)
                            <img src="{{ Storage::url($registration->photo) }}" alt="Current Photo" class="mt-2 h-25 w-25 object-cover rounded">
                        @endif
                    </div>
                </div>
            </div>

            <!-- Personal Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Personal Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block font-semibold">NIN <span class="text-red-500">*</span></label>
                        <input disabled type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="nin" value="{{ $registration->nin }}" required>
                    </div>
                    <div>
                        <label class="block font-semibold">Date of Birth <span class="text-red-500">*</span></label>
                        <input disabled type="date" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="dob" value="{{ $registration->dob }}" required>
                    </div>
                    <div>
                        <label class="block font-semibold">Sex <span class="text-red-500">*</span></label>
                        <select disabled name="sex" class="w-full border-gray-300 rounded-lg p-2" >
                            <option value="Male" {{ $registration->sex == 'Male' ? 'selected' : '' }}>Male</option>
                            <option value="Female" {{ $registration->sex == 'Female' ? 'selected' : '' }}>Female</option>
                        </select>
                    </div>
                    <div>
                        <label class="block font-semibold">Phone <span class="text-red-500">*</span></label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="phone" value="{{ $registration->phone }}" required>
                    </div>
                     <div>
                        <label class="block font-semibold">Email <span class="text-red-500"></span></label>
                        <input type="email" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="email" value="{{ old('email') }}">
                    </div> 
                    <div>
                        <label class="block font-semibold">Shoe Size <span class="text-red-500"></span></label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="shoe_size" value="{{ old('shoe_size') }}">
                    </div> 
                </div>
            </div>

            <!-- Family Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Family Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block font-semibold">Father Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="father_name" value="{{ $registration->father_name }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Father Phone</label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="father_phone" value="{{ $registration->father_phone }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Mother Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="mother_name" value="{{ $registration->mother_name }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Mother Phone</label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="mother_phone" value="{{ $registration->mother_phone }}">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                    <div>
                        <label class="block font-semibold">Spouse Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="spouse_name" value="{{ $registration->spouse_name }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Spouse Phone</label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="spouse_phone" value="{{ $registration->spouse_phone }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Next of Kin</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="next_kin" value="{{ $registration->next_kin }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Relationship With Kin</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="relationship_with_kin" value="{{ $registration->relationship_with_kin }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Next of Kin Phone</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="kin_phone" value="{{ $registration->kin_phone}}">
                    </div>
                </div>
            </div>

            <!-- Additional Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Additional Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block font-semibold">Education Level <span class="text-red-500"></span></label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="education_level" value="{{ old('education_level') }}">
                    </div> 
                </div>
            </div>
            <button type="submit" class="w-full bg-blue-500 text-white py-3 px-4 rounded-lg hover:bg-blue-600 font-semibold">
                Update Registration
            </button>
        </form>
    </div>
</div>
@endsection