@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Registrations</h1>
        <a href="{{ route('registrations.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
            Add New Registration
        </a>
    </div>

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
            {{ session('success') }}
        </div>
    @endif
    <form method="GET" action="{{ route('registrations.index') }}" class="mb-4">
        <div class="flex space-x-2">
            <div class="relative w-full">
                <input type="text" name="search" placeholder="Search by Army Number, Name, Reg-No"
                    value="{{ request('search') }}"
                    class="w-full border-gray-300 rounded-lg shadow-sm p-2 pl-10">
                <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 0l7 7"></path>
                </svg>
            </div>
            <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
                Search
            </button>
        </div>
    </form>
    <div class="bg-white shadow-md rounded-lg overflow-x-auto">
        <table class="min-w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Photo</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Army Number</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reg-No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach ($registrations as $registration)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <img src="{{ $registration->photo ? asset('storage/' . $registration->photo) : 'https://img.freepik.com/premium-vector/user-profile-icon-flat-style-member-avatar-vector-illustration-isolated-background-human-permission-sign-business-concept_157943-15752.jpg' }}"
                        alt="Profile Image"
                        class="w-10 h-10 rounded-full object-cover">
                        {{-- <img src="{{ Storage::url($registration->photo) }}" alt="Profile" class="h-10 w-10 rounded-full"> --}}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $registration->army_number }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $registration->name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $registration->phone }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $registration->registration_number }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <a href="{{ route('registrations.show', $registration) }}" class="text-green-600 hover:text-green-900 mr-4">View</a>
                        <a href="{{ route('registrations.edit', $registration) }}" class="text-indigo-600 hover:text-indigo-900 mr-4">Edit</a>
                        <form action="{{ route('registrations.destroy', $registration) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure you want to delete this registration?')">
                                Delete
                            </button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    
    <div class="mt-4">
        {{ $registrations->links() }}
    </div>
</div>
@endsection