@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-6xl">

    {{-- Header --}}
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-3xl font-bold text-gray-800">Remark Templates</h1>
            <p class="text-gray-500 text-sm mt-1">Manage auto-generated remarks by grade and role</p>
        </div>
        <a href="{{ route('remark-templates.create') }}"
           class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition text-sm font-medium">
            + New Template
        </a>
    </div>

    {{-- Alerts --}}
    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6 flex justify-between items-center">
            <span>{{ session('success') }}</span>
            <button onclick="this.parentElement.remove()" class="text-green-700 font-bold">×</button>
        </div>
    @endif
    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6 flex justify-between items-center">
            <span>{{ session('error') }}</span>
            <button onclick="this.parentElement.remove()" class="text-red-700 font-bold">×</button>
        </div>
    @endif

    {{-- Phase selector --}}
    <div class="bg-white rounded-lg shadow-sm border p-4 mb-6">
        <form method="GET" class="flex items-center gap-4 flex-wrap">
            <label class="font-semibold text-gray-700 text-sm">Phase:</label>
            <select name="phase_id" class="border border-gray-300 rounded-lg px-3 py-1.5 text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent" onchange="this.form.submit()">
                @foreach($phases as $phase)
                    <option value="{{ $phase->id }}" {{ $phase->id == $selectedPhaseId ? 'selected' : '' }}>
                        {{ $phase->name }}{{ $phase->is_active ? ' (Active)' : '' }}
                    </option>
                @endforeach
            </select>
        </form>
    </div>

    {{-- Placeholder reference --}}
    <div class="bg-gray-50 border rounded-lg px-4 py-3 mb-6 text-sm text-gray-600">
        <span class="font-semibold">Available placeholders: </span>
        @foreach(['{{name}}', '{{gender_he}}', '{{gender_He}}', '{{gender_his}}', '{{gender_His}}', '{{gender_him}}', '{{gender_Him}}'] as $ph)
            <code class="bg-white border rounded px-2 py-0.5 mx-1 text-xs">{{ $ph }}</code>
        @endforeach
    </div>

    {{-- Templates grouped by grade --}}
    @php
        $grades      = ['A', 'B', 'C', 'D', 'E', 'F'];
        $roles       = ['PL_COMD' => 'PL Comd', 'OC' => 'OC', 'CI' => 'CI', 'COMDT' => 'Comdt'];
        $gradeLabels = ['A' => 'Excellent', 'B' => 'Very Good', 'C' => 'Good', 'D' => 'Satisfactory', 'E' => 'Fair', 'F' => 'Poor'];
        $gradeColors = [
            'A' => ['badge' => 'bg-green-100 text-green-800',  'border' => 'border-green-200'],
            'B' => ['badge' => 'bg-blue-100 text-blue-800',    'border' => 'border-blue-200'],
            'C' => ['badge' => 'bg-cyan-100 text-cyan-800',    'border' => 'border-cyan-200'],
            'D' => ['badge' => 'bg-yellow-100 text-yellow-800','border' => 'border-yellow-200'],
            'E' => ['badge' => 'bg-gray-100 text-gray-800',    'border' => 'border-gray-200'],
            'F' => ['badge' => 'bg-red-100 text-red-800',      'border' => 'border-red-200'],
        ];
    @endphp

    @foreach($grades as $grade)
    @php
        $count = isset($templates[$grade]) ? $templates[$grade]->count() : 0;
    @endphp
    <div class="bg-white rounded-lg shadow-sm border mb-4 overflow-hidden">
        {{-- Grade header --}}
        <div class="flex items-center gap-3 px-4 py-3 border-b bg-gray-50">
            <span class="px-3 py-1 rounded-full text-sm font-bold {{ $gradeColors[$grade]['badge'] }}">
                Grade {{ $grade }}
            </span>
            <span class="text-gray-600 font-medium">{{ $gradeLabels[$grade] }}</span>
            <span class="ml-auto text-xs text-gray-400">{{ $count }}/{{ count($roles) }} roles configured</span>
        </div>

        {{-- Role boxes 2×2 grid --}}
        <div class="grid grid-cols-1 md:grid-cols-2">
            @foreach($roles as $roleKey => $roleLabel)
            @php
                $existing = isset($templates[$grade])
                    ? $templates[$grade]->firstWhere('type', $roleKey)
                    : null;
            @endphp
            <div class="p-4 border-b border-r border-gray-100">
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm font-semibold text-gray-700">{{ $roleLabel }}</span>
                    @if($existing)
                        <div class="flex gap-2">
                            <a href="{{ route('remark-templates.edit', $existing->id) }}"
                               class="text-xs text-blue-600 hover:text-blue-800">Edit</a>
                            <form method="POST" action="{{ route('remark-templates.destroy', $existing->id) }}"
                                  onsubmit="return confirm('Delete this remark?')">
                                @csrf @method('DELETE')
                                <button class="text-xs text-red-500 hover:text-red-700">Delete</button>
                            </form>
                        </div>
                    @endif
                </div>

                @if($existing)
                    {{-- Show existing text, click to expand edit --}}
                    <p class="text-xs text-gray-500 mb-2 line-clamp-2">{{ $existing->remark_text }}</p>
                    <span class="inline-block text-xs bg-green-100 text-green-700 px-2 py-0.5 rounded-full">✓ Configured</span>
                @else
                    <form method="POST" action="{{ route('remark-templates.store') }}">
                        @csrf
                        <input type="hidden" name="phase_id" value="{{ $selectedPhaseId }}">
                        <input type="hidden" name="grade"    value="{{ $grade }}">
                        <input type="hidden" name="type"     value="{{ $roleKey }}">
                        <textarea name="remark_text" rows="2"
                            class="w-full border border-gray-200 rounded px-2 py-1 text-xs mb-2 focus:ring-1 focus:ring-blue-400 focus:border-transparent resize-none"
                            placeholder="Write remark for Grade {{ $grade }} / {{ $roleLabel }}..."></textarea>
                        <button type="submit"
                            class="text-xs px-3 py-1 bg-gray-100 hover:bg-blue-600 hover:text-white text-gray-600 rounded transition">
                            + Add
                        </button>
                    </form>
                @endif
            </div>
            @endforeach
        </div>
    </div>
    @endforeach

</div>
@endsection