@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <div class="mb-6 flex justify-between items-center">
        <a href="{{ route('remark-templates.index') }}"
           class="text-blue-600 hover:text-blue-800 text-sm">
            ← Back to Templates
        </a>
        <div class="flex gap-3">
            <a href="{{ route('remark-templates.edit', $remarkTemplate) }}"
               class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition text-sm">
                Edit
            </a>
            <form action="{{ route('remark-templates.destroy', $remarkTemplate) }}"
                  method="POST" class="inline"
                  onsubmit="return confirm('Delete this template?')">
                @csrf @method('DELETE')
                <button type="submit"
                        class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-lg transition text-sm">
                    Delete
                </button>
            </form>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-lg p-8">
        <h1 class="text-3xl font-bold mb-6">Remark Template</h1>

        {{-- Meta info --}}
        <div class="grid grid-cols-2 gap-6 mb-8">
            <div>
                <label class="block text-xs font-medium text-gray-500 mb-1 uppercase tracking-wide">Phase</label>
                <span class="px-3 py-1 inline-flex text-sm font-semibold rounded-full bg-blue-100 text-blue-800">
                    {{ $remarkTemplate->phase->name ?? 'N/A' }}
                </span>
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-500 mb-1 uppercase tracking-wide">Grade</label>
                @php
                    $gradeColor = match($remarkTemplate->grade) {
                        'A' => 'bg-green-100 text-green-800',
                        'B' => 'bg-blue-100 text-blue-800',
                        'C' => 'bg-cyan-100 text-cyan-800',
                        'D' => 'bg-yellow-100 text-yellow-800',
                        'E' => 'bg-gray-100 text-gray-700',
                        'F' => 'bg-red-100 text-red-800',
                        default => 'bg-gray-100 text-gray-700',
                    };
                @endphp
                <span class="px-3 py-1 inline-flex text-sm font-semibold rounded-full {{ $gradeColor }}">
                    Grade {{ $remarkTemplate->grade }}
                </span>
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-500 mb-1 uppercase tracking-wide">Type</label>
                <span class="px-3 py-1 inline-flex text-sm font-semibold rounded-full bg-purple-100 text-purple-800">
                    {{ $remarkTemplate->type }}
                </span>
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-500 mb-1 uppercase tracking-wide">Last Updated</label>
                <p class="text-gray-700 text-sm">{{ $remarkTemplate->updated_at->format('M d, Y H:i') }}</p>
            </div>
        </div>

        {{-- Raw text --}}
        <div class="mb-8">
            <label class="block text-xs font-medium text-gray-500 mb-2 uppercase tracking-wide">Remark Text (raw)</label>
            <div class="p-4 bg-gray-50 rounded-lg border border-gray-200">
                <pre class="text-sm text-gray-800 whitespace-pre-wrap font-sans">{{ $remarkTemplate->remark_text }}</pre>
            </div>
        </div>

        {{-- Preview --}}
        <div class="mb-6">
            <div class="flex items-center gap-4 mb-3">
                <label class="text-xs font-medium text-gray-500 uppercase tracking-wide">Preview</label>
                <label class="flex items-center gap-1 text-sm text-gray-600 cursor-pointer">
                    <input type="radio" name="preview_gender" value="male" checked onchange="updatePreview()"> Male student
                </label>
                <label class="flex items-center gap-1 text-sm text-gray-600 cursor-pointer">
                    <input type="radio" name="preview_gender" value="female" onchange="updatePreview()"> Female student
                </label>
            </div>
            <div id="preview"
                 class="p-4 rounded-lg border text-sm text-gray-800 leading-relaxed bg-blue-50 border-blue-200">
            </div>
        </div>
    </div>
</div>

<script>
const raw = @json($remarkTemplate->remark_text);

function updatePreview() {
    const isMale = document.querySelector('input[name="preview_gender"]:checked').value === 'male';
    let text = raw;

    text = text.replace(/\{\{name\}\}/g,        '<strong>' + (isMale ? 'JOHN DOE' : 'JANE DOE') + '</strong>');
    text = text.replace(/\{\{gender_He\}\}/g,   '<em>' + (isMale ? 'He'  : 'She') + '</em>');
    text = text.replace(/\{\{gender_he\}\}/g,   '<em>' + (isMale ? 'he'  : 'she') + '</em>');
    text = text.replace(/\{\{gender_His\}\}/g,  '<em>' + (isMale ? 'His' : 'Her') + '</em>');
    text = text.replace(/\{\{gender_his\}\}/g,  '<em>' + (isMale ? 'his' : 'her') + '</em>');
    text = text.replace(/\{\{gender_Him\}\}/g,  '<em>' + (isMale ? 'Him' : 'Her') + '</em>');
    text = text.replace(/\{\{gender_him\}\}/g,  '<em>' + (isMale ? 'him' : 'her') + '</em>');

    document.getElementById('preview').innerHTML = text;
}

document.addEventListener('DOMContentLoaded', updatePreview);
</script>
@endsection