@extends('layouts.app')

@section('content')
<div class="max-w-6xl mx-auto p-6">
    <h1 class="text-2xl font-bold mb-6">Add Remarks for {{ $admission->name }}</h1>

    @if ($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul class="list-disc pl-5">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('remarks.store') }}" method="POST" enctype="multipart/form-data" id="remarkForm">
        @csrf
        
        <input type="hidden" name="admission_id" value="{{ $admission->id }}">
        
        <!-- Select Phase -->
        <div class="mb-6">
            <label class="block font-medium mb-2" for="phase">Select Phase</label>
            <select name="phase" id="phase" class="w-full border rounded p-2" required>
                <option value="">Select Phase</option>
                <option value="1">Phase 1</option>
                <option value="2">Phase 2</option>
                <option value="3">Phase 3</option>
            </select>
        </div>
        
        <!-- Remarks Section -->
        <div class="space-y-6">
            <div>
                <label class="block font-medium mb-2">PL Comd's Remarks</label>
                <textarea name="pl_comd_remarks" class="w-full border rounded p-2"   rows="3">{{ old('pl_comd_remarks') }}</textarea>
            </div>
            
            <div>
                <label class="block font-medium mb-2">OC's Remarks</label>
                <textarea name="oc_remarks" class="w-full border rounded p-2" rows="3">{{ old('oc_remarks') }}</textarea>
            </div>
            
          
                <div>
                <label class="block font-medium mb-2">CI's Remarks</label>
                <textarea name="ci_remarks" class="w-full border rounded p-2" rows="3">{{ old('ci_remarks') }}</textarea>
            </div>
          
        </div>
        
        <!-- Signatures Upload Section -->
        {{-- <div class="space-y-6 mt-8">
            <h2 class="text-xl font-bold mb-4">Upload Signatures</h2>
            
            <div>
                <label class="block font-medium mb-2">PL Comd's Signature</label>
                <input type="file" name="pl_comd_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG, PDF (max 2MB)</p>
            </div>
            
            <div>
                <label class="block font-medium mb-2">OC's Signature</label>
                <input type="file" name="oc_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG, PDF (max 2MB)</p>
            </div>
            
            <div id="ci_signature_section" class="hidden">
                <label class="block font-medium mb-2">CI's Signature</label>
                <input type="file" name="ci_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG, PDF (max 2MB)</p>
            </div>
            
            <div id="comdt_signature_section" class="hidden">
                <label class="block font-medium mb-2">Comdt's Signature</label>
                <input type="file" name="comdt_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG, PDF (max 2MB)</p>
            </div>
            
            <div id="student_signature_section" class="hidden">
                <label class="block font-medium mb-2">Student's Signature</label>
                <input type="file" name="student_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG, PDF (max 2MB)</p>
            </div>
        </div> --}}
        
        <!-- Submit Button -->
        <div class="mt-6">
            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">
                Save Remarks
            </button>
        </div>
    </form>
    
    <!-- Display Saved Remarks Below the Form -->
    @if(isset($remarks) && $remarks->count() > 0)
        <h2 class="text-xl font-bold mt-12 mb-4">Saved Remarks for {{ $admission->name }}</h2>
        
        <div class="overflow-x-auto">
            <table class="min-w-full mt-6 border border-gray-300">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-2 px-4 border-b">Phase</th>
                        <th class="py-2 px-4 border-b">PL Comd's Remarks</th>
                        <th class="py-2 px-4 border-b">CI's Remarks</th>
                            <th class="py-2 px-4 border-b">OC's Remarks</th>
                
                        <th class="py-2 px-4 border-b">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($remarks as $remark)
                        <tr>
                            <td class="py-2 px-4 border-b">Phase {{ $remark->phase }}</td>
                            <td class="py-2 px-4 border-b">{{ $remark->pl_comd_remarks }}</td>
                            <td class="py-2 px-4 border-b">{{ $remark->ci_remarks }}</td>
                            <td class="py-2 px-4 border-b">{{ $remark->oc_remarks }}</td>

                            <td class="py-2 px-4 border-b">
 
                                <a href="{{ route('remarks.edit', $remark->id) }}" class="text-blue-600 hover:underline">Edit</a>
                                <form action="{{ route('remarks.destroy', $remark->id) }}" method="POST" class="inline-block">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline">Delete</button>
                                </form>

                                {{-- <a href="{{ route('remarks.show', $remark->id) }}" class="text-blue-600 hover:underline">View</a> --}}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <div class="mt-12 p-4 bg-gray-100 text-gray-700 rounded">
            <p>No remarks have been saved for this admission yet.</p>
        </div>
    @endif
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const phaseSelect = document.getElementById('phase');
        
        // Elements to toggle based on phase
        const ciRemarksSection = document.getElementById('ci_remarks_section');
        const comdtRemarksSection = document.getElementById('comdt_remarks_section');
        const studentRemarksSection = document.getElementById('student_remarks_section');
        const ciSignatureSection = document.getElementById('ci_signature_section');
        const comdtSignatureSection = document.getElementById('comdt_signature_section');
        const studentSignatureSection = document.getElementById('student_signature_section');
        
        // Function to toggle sections based on phase
        function toggleSections() {
            const phase = phaseSelect.value;
            
            // Reset all sections to hidden
            [ciRemarksSection, comdtRemarksSection, studentRemarksSection, 
             ciSignatureSection, comdtSignatureSection, studentSignatureSection].forEach(section => {
                section.classList.add('hidden');
            });
            
            // Phase 2: Show CI sections
            if (phase == '2' || phase == '3') {
                ciRemarksSection.classList.remove('hidden');
                ciSignatureSection.classList.remove('hidden');
            }
            
            // Phase 3: Show Comdt and Student sections
            if (phase == '3') {
                comdtRemarksSection.classList.remove('hidden');
                studentRemarksSection.classList.remove('hidden');
                comdtSignatureSection.classList.remove('hidden');
                studentSignatureSection.classList.remove('hidden');
            }
        }
        
        // Set up event listener for phase selection
        phaseSelect.addEventListener('change', toggleSections);
        
        // Run once to handle any pre-selected phase (e.g. from old input)
        toggleSections();
    });
</script>
@endsection