@extends('layouts.app')

@section('content')
<div class="max-w-6xl mx-auto p-6">
    <h1 class="text-2xl font-bold mb-6">Edit Remarks for {{ $admission->name }}</h1>

    @if ($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul class="list-disc pl-5">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('remarks.update', $remark->id) }}" method="POST" enctype="multipart/form-data" id="remarkForm">
        @csrf
        @method('PUT')
        
        <!-- Select Phase -->
        <div class="mb-6">
            <label class="block font-medium mb-2" for="phase">Select Phase</label>
            <select name="phase" id="phase" class="w-full border rounded p-2" required>
                <option value="">Select Phase</option>
                <option value="1" {{ $remark->phase == 1 ? 'selected' : '' }}>Phase 1</option>
                <option value="2" {{ $remark->phase == 2 ? 'selected' : '' }}>Phase 2</option>
                <option value="3" {{ $remark->phase == 3 ? 'selected' : '' }}>Phase 3</option>
            </select>
        </div>
        
        <!-- Remarks Section -->
        <div class="space-y-6">
            <div>
                <label class="block font-medium mb-2">PL Comd's Remarks</label>
                <textarea name="pl_comd_remarks" class="w-full border rounded p-2" rows="3">{{ old('pl_comd_remarks', $remark->pl_comd_remarks) }}</textarea>
            </div>
            
            <div>
                <label class="block font-medium mb-2">OC's Remarks</label>
                <textarea name="oc_remarks" class="w-full border rounded p-2" rows="3">{{ old('oc_remarks', $remark->oc_remarks) }}</textarea>
            </div>
            
   <div>
       <label class="block font-medium mb-2">CI's Remarks</label>
       <textarea name="ci_remarks" class="w-full border rounded p-2" rows="3">{{ old('ci_remarks', $remark->ci_remarks) }}</textarea>
   </div>

        </div>
        
        {{-- <!-- Signatures Upload Section -->
        <div class="space-y-6 mt-8">
            <h2 class="text-xl font-bold mb-4">Upload Signatures</h2>
            
            <div>
                <label class="block font-medium mb-2">PL Comd's Signature</label>
                @if($remark->pl_comd_signature)
                    <div class="mb-2">


                     <img src="http://localhost/army_project2/army_project2/public/{{ $remark->pl_comd_signature}}" alt="PL Comd Signature" class="h-16 border p-1">
                        <p class="text-sm text-gray-600">Current signature</p>
                    </div>
                @endif
                <input type="file" name="pl_comd_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG (max 2MB)</p>
            </div>
            
            <div>
                <label class="block font-medium mb-2">OC's Signature</label>
                @if($remark->oc_signature)
                    <div class="mb-2">
                        <img src="http://localhost/army_project2/army_project2/public/{{ $remark->oc_signature }}" alt="OC Signature" class="h-16 border p-1">
                        <p class="text-sm text-gray-600">Current signature</p>
                    </div>
                @endif
                <input type="file" name="oc_signature" class="w-full border rounded p-2">
                <p class="text-sm text-gray-500 mt-1">Allowed formats: JPG, JPEG, PNG (max 2MB)</p>
            </div>
            

  
            
       
        </div> --}}
        
        <!-- Submit Button -->
        <div class="mt-6 flex space-x-4">
            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">
                Update Remarks
            </button>
      
        </div>
    </form>
</div>

@endsection