@extends('layouts.app')

@section('content')
<div class="container mx-auto p-4">
    <h2 class="text-3xl font-bold text-gray-900 mb-6">Assessment Report</h2>

    <form id="filterForm">
        @csrf
        <!-- First Grid -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <div>
                <label class="block font-semibold">School</label>
                <select name="school_id" id="school_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select School</option>
                    @foreach($schools as $id => $name)
                        <option value="{{ $id }}">{{ $name }}</option>
                    @endforeach
                </select>
            </div>

            <div id="course_container" style="display: none;">
                <label class="block font-semibold">Course</label>
                <select name="course_id" id="course_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Course</option>
                </select>
            </div>

            <div id="intake_container" style="display: none;">
                <label class="block font-semibold">Intake</label>
                <select name="intake_id" id="intake_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Intake</option>
                </select>
            </div>
        </div>

        <!-- Second Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div id="phase_container" style="display: none;">
                <label class="block font-semibold">Phase</label>
                <select name="choose_phase" id="choose_phase" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Phase</option>
                    <option value="Phase 1">Phase 1</option>
                    <option value="Phase 2">Phase 2</option>
                    <option value="Phase 3">Phase 3</option>
                </select>
            </div>

            <div id="assessment_type_container" style="display: none;">
                <label class="block font-semibold">Assessment Type</label>
                <select name="choose_assessment_type" id="choose_assessment_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Assessment Type</option>
                    <option value="MSK">MSK</option>
                    <option value="Character Assessment">Character Assessment</option>
                </select>
            </div>

            <div id="assessment_group_container" style="display: none;">
                <label class="block font-semibold">Assessment Group</label>
                <select name="choose_assessment_group" id="choose_assessment_group" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Assessment Group</option>
                </select>
            </div>

            <div id="type_container" style="display: none;">
                <label class="block font-semibold">Exam Type</label>
                <select name="choose_type" id="choose_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Exam Type</option>
                    <option value="Weekly">Weekly</option>
                    <option value="Monthly">Monthly</option>
                    <option value="End of Phase Exam">End of Phase Exam</option>
                </select>
            </div>
        </div>

        <!-- Third Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div id="weeks_container" style="display: none;">
                <div id="exercises_container" style="display: none;">
                    <label class="block font-semibold">Exercises</label>
                    <select name="exercises" id="exercises" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select Exercise</option>
                        <option value="PT">PT</option>
                        <option value="SAA">SAA</option>
                        <option value="DR">DR</option>
                        <option value="TAC">TAC</option>
                        <option value="MU">MU</option>
                    </select>
                </div> 
                <label class="block font-semibold">Weeks</label>
                <select name="weeks" id="weeks" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Week</option>
                    @for($i = 1; $i <= 10; $i++)
                        <option value="week{{ $i }}">Week {{ $i }}</option>
                    @endfor
                </select>
            </div>

            <div id="subject_container" style="display: none;">
                <label class="block font-semibold">Subject</label>
                <select name="subject_id" id="subject" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" >
                    <option value="">Select Subject</option>
                </select>
            </div>

          
        </div>

        <!-- Fourth Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div id="bn_container" style="display: none;">
                <label class="block font-semibold">Bn</label>
                <select name="bn" id="bn" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Bn</option>
                    <option value="kagera">Kagera</option>
                    <option value="mazongotto">Mazongotto</option>
                    <option value="kaka">Kaka</option>
                    <option value="muweleza">Muweleza</option>
                </select>
            </div>

            <div id="coy_container" style="display: none;">
                <label class="block font-semibold">Coy</label>
                <select name="coy" id="coy" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Coy</option>
                    <option value="a">A</option>
                    <option value="b">B</option>
                    <option value="c">C</option>
                </select>
            </div>

            <div id="pl_container" style="display: none;">
                <label class="block font-semibold">Pl</label>
                <select name="pl" id="pl" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Pl</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                </select>
            </div>

            <div id="sec_container" style="display: none;">
                <label class="block font-semibold">Sec</label>
                <select name="sec" id="sec" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Sec</option>
                    <option value="I">I</option>
                    <option value="II">II</option>
                    <option value="III">III</option>
                </select>
            </div>
        </div>



    
        <form id="filterForm">
            @csrf
            <!-- Your form fields go here -->
            
            <!-- Save Button -->
            <div class="mt-6 text-center">
                <button type="submit" class="bg-blue-600 text-white px-6 py-3 rounded-lg shadow hover:bg-blue-700 focus:outline-none">
                    Save Marks
                </button>
            </div>
        </form>
        
        

   
        

        
    </form>
    <!-- Button to download as PDF -->
    <div class="mb-4">
        <a href="{{ route('marks.report', request()->all() + ['download_pdf' => 1]) }}" class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700">
            Generate Report PDF
        </a>
    </div>

    <!-- Report Table -->
  
</div>
<script>
    $(document).ready(function () {
        // Helper function to show/hide containers
        function toggleContainer(containerId, show) {
            const container = $(`#${containerId}_container`);
            if (show) {
                container.show();
            } else {
                container.hide();
                $(`#${containerId}`).val('');
            }
        }
    
        // School change handler
        $('#school_id').change(function () {
            const schoolId = $(this).val();
            toggleContainer('course', !!schoolId);
    
            if (schoolId) {
                $.get("{{ route('getCourses') }}", { school_id: schoolId })
                    .done(function (data) {
                        $('#course_id').html('<option value="">Select Course</option>');
                        $.each(data, function (id, name) {
                            $('#course_id').append(`<option value="${id}">${name}</option>`);
                        });
                    });
            }
        });
    
        
        $('#course_id').change(function () {
        const courseId = $(this).val();
        toggleContainer('intake', !!courseId);  // Show intake if course is selected
    
        if (courseId) {
            // Fetch intakes for the selected course
            $.get("{{ route('getIntakes') }}", { course_id: courseId })
                .done(function (data) {
                    $('#intake_id').html('<option value="">Select Intake</option>');
                    $.each(data, function (id, year) {
                        $('#intake_id').append(`<option value="${id}">${year}</option>`);
                    });
                });
    
            // Fetch subjects associated with the selected course (using pivot table)
    
         
    
            
                $.get("{{ route('getSubjectss') }}", { course_id: courseId })
                .done(function (data) {
                    // Populate subject dropdown
                    $('#subject').html('<option value="">Select Subject</option>');  // Clear previous subjects
                    $.each(data, function (index, subject) {
                        $('#subject').append(`<option value="${subject.id}">${subject.code}</option>`);
                    });
    
                });
           
            
          
        } else {
            // Hide the subject dropdown if no course is selected
            toggleContainer('subject', false);
        }
    });
    
    
    
        // Intake change handler
        $('#intake_id').change(function () {
            toggleContainer('phase', !!$(this).val());
        });
    
        // Phase change handler
        $('#choose_phase').change(function () {
            toggleContainer('assessment_type', !!$(this).val());
        });
    
        // Assessment Type change handler
        $('#choose_assessment_type').change(function () {
            const assessmentType = $(this).val();
            toggleContainer('assessment_group', !!assessmentType);
    
            if (assessmentType) {
                let options = '<option value="">Select Assessment Group</option>';
                if (assessmentType === 'MSK') {
                    options += `
                        <option value="Theory">Theory</option>
                        <option value="Practical">Practical</option>
                    `;
                } else if (assessmentType === 'Character Assessment') {
                    options += `
                        <option value="22 CR">22 CR</option>
                        <option value="PR">PR</option>
                    `;
                }
                $('#choose_assessment_group').html(options);
            }
        });
    
        // Assessment Group change handler
      // Assessment Group change handler
    $('#choose_assessment_group').change(function () {
        const assessmentGroup = $(this).val();
        
        // Reset and show type container
        toggleContainer('type', !!assessmentGroup);
        
        // Modify exam type options based on assessment group
        if (assessmentGroup === 'Theory') {
            // Include all exam types for Theory
            $('#choose_type').html(`
                <option value="">Select Exam Type</option>
                <option value="Weekly">Weekly</option>
                <option value="Monthly">Monthly</option>
                <option value="End of Phase Exam">End of Phase Exam</option>
            `);
        } else if (assessmentGroup === 'Practical') {
            // Exclude End of Phase Exam for Practical
            $('#choose_type').html(`
                <option value="">Select Exam Type</option>
                <option value="Weekly">Weekly</option>
            
            `);
        }
    });
    
        // Exam Type change handler
        $('#choose_type').change(function () {
        const examType = $(this).val();
        const assessmentGroup = $('#choose_assessment_group').val();
        const courseId = $('#course_id').val();
    
        // Toggle weeks visibility for weekly exams
        toggleContainer('weeks', examType === 'Weekly');
    
        // Show Subject and Exercises based on exam type and assessment group
        if (assessmentGroup === 'Theory') {
            toggleContainer('subject', examType === 'End of Phase Exam');
            toggleContainer('exercises', false);
        } else if (assessmentGroup === 'Practical') {
            toggleContainer('subject', false);
            toggleContainer('exercises', examType === 'End of Phase Exam' || examType === 'Weekly');
        }
    
        // Show Bn/Regt for relevant exam types
        toggleContainer('bn', ['Weekly', 'Monthly', 'End of Phase Exam'].includes(examType));
    });
    
        // Bn/Regt change handler
        $('#bn').change(function () {
            toggleContainer('coy', !!$(this).val());
        });
    
        // Coy change handler
        $('#coy').change(function () {
            toggleContainer('pl', !!$(this).val());
        });
    
        // Pl change handler
        $('#pl').change(function () {
            toggleContainer('sec', !!$(this).val());
        });
    });
    
    
    // Add this inside your existing $(document).ready function
    $('#filterForm').on('submit', function(e) {
        e.preventDefault();
        
        // Collect all marks data
        const marksData = [];
        $('#studentList input[type="number"]').each(function() {
            const studentId = $(this).attr('id').replace('marks_', '');
            const marks = $(this).val();
            if (marks) { // Only include if marks are entered
                marksData.push({
                    admission_id: studentId,
                    marks: marks
                });
            }
        });
    
        // Collect all filter data
        const formData = {
            marks: marksData,
            school_id: $('#school_id').val(),
            course_id: $('#course_id').val(),
            intake_id: $('#intake_id').val(),
            phase: $('#choose_phase').val(),
            assessment_type: $('#choose_assessment_type').val(),
            assessment_group: $('#choose_assessment_group').val(),
            type: $('#choose_type').val(),
            subject_id: $('#subject').val(),
            exercises: $('#exercises').val(),
            bn: $('#bn').val(),
            coy: $('#coy').val(),
            pl: $('#pl').val(),
            sec: $('#sec').val(),
            week: $('#weeks').val()
        };
    
        // Send AJAX request
        $.ajax({
        url: "{{ route('saveMarks') }}",
        method: 'POST',
        data: {
            _token: $('input[name="_token"]').val(),
            ...formData
        },
        success: function(response) {
            // Display a message in the UI instead of an alert
            $('#successMessage').text('Marks saved successfully! You can continue.').show();
    
            // Optionally, redirect after a delay
            setTimeout(function() {
                window.location.href = "{{ route('marks.index') }}";
            }, 2000); // Redirect after 2 seconds
        },
        error: function(xhr) {
            $('#errorMessage').text('Error saving marks: ' + xhr.responseText).show();
        }
    });
    
    
    });
    // When the form is ready for submission
    $(document).ready(function () {
        // Function to update student list
        function updateStudentList() {
            const filters = {
                school_id: $('#school_id').val(),
                course_id: $('#course_id').val(),
                intake_id: $('#intake_id').val(),
                choose_phase: $('#choose_phase').val(),
                choose_assessment_type: $('#choose_assessment_type').val(),
                choose_assessment_group: $('#choose_assessment_group').val(),
                choose_type: $('#choose_type').val(),
                bn: $('#bn').val(),
                coy: $('#coy').val(),
                pl: $('#pl').val(),
                sec: $('#sec').val()
            };
    
            // Only proceed if we have the minimum required filters
            if (filters.school_id && filters.course_id && filters.sec) {
                $.ajax({
                    url: "{{ route('getFilteredStudents') }}",
                    method: 'GET',
                    data: filters,
                    success: function(students) {
                        console.log('Received students:', students); // Debug log
                        displayStudents(students);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching students:', error);
                        $('#studentList').html('<li class="text-red-500">Error loading students. Please try again.</li>');
                    }
                });
            }
        }
    
        // Update the displayStudents function
        function displayStudents(students) {
            const studentList = $('#studentList');
            studentList.empty();
    
            if (!Array.isArray(students) || students.length === 0) {
                studentList.html('<li class="text-gray-500">No students found for the selected filters.</li>');
                return;
            }
    
            let counter = 1;
    
    students.forEach(student => {
        studentList.append(`
            <div class="flex items-center justify-between">
                <div class="flex">
                    <span class="font-medium">
                        ${counter}. ${student.army_number || 'N/A'} | ${student.rank || 'N/A'} 
                        ${student.name ? ` | ${student.name}` : ''}
                    </span>
                </div>
                <div class="flex items-center">
                    <input 
                        type="number" 
                        id="marks_${student.id}" 
                        name="marks[${student.id}]" 
                        class="w-24 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500"
                        min="0"
                        max="100"
                        placeholder="Marks"
                    >
                </div>
            </div>
        `);
        counter++;
    });
    
    
    
        }
    
        // Add change event listeners to all filter fields
        const filterFields = [
            'school_id', 'course_id', 'intake_id', 'choose_phase',
            'choose_assessment_type', 'choose_assessment_group', 'choose_type',
            'bn', 'coy', 'pl', 'sec'
        ];
    
        filterFields.forEach(fieldId => {
            $(`#${fieldId}`).change(function() {
                updateStudentList();
            });
        });
    });
    
    
    
    </script>
@endsection
