<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>End Of Phase Report</title>
<style>
    body {
        font-family: "Times New Roman";
        width: 100%;
        margin: 0 auto;
        padding-top: 80px;
        padding-bottom: 80px;
        position: relative;
        min-height: calc(7 * 29.7cm);
    }

    body::before {
        content: "";
        position: fixed;
        top: 50%;
        left: 50%;
        width: 200px;
        height: 200px;
        background: url('bmts-logo1.png') no-repeat center center;
        background-size: contain;
        opacity: 0.1;
        transform: translate(-50%, -50%);
        z-index: -1;
        pointer-events: none;
        user-select: none;
    }

    @media print {
        @page {
            size: A4;
            margin: 2cm;
        }
        
        body {
            height: calc(7 * 29.7cm - 4cm);
            overflow: hidden;
        }
        
        .no-print {
            display: none;
        }
        
        .compact-table {
            position: static !important;
            overflow: visible !important;
            box-shadow: none !important;
            max-height: none !important;
        }
        
        .page-1-content { page-break-after: always; max-height: calc(29.7cm - 4cm); overflow: hidden; }
        .page-2-content { page-break-after: always; max-height: calc(29.7cm - 4cm); overflow: hidden; }
        .page-3-content { page-break-after: always; max-height: calc(29.7cm - 4cm); overflow: hidden; }
        .page-4-content { page-break-after: always; max-height: calc(29.7cm - 4cm); overflow: hidden; }
        .page-5-content { page-break-after: always; max-height: calc(29.7cm - 4cm); overflow: hidden; }
        .page-6-content { page-break-after: always; max-height: calc(29.7cm - 4cm); overflow: hidden; }
        .page-7-content { max-height: calc(29.7cm - 4cm); overflow: hidden; }
    }

    .page-break {
        page-break-before: always;
        break-before: page;
    }

    header {
        position: fixed;
        top: -20px;
        left: 0;
        right: 0;
        height: 20px;
        text-align: center;
    }

    footer {
        position: fixed;
        bottom: 10px;
        left: 0;
        right: 0;
        height: 20px;
        text-align: center;
    }

    h1, h2, h5 {
        text-align: center;
    }

    .section-title {
        font-weight: bold;
        text-decoration: underline;
    }

    /* Adaptive table sizing based on content */
    .compact-table {
        width: 100%;
        border-collapse: collapse;
        table-layout: auto;
        margin-bottom: 2px;
    }
    
    /* Small table for fewer columns */
    .compact-table.few-columns {
        font-size: 0.9em;
    }
    
    /* Smaller font for many columns */
    .compact-table.many-columns {
        font-size: 0.7em;
    }
    
    /* Very small for excessive columns */
    .compact-table.excessive-columns {
        font-size: 0.6em;
    }

    .compact-table th,
    .compact-table td {
        border: 1px solid black;
        padding: 3px 4px;
        text-align: left;
        word-wrap: break-word;
    }
    
    /* Smaller padding for tables with many columns */
    .compact-table.many-columns th,
    .compact-table.many-columns td {
        padding: 2px 3px;
    }
    
    .compact-table.excessive-columns th,
    .compact-table.excessive-columns td {
        padding: 1px 2px;
    }

    .fixed-table th {
        position: sticky;
        top: 0;
        background-color: #f2f2f2;
        z-index: 10;
    }

    .section {
        margin: 15px 0;
        padding-bottom: 15px;
        border-bottom: 1px dotted #ccc;
    }
    
    .section-title {
        font-weight: bold;
        margin-bottom: 10px;
    }
    
    .signature-line {
        display: flex;
        justify-content: space-between;
        margin-top: 15px;
    }
    
    .signature-field, .date-field {
        flex: 1;
        border-bottom: 1px dotted #999;
        margin: 0 10px;
        height: 20px;
    }
    
    .page-number {
        position: absolute;
        bottom: 50px;
        width: 100%;
        text-align: center;
        font-size: 12px;
        font-weight: bold;
    }

    @media print {
        .page-number {
            position: fixed;
            bottom: 50px;
        }
        
        .page-number:nth-of-type(n+8) {
            display: none;
        }
    }

    .phase-info {
        font-size: 12px;
        margin-top: 5px;
        margin-bottom: 5px;
    }

    .performance-section .sub-section {
        margin-bottom: 8px;
    }

    .performance-section table {
        margin-bottom: 0px;
    }

    .remarks-box {
        margin-bottom: 0px;
        padding: 15px;
    }

    /* Hide rows/sections with no data */
    .hidden-section {
        display: none;
    }

    /* Signature sections */
    .signature-section {
        margin: 25px 0;
        padding: 15px;
        border: 1px solid #ddd;
        border-radius: 5px;
    }

    .signature-space {
        height: 80px;
        border-bottom: 1px solid #000;
        margin: 10px 0;
        position: relative;
    }

    .signature-label {
        position: absolute;
        bottom: -20px;
        left: 0;
        font-size: 11px;
        color: #666;
    }

    .signature-date {
        position: absolute;
        bottom: -20px;
        right: 0;
        font-size: 11px;
        color: #666;
    }

    @media screen and (max-width: 768px) {
        .compact-table {
            font-size: 0.75em;
        }
        
        .compact-table th,
        .compact-table td {
            padding: 1px 2px;
        }
    }
</style>
<script>
    // Function to dynamically adjust table classes based on column count
    function adjustTableSizing() {
        document.querySelectorAll('.compact-table').forEach(table => {
            const columnCount = table.rows[0]?.cells.length || 0;
            
            // Remove existing size classes
            table.classList.remove('few-columns', 'many-columns', 'excessive-columns');
            
            // Add appropriate class based on column count
            if (columnCount <= 5) {
                table.classList.add('few-columns');
            } else if (columnCount <= 10) {
                table.classList.add('many-columns');
            } else {
                table.classList.add('excessive-columns');
            }
        });
    }

    // Function to check if all values in a row are zero
    function hasNonZeroValues(cells) {
        for (let i = 1; i < cells.length; i++) { // Skip first cell (label)
            const value = parseFloat(cells[i].textContent.trim());
            if (!isNaN(value) && value !== 0) {
                return true;
            }
        }
        return false;
    }

    // Function to check if all values in a table are zero
    function hasNonZeroValuesInTable(table) {
        const dataRows = Array.from(table.rows).slice(1); // Skip header row
        let hasNonZero = false;
        
        dataRows.forEach(row => {
            if (hasNonZeroValues(row.cells)) {
                hasNonZero = true;
            }
        });
        
        return hasNonZero;
    }

    // Function to hide exercise sections with all zero values
    function hideZeroExerciseSections() {
        const exerciseSections = [
            'c. PHYSICAL TRAINING EXERCISES.',
            'd. RANGE EXERCISES',
            'e. TACTICAL EXERCISES.',
            'f. DRILL EXERCISES.',
            'g. MAP USING EXERCISE'
        ];
        
        document.querySelectorAll('.sub-section').forEach(section => {
            const sectionTitle = section.querySelector('p strong')?.textContent;
            
            // Check if this is an exercise section
            if (sectionTitle && exerciseSections.some(exercise => sectionTitle.includes(exercise))) {
                const tables = section.querySelectorAll('table');
                let hasData = false;
                
                tables.forEach(table => {
                    if (hasNonZeroValuesInTable(table)) {
                        hasData = true;
                    }
                });
                
                // Hide section if no non-zero data found
                if (!hasData) {
                    section.classList.add('hidden-section');
                }
            }
        });
    }

    // Run on page load
    window.addEventListener('DOMContentLoaded', function() {
        adjustTableSizing();
        hideZeroExerciseSections();
    });
</script>
</head>
<body>
    <header>
     <p style="font-weight: bold;"> STAFF IN CONFIDENCE</p>
    </header>
    
    <footer>
        <p style="font-weight: bold;"> STAFF IN CONFIDENCE</p>
    </footer>
    
    <main>
        <div class="table-containe" style="">
            <h1>UGANDA PEOPLES' DEFENCE FORCES</h1>
            <h2>BASIC MILITARY TRAINING SCHOOL</h2>
            <div class="header">
                <center> <img src="{{ asset('bmts-logo1.png') }}" alt="Logo" class="logo" width="100" height="100"></center>
            </div>
    
            <h5 style="text-align: center;">INDIVIDUAL TRAINING RECORD FOR<br>OFFICER CADET COURSE</h5>
            <h5 style="text-align: center;">INTAKE {{ $student->intake->year }} </h5>
            <h5 style="text-align: center;">STUDENT'S PARTICULARS</h5>
          
            <center style="margin-bottom: 10px;">
                <div style="">
                    <div class="w-100px flex-shrink-0">
                        @if($student->image)
                        <img
                        src="{{'http://localhost/army_project2/army_project2/public/' . $student->image }}"
                        width="100" height="100">
                        @else
                            <div class="w-100 h-100 bg-gray-200 rounded-lg flex items-center justify-center">
                                <span class="text-gray-400">No Image</span>
                            </div>
                        @endif
                    </div>
                </div>
            </center>
    
            <table class="compact-table small-table" style="margin-top: 10px;">
              <tr>
                <th>ARMY NO</th>
                <th>RANK</th>
                <th>FULL NAMES</th>
              </tr>
              <tr>
                <td>{{ $student->army_number }}</td>
                <td>O/CDT</td>
                <td>{{ $student->name }}</td>
              </tr>
              <tr>
                <th>INTAKE</th>
                <th>COURSE DURATION</th>
                <th>UNIT</th>
              </tr>
              <tr>
                <td>{{ $student->intake->year }}</td>
                <td>11 MONTHS</td>
                <td>{{ optional($student->armyRecord)->UNIT ?? 'N/A'}}</td>
              </tr>
            </table>
    
            <div style="">
                <table class="compact-table small-table">
                    <tr>
                        <th >BN  </th>
                        <td>{{ $student->bn }}</td>
                    </tr>
                    <tr>
                        <th>COY</th>
                        <td>{{ $student->coy }}</td>
                    </tr>
                    <tr>
                        <th>PL</th>
                        <td>{{ $student->pl }}</td>
                    </tr>
                    <tr>
                        <th>SEC</th>
                        <td>{{ $student->sec }}</td>
                    </tr>
                </table>
            </div>
    
            <div style="">
                <table class="compact-table small-table">
                    <tr>
                        <th >OC</th>
                        <td>{{ strtoupper($oc) ?? "N/A" }}</td>
                    </tr>
                    <tr>
                        <th>PL COMD</th>
                        <td>{{ strtoupper($pl_commad) ?? "N/A" }}</td>
                    </tr>
                    <tr>
                        <th>PL SGT</th>
                        <td>{{strtoupper($pl_sgt) ?? "N/A"}}</td>
                    </tr>
                    <tr>
                        <th>SEC COMD</th>
                        <td>{{ strtoupper($sec_commad) ?? "N/A" }}</td>
                    </tr>
                </table>
            </div>
        
            <div class="page-number"></div>
            <div class="page-break"></div>
            
          <div class="table-containe">
            <h4>CONTENTS</h4>
            <ol>
              <li>Table of Contents....................................................................................................................Page 1</li>
              <li>Introduction.............................................................................................................................Page 2</li>
              <li>O/Cdt Course Grading.............................................................................................................Page 2</li>
              <li>End of Course Report..............................................................................................................Page 3-4</li>
              <li>Instructors Pen Picture.............................................................................................................Page 5</li>
              <li>Character Assessment</li>
              <li>General Remarks</li>
            </ol>
        </div>
        <div class="page-number">1</div>
        <div class="page-break"></div>
        
        <div class="table-containe">
            <div class="section">
                <div class="section-title" style="text-decoration: underline font-weight: bold">INTRODUCTION</div>
                <p>1. This report provides a summation of O/Cdt's individual performance. It details the Cadet's performance at the end of 
                    
                     @if ($whichPhase->name == "Phase 1" || $whichPhase->name == "Phase 2" )
                     {{ $whichPhase->name }}  
                     @else
                         Course
                     @endif

                    , presents an overall assessment of their conduct throughout the 
                    @if ($whichPhase->name == "Phase 3")
                        phases
                    @else
                        phase
                    @endif
                    , and includes a pen picture compiled by the Instructors.</p>
            </div>
            
            <div class="section">
                <div class="section-title">GRADING</div>
                <p>2. O/Cdts are grade as shown below:</p>
    
                <table class="compact-table small-table">
                    <tr>
                        <th>MARKS</th>
                        <th>GRADE</th>
                        <th>COMMENT</th>
                        <th>REMARKS</th>
                    </tr>
                    <tr>
                        <td>90 - 100%</td>
                        <td>A</td>
                        <td>Excellent</td>
                        <td>Passed</td>
                    </tr>
                    <tr>
                        <td>80 - 89.9%</td>
                        <td>B</td>
                        <td>Very Good</td>
                        <td>Passed</td>
                    </tr>
                    <tr>
                        <td>70 - 79.9%</td>
                        <td>C</td>
                        <td>Good</td>
                        <td>Passed</td>
                    </tr>
                    <tr>
                        <td>60 - 69.9%</td>
                        <td>D</td>
                        <td>Satisfactory</td>
                        <td>Passed</td>
                    </tr>
                    <tr>
                        <td>50 - 59.9%</td>
                        <td>E</td>
                        <td>Fair</td>
                        <td>Passed</td>
                    </tr>
                    <tr>
                        <td>00 - 49.9%</td>
                        <td>F</td>
                        <td>Poor</td>
                        <td>Failed</td>
                    </tr>
                </table>
            </div>
    
            <div class="page-number">2</div>
            <div class="page-break"></div>
        </div>
    
        <div class="section performance-section">
{{-- a. WEEKLY TESTS --}}
<div class="sub-section">
    <p><strong>a. WEEKLY TESTS.</strong></p>
    <table class="compact-table small-table">
        <tr>
            <th>WEEK</th>
            @foreach ($weeklyMark ?? [] as $mark)
                <th>{{ ucfirst(str_replace('week', 'w', $mark->week)) }}</th>
            @endforeach
        </tr>
        <tr>
            <td>RESULTS</td>
            @foreach ($weeklyMark ?? [] as $mark)
                <td>{{ $mark->marks }}</td>
            @endforeach
        </tr>
    </table>

    @php
        // Calculate weekly scores directly in the template
        $weeklyMarksArray = $weeklyMark->pluck('marks')->toArray();
        $weeklyRawAverage = count($weeklyMarksArray) > 0 ? array_sum($weeklyMarksArray) / count($weeklyMarksArray) : 0;
        
        // Get weekly weight (default to 15 if not found)
        $weeklyWeight = 15; // Default weight
        if (isset($examWeights['Weekly'])) {
            $weeklyWeight = $examWeights['Weekly'];
        }
        
        $weeklyWeightedScore = ($weeklyRawAverage * $weeklyWeight) / 100;
    @endphp

    <p class="phase-info">Raw Average: {{ number_format($weeklyRawAverage, 2) }}%</p>
    <p class="phase-info">Weighted Score: {{ number_format($weeklyWeightedScore, 2) }}%</p>

</div>

{{-- b. MONTHLY TESTS --}}
<div class="sub-section">
    <p><strong>b. MONTHLY TESTS.</strong></p>
    <table class="compact-table small-table">
        <tr>
            <th>MONTHLY</th>
            @foreach ($monthlyMarks ?? [] as $mark)
                <th>{{ $mark->month ?? 'N/A' }}</th>
            @endforeach
        </tr>
        <tr>
            <td>RESULTS</td>
            @foreach ($monthlyMarks ?? [] as $mark)
                <td>{{ $mark->marks }}</td>
            @endforeach
        </tr>
    </table>

    @php
        // Calculate monthly scores directly in the template
        $monthlyMarksArray = $monthlyMarks->pluck('marks')->toArray();
        $monthlyRawAverage = count($monthlyMarksArray) > 0 ? array_sum($monthlyMarksArray) / count($monthlyMarksArray) : 0;
        
        // Get monthly weight (default to 10 if not found)
        $monthlyWeight = 10; // Default weight
        if (isset($examWeights['Monthly'])) {
            $monthlyWeight = $examWeights['Monthly'];
        }
        
        $monthlyWeightedScore = ($monthlyRawAverage * $monthlyWeight) / 100;
    @endphp

    <p class="phase-info">Raw Average: {{ number_format($monthlyRawAverage, 2) }}%</p>
    <p class="phase-info">Weighted Score: {{ number_format($monthlyWeightedScore, 2) }}%</p>

</div>
            </div>
        
            {{-- c. PHYSICAL TRAINING EXERCISES --}}
            <div class="sub-section">
                <p><strong>c. PHYSICAL TRAINING EXERCISES.</strong></p>
                <table class="compact-table small-table">
                    <tr>
                        <th>PT</th>
                        @foreach ($ptWeek ?? [] as $codeName => $weekName)
                            <th>
                                {{ ucfirst(str_replace('week', 'w', $weekName)) }}
                                @if ($codeName)
                                    <small>({{ $codeName }})</small>
                                @endif
                            </th>
                        @endforeach
                    </tr>
                    <tr>
                        <td>RESULTS</td>
                        @foreach ($ptMarks ?? [] as $mark)
                            <td>{{ $mark }}</td>
                        @endforeach
                    </tr>
                </table>
        
                <p class="phase-info">Phase average: {{ number_format($ptAverage, 2) }}</p>
                <p class="phase-info">Score: {{ number_format($totalPt, 2) }}</p>
            </div>
        
            {{-- d. RANGE EXERCISES --}}
            <div class="sub-section">
                <p><strong>d. RANGE EXERCISES</strong></p>
                <table class="compact-table small-table">
                    <tr>
                        <th>SAA</th>
                        @foreach ($saaWeek ?? [] as $codeName => $weekName)
                            <th>
                                {{ ucfirst(str_replace('week', 'w', $weekName)) }}
                                @if ($codeName)
                                    <small>({{ $codeName }})</small>
                                @endif
                            </th>
                        @endforeach
                    </tr>
                    <tr>
                        <td>RESULTS</td>
                        @foreach ($saaMarks ?? [] as $mark)
                            <td>{{ $mark }}</td>
                        @endforeach
                    </tr>
                </table>
        
                <p class="phase-info">Phase average: {{ number_format($saaAverage, 2) }}</p>
                <p class="phase-info">Score: {{ number_format($totalSaa, 2) }}</p>
            </div>
              
            {{-- e. TACTICAL EXERCISES --}}
            <div class="sub-section">
                <p><strong>e. TACTICAL EXERCISES.</strong></p>
                <table class="compact-table small-table">
                    <tr>
                        <th>TAC</th>
                        @foreach ($tacWeek ?? [] as $codeName => $weekName)
                            <th>
                                {{ ucfirst(str_replace('week', 'w', $weekName)) }}
                                @if ($codeName)
                                    <small>({{ $codeName }})</small>
                                @endif
                            </th>
                        @endforeach
                    </tr>
                    <tr>
                        <td>RESULTS</td>
                        @foreach ($tacMarks ?? [] as $mark)
                            <td>{{ $mark }}</td>
                        @endforeach
                    </tr>
                </table>
        
                <p class="phase-info">Phase average: {{ number_format($tacAverage, 2) }}</p>
                <p class="phase-info">Score: {{ number_format($totalTac, 2) }}</p>
            </div>
        
            {{-- f. DRILL EXERCISES --}}
            {{-- <div class="sub-section">
                <p><strong>f. DRILL EXERCISES.</strong></p>
                <table class="compact-table small-table">
                    <tr>
                        <th>DR</th>
                        @foreach ($drWeek ?? [] as $codeName => $weekName)
                            <th>
                                {{ ucfirst(str_replace('week', 'w', $weekName)) }}
                                @if ($codeName)
                                    <small>({{ $codeName }})</small>
                                @endif
                            </th>
                        @endforeach
                    </tr>
                    <tr>
                        <td>RESULTS</td>
                        @foreach ($drMarks ?? [] as $mark)
                            <td>{{ $mark }}</td>
                        @endforeach
                    </tr>
                </table>
        
                <p class="phase-info">Phase average: {{ number_format($drAverage, 2) }}</p>
                <p class="phase-info">Score: {{ number_format($totalDr, 2) }}</p>
            </div>
         --}}
            {{-- g. MAP USING EXERCISE --}}
            <div class="sub-section">
                <p><strong>g. MAP USING EXERCISE</strong></p>
                <table class="compact-table">
                    <tr>
                        <th>MU</th>
                        @foreach ($muWeek ?? [] as $codeName => $weekName)
                            <th>
                                {{ ucfirst(str_replace('week', 'w ', $weekName ?? "N/A")) }}
                                @if ($codeName)
                                    <small>({{ $codeName }})</small>
                                @endif
                            </th>
                        @endforeach
                    </tr>
                    <tr>
                        <td>RESULTS</td>
                        @foreach ($muMarks ?? [] as $mark)
                            <td>{{ $mark }}</td>
                        @endforeach
                    </tr>
                </table>
        
                <p class="phase-info">Phase average: {{ number_format($muAverage, 2) }}</p>
                <p class="phase-info">Score: {{ number_format($totalMu, 2) }}</p>
            </div>
        
            {{-- h. END OF PHASE - ONE EXAMS --}}
{{-- h. END OF PHASE - ONE EXAMS --}}
<div class="sub-section">
    <p><strong>h. END OF PHASE - ONE EXAMS</strong>.</p>
    <table class="compact-table small-table">
        <tr>
            <th>Exam</th>
            @foreach ($endOfPhaseExams ?? [] as $exam)
                <th>{{ $exam->subject->code ?? "N/A" }}</th>
            @endforeach
        </tr>
        <tr>
            <td>RESULTS</td>
            @foreach ($endOfPhaseExams ?? [] as $exam)
                <td>{{ $exam->marks }}</td>
            @endforeach
        </tr>
    </table>

    @php
        // Calculate End of Phase scores directly in the template
        $endOfPhaseMarksArray = $endOfPhaseExams->pluck('marks')->toArray();
        $endOfPhaseRawAverage = count($endOfPhaseMarksArray) > 0 ? array_sum($endOfPhaseMarksArray) / count($endOfPhaseMarksArray) : 0;
        
        // Get End of Phase weight (default to 25 if not found)
        $endOfPhaseWeight = 25; // Default weight
        if (isset($examWeights['End of Phase Exam'])) {
            $endOfPhaseWeight = $examWeights['End of Phase Exam'];
        }
        
        $totalEndOfPhase = ($endOfPhaseRawAverage * $endOfPhaseWeight) / 100;
    @endphp

    <p class="phase-info">Phase average: {{ number_format($endOfPhaseRawAverage, 2) }}%</p>
    <p class="phase-info">Score: {{ number_format($totalEndOfPhase, 2) }}%</p>

</div>
        
            {{-- j. PEER RATING SCORE --}}
            <div class="sub-section" style="display: inline-block;">
                <p><strong>j. PEER RATING SCORE:</strong> 
                    <span style="display: inline-block; width: 100px; border: 1px solid black;">
                        {{ number_format($performanceData['character_pr']['obtained'], 2) }}%
                    </span>
                </p>
        
                {{-- k. 22 CR SCORE --}}
                <p><strong>k. 22 CR SCORE:</strong> 
                    <span style="display: inline-block; width: 100px; border: 1px solid black;">
                        {{ number_format($performanceData['character_22cr']['obtained'], 2) }}%
                    </span>
                </p>
            </div>
        </div>
        
        <div class="page-number">3</div>
        <div class="page-break"></div>
        
        <div class="section">
            <p>2. <strong>SUMMARY PERFORMANCE</strong></p>
    
            <table class="compact-table small-table">
                <thead>
                    <tr>
                        <th>S/NO</th>
                        <th>Description</th>
                        <th>Maximum Score</th>
                        <th>Pass Mark</th>
                        <th>Obtained Marks</th>
                        <th>Remarks</th>
                    </tr>
                    <tr>
                        <th>(a)</th>
                        <th>(b)</th>
                        <th>(c)</th>
                        <th>(d)</th>
                        <th>(e)</th>
                        <th>(f)</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Group 1: MSK Theory & MSK Practical -->
                    <tr>
                        <td rowspan="2">1</td>
                        <td>MSK Theory</td>
                        <td>{{ $performanceData['msk_theory']['max_score'] }}%</td>
                        <td>{{ $performanceData['msk_theory']['pass_mark'] }}%</td>
                        <td>{{ number_format($performanceData['msk_theory']['obtained'], 2) }}%</td>
                        <td class="{{ $performanceData['msk_theory']['remarks'] === 'FAILED' ? 'text-red-600 font-bold' : 'text-green-600' }}">
                            {{ $performanceData['msk_theory']['remarks'] ?? 'N/A' }}
                        </td>
                    </tr>
                    <tr>
                        <td>MSK Practical</td>
                        <td>{{ $performanceData['msk_practical']['max_score'] }}%</td>
                        <td>{{ $performanceData['msk_practical']['pass_mark'] }}%</td>
                        <td>{{ number_format($performanceData['msk_practical']['obtained'],2) }}%</td>
                        <td class="{{ $performanceData['msk_practical']['remarks'] === 'FAILED' ? 'text-red-600 font-bold' : 'text-green-600' }}">
                            {{ $performanceData['msk_practical']['remarks'] ?? 'N/A' }}
                        </td>
                    </tr>
    
                    <!-- Group 2: Character Assessment 22CR & PR -->
                    <tr>
                        <td rowspan="2">2</td>
                        <td>Character Assessment 22CR</td>
                        <td>{{ $performanceData['character_22cr']['max_score'] }}%</td>
                        <td>{{ $performanceData['character_22cr']['pass_mark'] }}%</td>
                        <td>{{ number_format($performanceData['character_22cr']['obtained'],2) }}%</td>
                        <td class="{{ $performanceData['character_22cr']['remarks'] === 'FAILED' ? 'text-red-600 font-bold' : 'text-green-600' }}">
                            {{ $performanceData['character_22cr']['remarks'] ?? 'N/A' }}
                        </td>
                    </tr>
                    <tr>
                        <td>Character Assessment PR</td>
                        <td>{{ $performanceData['character_pr']['max_score'] }}%</td>
                        <td>{{ $performanceData['character_pr']['pass_mark'] }}%</td>
                        <td>{{ number_format($performanceData['character_pr']['obtained'],2) }}%</td>
                        <td class="{{ $performanceData['character_pr']['remarks'] === 'FAILED' ? 'text-red-600 font-bold' : 'text-green-600' }}">
                            {{ $performanceData['character_pr']['remarks'] ?? 'N/A' }}
                        </td>
                    </tr>
    
                    <!-- Total Row -->
                    <tr>
                        <td colspan="2"><strong>TOTAL</strong></td>
                        <td>{{ $performanceData['summary']['total_max_score'] }}%</td>
                        <td>{{ $performanceData['summary']['total_pass_mark'] }}%</td>
                        <td>{{ $performanceData['summary']['total_obtained'] }}%</td>
                        <td></td>
                    </tr>
    
                    <!-- Grade Row -->
                    <tr>
                        <td colspan="6" class="text-right font-bold">
                            <strong>GRADE:</strong> {{ $performanceData['summary']['grade'] }}
                        </td>
                    </tr>
    
                    <!-- General Remarks -->
                    <tr>
                        <td colspan="6"><strong>GENERAL REMARKS:</strong> {{ $performanceData['summary']['status'] }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="page-number">4</div>
        <div class="page-break"></div>

        
        </div>
<div class="section">
            <div class="section-title" style="margin-bottom: 8px; text-decoration: underline; font-size: 14px;">REMARKS</div>

            <!-- 3. PL Comd Remarks -->
            <div class="remarks-box" style="margin-bottom: 15px; border: 1px solid #ddd; padding: 12px; border-radius: 5px;">
                <p style="font-weight: bold; margin-bottom: 10px; font-size: 13px;">3. PL Comd's Remarks:</p>
            
                <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-top: 12px; padding: 5px;">
                    <div style="flex: 1;">



                        @foreach ($remarks as $item)
                              


                 @if(substr($whichPhase->name, -1) == $item->phase)

                                <p style="font-size: 12px;">{{ $item->pl_comd_remarks }}</p>
                            

                    @endif

           
                        @endforeach

                    </div>
                 
                        <div style="text-align: left; margin-top: 15px; padding: 5px;">
                            <div style="border-top: 1px dotted #000; width: 180px; margin-top: 3px;"></div>
                            <p style="margin: 2px 0 0 0; font-size: 11px;">Signature</p>
                        </div>
                </div>
            </div>

            <!-- 4. OC's Remarks -->
            <div class="remarks-box" style="margin-bottom: 15px; border: 1px solid #ddd; padding: 12px; border-radius: 5px;">
                <p style="font-weight: bold; margin-bottom: 10px; font-size: 13px;">4. OC's Remarks:</p>
            
                <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-top: 12px; padding: 5px;">
                    <div style="flex: 1;">
                        @foreach ($remarks as $item)
                            @if($item->oc_remarks)
                                <p style="font-size: 12px;">{{ $item->oc_remarks }}</p>
                            @else
                                <!-- Dotted lines for remarks only if empty -->
                                <div style="margin-top: 10px;">
                           
                                </div>
                            @endif
                        @endforeach

                        <div style="text-align: left; margin-top: 15px; padding: 5px;">
                            <div style="border-top: 1px dotted #000; width: 180px; margin-top: 3px;"></div>
                            <p style="margin: 2px 0 0 0; font-size: 11px;">Signature</p>
                        </div>
                    </div>
                    <div style="text-align: left; margin-left: 20px;">
    
                    </div>
                </div>
            </div>

            <!-- 5. CI's Remarks -->
            {{-- <div class="remarks-box" style="margin-bottom: 20px; border: 1px solid #ddd; padding: 12px; border-radius: 5px;">
                <p style="font-weight: bold; margin-bottom: 10px; font-size: 13px;">5. CI's Remarks:</p>

                <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-top: 12px; padding: 5px;">
                    <div style="flex: 1;">
                        @foreach ($remarks as $item)
                            @if($item->ci_remarks)
                                <p style="font-size: 12px;">{{ $item->ci_remarks }}</p>
                            @else
                                <!-- Dotted lines for remarks only if empty -->
                                <div style="margin-top: 10px;">
                        
                                </div>
                            @endif
                        @endforeach

                        <div style="text-align: left; margin-top: 15px; padding: 5px;">
                            <div style="border-top: 1px dotted #000; width: 180px; margin-top: 3px;"></div>
                            <p style="margin: 2px 0 0 0; font-size: 11px;">Signature</p>
                        </div>
                    </div>
                    <div style="text-align: left; margin-left: 20px;">
               
                    </div>
                </div>
            </div> --}}
          <!-- 5. CI's Remarks -->
            <div class="remarks-box" style="margin-bottom: 40px; border: 1px solid #ddd; padding: 20px; border-radius: 5px;">
                <p style="font-weight: bold; margin-bottom: 15px;">5. CI's Remarks:</p>
        
                @if($performanceData['summary']['grade'])
                    <div style="margin-bottom: 20px;">
                        @switch($performanceData['summary']['grade'])
                            @case('A')
                                <p>{{ $student->name }} demonstrated exceptional performance throughout phase one, showing outstanding military aptitude and leadership qualities.</p>
                                @break
                            @case('B')
                                  <p>
his report is being written on O/Cdt {{ $student->name }}
Who has successfully attended and completed O/Cdt course intake 19/2025 at Basic Military School-Kaweweta. O/Cdt {{ $student->name }}during the entire period of the course was able to consistently demonstrate exceptional performance in leadership and his/her deep commitment to the core values of the military where discipline, MSK and Team work are crucial. It’s out of hard work that made him/her to achieve all that it takes to be an officer. O/Cdt {{ $student->name }} is encouraged to maintain the same spirit in the officer core and the sky shall be the limit.

                                 </p>
                             
                                @break
                            @case('C')

                                <p>O/Cdt {{ $student->name }} approached the course with enthusiasm and the willing heart for the course. During the entire period of the course @if ($student->sex == 'M') He @else She @endif approved to be a good team player, disciplined and always up to the task. He/she has successfully completed the course and qualifies to be an officer who is all round in his/her deployment</p>
                               
                                @break
                            @case('D')
                                  <p>O/Cdt {{ $student->name }}  has averagely performed during the course of O/Cdt intake 19/2025 in most fields but  @if ($student->sex == 'M') He @else She @endif has been hard working, disciplined and a good team player who qualifies for graduation as officer and be deployed in field force as a commander.</p>
                              
                                @break
                            @case('E')

                                  <p>O/Cdt {{ $student->name }} has successfully completed O/Cdt course intake19/2025 and performed averagely which may have been caused by the vigorous course or academic levels. However, @if ($student->sex == 'M') He @else She @endif had the enthusiasm and zeal to endure throughout the course. @if ($student->sex == 'M') He @else She @endif was hard working and a good team player and can be deployed in the field force.     </p>
                              
                                @break
                            @case('F')
                                <p>Despite @if ($student->sex == 'M') His @else Her @endif desire for the course, {{ $student->name }} displayed little effort to learn and practice course contents. 
                                @if ($student->sex == 'M') He @else She @endif attained grade F .</p>
                                @break
                        @endswitch
                    </div>
                @endif
        
                <div style="text-align: left; margin-top: 20px; padding: 10px;">
                    <img src="{{ asset('si.png') }}" alt="CI Signature" style="width: 120px; height: auto; margin-bottom: 8px;">
                    <div style="border-top: 1px solid #000; width: 250px; margin-top: 5px;"></div>
                    <p style="margin: 5px 0 0 0;">Signature</p>
                </div>
            </div>

            <!-- 6. Commandant's Signature (Pen Picture) -->
            <div class="remarks-box" style="margin-bottom: 20px; border: 1px solid #ddd; padding: 12px; border-radius: 5px;">
                <p style="font-weight: bold; margin-bottom: 10px; font-size: 13px;">6. Comdt's Remarks:</p>

                <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-top: 12px; padding: 5px;">
                    <div style="flex: 1;">
                        @foreach ($remarks as $item)
                            @if($item->comdt_remarks)
                                {{-- <p style="font-size: 12px;">{{ $item->comdt_remarks }}</p> --}}
                            @else
                                <!-- Dotted lines for remarks only if empty -->
                                <div style="margin-top: 10px;">
                             
                             
                                </div>
                            @endif
                        @endforeach

                        <div style="text-align: left; margin-top: 15px; padding: 5px;">
                            <div style="border-top: 1px dotted #000; width: 180px; margin-top: 3px;"></div>
                            <p style="margin: 2px 0 0 0; font-size: 11px;">Signature</p>
                        </div>
                    </div>
                    <div style="text-align: left; margin-left: 20px;">
                 
                    </div>
                </div>
            </div>

            <!-- 7. Student's Signature -->
            <div class="remarks-box" style="margin-bottom: 20px; border: 1px solid #ddd; padding: 12px; border-radius: 5px;">
                <p style="font-weight: bold; margin-bottom: 10px; font-size: 13px;">7.       O/CDT
                {{ $student->name }}</p>
   
                
                <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-top: 12px; padding: 5px;">
                    <div style="flex: 1;">
                        <div style="text-align: left; margin-top: 15px; padding: 5px;">
                            <div style="border-top: 1px dotted #000; width: 180px; margin-top: 3px;"></div>
                            <p style="margin: 2px 0 0 0; font-size: 11px;">Student's Signature</p>
                        </div>
                  
                    </div>
                
                </div>
            </div>
</div>
        {{-- <center>
            @if(isset($qr_code))
                <div style="text-align: right; margin-top: 15px;">
                    <p style="font-size: 10px;">Scan this QR code to verify the authenticity of this report:</p>
                    <img src="data:image/png;base64,{{ $qr_code }}" width="80" height="80" alt="QR Code">
                </div>
            @endif
        </center> --}}
    </main>
</body>
<script>
     document.getElementById('ci-current-date').innerText = new Date().toLocaleDateString();
</script>
</html>