@extends('layouts.app')

@section('content')
<div class="container mt-5">
    <div class="container mx-auto mt-5">
        <div class="flex justify-center">
            
            <div class="w-full max-w-md">
                <h2 class="text-2xl font-bold text-gray-900 mb-5">Individual Summary Report</h2>
                <div class="bg-white shadow-lg rounded-2xl p-6">
                    <div class="text-lg font-semibold mb-4">Search Cadet Report</div>
                    <div>
                        <form action="{{ route('report.generate2') }}" method="POST">
                            @csrf
                            <div class="mb-4">
                                <label for="army_number" class="block text-sm font-medium text-gray-700">Army Number</label>
                                <input type="text" id="army_number" name="army_number" required class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            </div>

                            <button type="submit" class="w-full bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600">Generate Report</button>

                            <p class="text-gray-400 p-5">Please ensure the entered Cadet Army Number has Theory,Practial, 22 CR, and PR data entered before creating the summary report</p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
