<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Performance Report</title>
    <style>
        body {
            font-family: sans-serif;
        }
        .container {
            width: 80%;
            margin: 20px auto;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            display: block;
            margin: 0 auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .remarks {
            font-style: italic;
        }
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="{{ asset('amry_project/bmts-logo1.png') }}" alt="Logo" class="logo">
            <h1>Performance Report</h1>
        </div>

        {{-- <h2>Phase One Summary of Performance for {{ $students->name }}</h2> --}}
        <table>
            <thead>
                <tr>
                    <th>S/NO</th>
                    <th>Description</th>
                    <th>Maximum Score</th>
                    <th>Pass Mark</th>
                    <th>Obtained Marks</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>MSK<br>Theory<br>Practical</td>
                    <td>40%<br>30%</td>
                    <td>20%<br>15%</td>
                    <td>{{ $students->msk_theory }}%<br>{{ $students->msk_practical }}%</td>
                    <td>{{ ($students->msk_theory >= 20 && $students->msk_practical >= 15) ? 'PASSED' : 'FAILED' }}</td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Character Assessment<br>22CR<br>PR</td>
                    <td>20%<br>10%</td>
                    <td>10%<br>05%</td>
                    <td>{{ $students->character_assessment_22cr }}%<br>{{ $students->character_assessment_pr }}%</td>
                    <td>{{ ($students->character_assessment_22cr >= 10 && $students->character_assessment_pr >= 5) ? 'PASSED' : 'FAILED' }}</td>
                </tr>
                <tr>
                    <td colspan="2"><strong>TOTAL</strong></td>
                    <td>100%</td>
                    <td>50%</td>
                    <td>{{ $student->calculateTotal() }}%</td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="2"><strong>GRADE</strong></td>
                    <td colspan="3">{{ $students->calculateGrade() }}</td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="6"><strong>GENERAL REMARKS:</strong> {{ $studenst->isPassed() ? 'PASSED' : 'FAILED' }}</td>
                </tr>
            </tbody>
        </table>
        
        <div class="no-print">
            <button onclick="window.print()" class="btn btn-primary">Print Report</button>
            <a href="{{ route('report.search') }}" class="btn btn-secondary">Back to Search</a>
        </div>
    </div>
</body>
</html>