@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-6xl mx-auto">
        <h1 class="text-2xl font-bold mb-6">Dynamic Remarks Templates</h1>

        <!-- Add New Template Form -->
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4">Add New Remark Template</h2>
            <form action="{{ route('remark-templates.store') }}" method="POST">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Phase</label>
                        <select name="phase_id" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm">
                            @foreach($phases as $phase)
                                <option value="{{ $phase->id }}">{{ $phase->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Grade</label>
                        <select name="grade" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm">
                            <option value="A">A</option>
                            <option value="B">B</option>
                            <option value="C">C</option>
                            <option value="D">D</option>
                            <option value="E">E</option>
                            <option value="F">F</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Remark Type</label>
                        <select name="type" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm">
                            <option value="ci">CI's Remarks</option>
                            <option value="comdt">Commandant's Remarks</option>
                        </select>
                    </div>
                </div>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Remark Text</label>
                    <textarea name="remark_text" rows="3" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm" 
                        placeholder="Use {{name}}, {{pronoun}}, {{possessive}}, {{rank}}, {{army_number}} as placeholders"></textarea>
                </div>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md">Save Template</button>
            </form>
        </div>

        <!-- Templates List -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b">
                <h2 class="text-lg font-semibold">Existing Templates</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Phase</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Grade</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Remark</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($templates as $template)
                        <tr>
                            <td class="px-6 py-4">{{ $template->phase->name }}</td>
                            <td class="px-6 py-4">{{ $template->grade }}</td>
                            <td class="px-6 py-4">{{ $template->type == 'ci' ? "CI's Remarks" : "Commandant's Remarks" }}</td>
                            <td class="px-6 py-4 text-sm">{{ Str::limit($template->remark_text, 80) }}</td>
                            <td class="px-6 py-4">
                                <form action="{{ route('remark-templates.destroy', $template) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection