<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{$student->name}}'s Transcript </title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Times New Roman', serif;
      
margin-top: 5%;
                /* margin: 40px; */
        text-align: center;
        }

        .page-container {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .page {
            width: 21cm;
            min-height: 29.7cm;
      
            padding: 1.5cm;
       
        }

        
        /* Three border lines */
        .border-lines {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            pointer-events: none;
        }
        
        .border-line {
            position: absolute;
            border: 2px solid #000000;
        }
        
        .border-line-1 {
            top: 15px;
            left: 15px;
            right: 15px;
            bottom: 15px;
        }
        
        .border-line-2 {
            top: 20px;
            left: 20px;
            right: 20px;
  border: 6px solid #000000;
            bottom: 20px;
        }
        
        .border-line-3 {
            top: 30px;
            left: 30px;
            right: 30px;
            bottom: 30px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1 {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }

        .header h2 {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 15px;
        }

        .header-info {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            margin-bottom: 20px;
        }

        .logo {
            width: 80px;
            height: 80px;
            border: 2px solid black;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #e8f5e9;
        }

        .contact-info {
            text-align: left;
            font-size: 11px;
            line-height: 1.4;
        }

        .transcript-box {
            border: 2px solid black;
            padding: 20px;
            margin: 20px 0;
        }

        .transcript-title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .transcript-subtitle {
            text-align: center;
            font-size: 12px;
            margin-bottom: 15px;
        }

        .info-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            margin-bottom: 15px;
            font-size: 11px;
        }

        .info-row {
            display: flex;
            gap: 10px;
        }

        .info-label {
            font-weight: bold;
        }

table {
    width:85%;
    border-collapse: collapse;
    margin: 25px auto; /* centers the table horizontally */
    font-size: 10px;
  text-align: left;
        border: 1px solid #000;
}

        th, td {
            border: 1px solid black;
            padding: 6px;
            text-align: left;
        }

        th {
            background: #f5f5f5;
            font-weight: bold;
            text-align: center;
        }

        .category-header {
            background: #e0e0e0;
            font-weight: bold;
            text-transform: uppercase;
        }

        .indent {
            padding-left: 20px;
        }

        .summary-row {
            font-weight: bold;
            background: #f9f9f9;
        }

        .footer-note {
            text-align: center;
            font-size: 10px;
            font-style: italic;
            margin-top: 10px;
        }

        .award-section {
            margin-top: 15px;
            font-size: 11px;
        }

.signature-section {
    text-align: left;
    padding: 10px 0;
}

.signature-line {
    margin-top: 10px;
}


.stamp-note {
    font-size: 0.8em;
    margin-top: 2px;
}

   .footer-note {
        text-align: center;
        font-size: 11px;
        font-style: italic;
    }

        /* Page 2 Styles */
        .key-section {
            margin-bottom: 30px;
    margin-left: 10px;
        }

        .key-title {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 10px;
            font-size: 12px;
        }

        .key-table {
            width: 60%;
      margin: 25px auto; /* centers the table horizontally */
        }

        .key-table td {
            padding: 5px 10px;
            border: none;
        }

        .key-table .grade {
            width: 60px;
            font-weight: bold;
        }

        .key-table .score {
            width: 80px;
            text-align: center;
        }

        .key-table .percentage {
            text-align: left;
        }

        .abbrev-table td {
            border: none;
            padding: 3px 10px;
        }

        .abbrev-table .abbrev {
            width: 120px;
            font-weight: bold;
        }

        .abbrev-table .dash {
            width: 30px;
            text-align: center;
        }

        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .page {
                box-shadow: none;
                page-break-after: always;
            }
        }
    /* body {
        font-family: "Times New Roman", Times, serif;
        margin: 40px;
        text-align: center;
    } */

    h1 {
        font-size: 28px;
        font-weight: bold;
        margin-bottom: 5px;
        text-transform: uppercase;
    }

    h2 {
        font-size: 18px;
        font-weight: bold;
        margin-top: 0;
        margin-bottom: 10px;
        text-transform: uppercase;
    }

    .logo {
        display: block;
        margin: 10px auto;
    }

    .contact {
        font-size: 12px;
        margin-bottom: 20px;
        line-height: 1.3;
    }

    h3 {
        font-size: 18px;
        font-weight: bold;
        margin-bottom: 5px;
        text-decoration: underline;
    }

    h4 {
        font-size: 14px;
        margin-top: 0;
        margin-bottom: 20px;
    }

    .details {
        font-size: 12px;
        padding: 10px;
        line-height: 1.4;
        text-align: left;
    }

     .left-div, .right-div {
            flex: 1;
            min-width: 300px;
            padding: 20px;
        }

    .details p {
        margin: 3px 0;
    }

    .table-header h2 {
        font-size: 16px;
        font-weight: bold;
        margin: 0;
        text-transform: uppercase;
    }
    .table-header {
        text-align: center;
        border: none;
    }

    .table-header h3 {
        text-decoration: underline;
        margin-bottom: 4px;
        font-size: 18px;
    }

    .table-header h4 {
        margin: 0;
        font-size: 14px;
    }
    </style>
</head>
<body>


    <main>

        <div class="">

    <h1>UGANDA PEOPLES’ DEFENCE FORCES</h1>
    <h2>BASIC MILITARY TRAINING SCHOOL - KAWEWETA</h2>



<div style="width: 100%;">
    <div style="width: 90%; float: left;">
        <div style="text-align: center;">
            <img src="{{ asset('bmts-logo1.png') }}" alt="Logo" class="logob" width="100" height="100">
        </div>
    </div>

    <div  style="width: 48%; float: right; text-align: left; font-size: 15px; line-height: 1.4;">
<p>Kaweweta Barracks</p>
<p>P.O Box 132  BOMBO</p>
<p>Tel: 0392756126 </p>
<p>E-mail: KRTS@updf.go.ug</p>
    </div>
    
    <div style="clear: both;"></div>
</div>


        
        
     <table class="compact-table small-table">
    <!-- Header row inside the table -->
    <tr>
        <td colspan="3" class="table-header">
            <h3>Transcript</h3>
            <h4>Officer Cadet Course</h4>
            <div class="details">

<div>
    <div style="width: 50%; float: left;">
        <p><strong>ARMY NO:</strong> {{$student->army_number}}</p>
        <p><strong>RANK:</strong> O/CDT</p>
        <p><strong>NAMES:</strong> {{$student->name}}</p>
    </div>
    
    <div style="width: 50%; float: right;">
        <p><strong>NATIONALITY:</strong> {{ strtoupper($student->country_origin) }}</p>
        <p><strong>GENDER:</strong> {{$student->sex}}</p>
        <p><strong>INTAKE:</strong> {{$student->intake->year}}</p>
        <p><strong>YEAR:</strong> 2025</p>
    </div>
    
    <div style="clear: both;"></div>
</div>                   


 

        
           
            </div>

        </td>
    </tr>

    <!-- Column headers -->
    <tr>
        <th>Category</th>
        <th>Maximum Score (%)</th>
        <th>Obtained Score</th>
    </tr>

    <tr>
        <td><strong>MONTHLY TESTS</strong></td>
        <td>10.0</td>
        <td>{{ number_format($monthlyAverage, 2) }}</td>
    </tr>

    <tr>
        <td><strong>WEEKLY TESTS</strong></td>
        <td>15.0</td>
        <td>{{ number_format($weeklyAverage, 2) }}</td>
    </tr>

    <tr>
        <td><strong>FINAL EXAMS</strong></td>
        <td>MARKS ATTAINED (%)</td>
        <td>WEIGHTED SCORE</td>
    </tr>

    @php
        $totalMarks = 0;
        $totalWeightedScore = 0;
    @endphp

    @foreach($marks as $mark)
        @php
            $totalMarks += $mark['marks'];
            $totalWeightedScore += ($mark['marks'] * $mark['subject']['weight'] / 100);
        @endphp
        <tr>
            <td>{{ $mark['subject']['code'] }}</td>
            <td>{{ $mark['marks'] }}</td>
            <td>{{ number_format($mark['marks'] * $mark['subject']['weight'] / 100, 2) }}</td>
        </tr>
    @endforeach

    <tr>
        <td><strong>TOTAL FINAL EXAMS</strong></td>
        <td><strong>{{ number_format($totalMarks, 2) }}</strong></td>
        <td><strong>{{ number_format($totalWeightedScore, 2) }}</strong></td>
    </tr>

    <tr>
        <th colspan="3">SUMMARY OF COURSE PERFORMANCE</th>
    </tr>

    <tr>
        <td>MILITARY SKILLS AND KNOWLEDGE</td>
        <td>TOTAL MARKS (%)</td>
        <td>MARKS ATTAINED (%)</td>
    </tr>

    <tr>
        <td>a. THEORY (WEEKLY TESTS, MONTHLY TESTS AND FINAL EXAMS)</td>
        <td>{{ $performanceData['msk_theory']['max_score'] }}</td>
        <td>{{ number_format($performanceData['msk_theory']['obtained'], 2) }}</td>
    </tr>

    <tr>
        <td>b. PRACTICAL/FIELD</td>
        <td>{{ $performanceData['msk_practical']['max_score'] }}</td>
        <td>{{ number_format($performanceData['msk_practical']['obtained'], 2) }}</td>
    </tr>

    <tr>
        <td>2. CHARACTER ASSESSMENT</td>
        <td>{{ $performanceData['character_22cr']['max_score'] }}</td>
        <td>{{ $performanceData['character_22cr']['obtained'] ?? 'N/A' }}</td>
    </tr>

    <tr>
        <td>a. PEER RATING</td>
        <td>{{ $performanceData['character_pr']['max_score'] }}</td>
        <td>{{ number_format($performanceData['character_pr']['obtained'], 2) }}</td>
    </tr>

    <tr>
        <td><strong>TOTAL SCORES</strong></td>
        <td><strong>100</strong></td>
        <td><strong>{{ $performanceData['summary']['total_obtained'] }}</strong></td>
    </tr>
  <!-- AWARD & SIGNATURE SECTION -->
    {{-- <tr>
        <td colspan="3" class="award-section">
            <strong>GRADE:</strong> {{ $performanceData['summary']['grade'] }} &nbsp;&nbsp;|&nbsp;&nbsp;
            <strong>AWARD:</strong> 
            @if($performanceData['summary']['total_obtained'] >= 50)
                CERTIFICATE
            @else
                NONE
            @endif
        </td>
    </tr> --}}
<tr>
    <td><strong>GRADE:</strong></td>
    <td><strong>{{ $performanceData['summary']['grade'] }}</strong></td>
    <td></td>
</tr>
<tr>
    <td><strong>AWARD:</strong></td>
    <td><strong>
        @if($performanceData['summary']['total_obtained'] >= 50)
            CERTIFICATE
        @else
            NONE
        @endif
    </strong></td>
    <td></td>
</tr>

<tr>
    <td colspan="3" class="signature-section">
        <div><strong>DATE OF COMMISSION:</strong> _____________</div>
        <div class="signature-line">
            <strong>CHIEF INSTRUCTOR</strong><br>
            <div class="signature-space">_________________________</div>
        </div>
        <div class="stamp-note">(Not Valid When Unstamped)</div>
    </td>
</tr>

<tr>
    <td colspan="3" class="footer-note">
        For Key to Grades and Abbreviations, See Reverse
    </td>
</tr>
</table>
        
        
          
        </div>
        
        

              <div class="border-lines">
                <div class="border-line border-line-1"></div>
                <div class="border-line border-line-2"></div>
                <div class="border-line border-line-3"></div>
            </div>







    </main>

</body>
</html>
