<!DOCTYPE html>
<html>
<head>
    <title>Report Verification</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background-color: #f0fdf4; color: #065f46; }
        .container { max-width: 600px; margin: auto; padding: 30px; background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #047857; }
        .info { margin-top: 20px; }
        .info p { margin: 10px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>✅ Report is Genuine</h1>
        <div class="info">
            <p><strong>Army Number:</strong> {{ $report->army_number }}</p>
            {{-- <p><strong>Issued At:</strong> {{ $report->issued_at->format('d M Y, H:i') }}</p> --}}
            @if($report->expires_at)
                <p><strong>Expires At:</strong> {{ $report->expires_at->format('d M Y, H:i') }}</p>
            @endif
        </div>
        <p>This report has been verified as an authentic copy issued by the system.</p>
    </div>
</body>
</html>


        
        <h2>Key to Grades</h2>
        <table class="compact-table small-table">
            <tr>
                <th>Grade</th>
                <th>Min %</th>
                <th>Max %</th>
            </tr>
            <tr><td>A</td><td>90</td><td>100%</td></tr>
            <tr><td>B</td><td>80</td><td>89.9%</td></tr>
            <tr><td>C</td><td>70</td><td>79.9%</td></tr>
            <tr><td>D</td><td>60</td><td>69.9%</td></tr>
            <tr><td>E</td><td>50</td><td>59.9%</td></tr>
            <tr><td>F</td><td>00</td><td>49.9%</td></tr>
        </table>
        
        <h2>Key to Abbreviations</h2>
        <table class="compact-table small-table">
            <tr>
                <th>Abbreviation</th>
                <th>Meaning</th>
            </tr>
            <tr><td>TAC</td><td>Tactics</td></tr>
            <tr><td>MU</td><td>Map Using</td></tr>
            <tr><td>COIN/IS</td><td>Counter Insurgency and Internal Security</td></tr>
            <tr><td>COMM</td><td>Communication</td></tr>
            <tr><td>MOI</td><td>Methods of Instruction</td></tr>
            <tr><td>LT</td><td>Leadership Training</td></tr>
            <tr><td>ADM/ORG</td><td>Administration and Organization</td></tr>
            <tr><td>MI</td><td>Military Intelligence</td></tr>
            <tr><td>SD & MW</td><td>Staff Duties and Military Writing</td></tr>
            <tr><td>GP</td><td>General Paper</td></tr>
            <tr><td>ML</td><td>Military Law</td></tr>
            <tr><td>FA</td><td>First Aid</td></tr>
            <tr><td>FOT</td><td>Fundamental of Officer Training</td></tr>
            <tr><td>GK</td><td>General Knowledge</td></tr>
            <tr><td>PE</td><td>Political Education</td></tr>
            <tr><td>SJI</td><td>School Joining Instructions</td></tr>
            <tr><td>PR</td><td>Peer Rating</td></tr>
            <tr><td>ST</td><td>Special Tactics</td></tr>
            <tr><td>IHL</td><td>International Humanitarian Law</td></tr>
            <tr><td>GL</td><td>Guest Lecture</td></tr>
            <tr><td>WT</td><td>Weapon Training</td></tr>
        </table>