@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Create New User</h2>

    @if ($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('users.store') }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        <div class="mb-4">
            <label for="name" class="block text-gray-700 font-semibold mb-2">Name</label>
            <input type="text" 
                   name="name" 
                   id="name" 
                   value="{{ old('name') }}"
                   class="w-full p-3 border border-gray-300 rounded @error('name') border-red-500 @enderror" 
                   required>
            @error('name')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-4">
            <label for="emailInp" class="block text-gray-700 font-semibold mb-2">Email Address</label>
            <div class="flex">
                <input type="text" 
                       class="flex-1 p-3 border border-gray-300 rounded-l @error('email') border-red-500 @enderror" 
                       id="emailInp" 
                       name="email_prefix"
                       value="{{ old('email_prefix') }}" 
                       placeholder="Enter Email" 
                       required>
                <span class="inline-flex items-center px-3 border border-l-0 border-gray-300 bg-gray-50 text-gray-500 rounded-r">
                    @strartbmts.tradoc
                </span>
            </div>
            @error('email')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-4">
            <label for="type" class="block text-gray-700 font-semibold mb-2">Type</label>
            <select name="type" 
                    id="type"
                    class="w-full p-3 border border-gray-300 rounded @error('type') border-red-500 @enderror" 
                    required>
                <option value="">Select a Type</option>
                <option value="admin" {{ old('type') == 'admin' ? 'selected' : '' }}>Admin</option>
                <option value="data_entry_clerk" {{ old('type') == 'data_entry_clerk' ? 'selected' : '' }}>Data Entry Clerk</option>
            </select>
            @error('type')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-4">
            <label for="password" class="block text-gray-700 font-semibold mb-2">Password</label>
            <input type="password" 
                   class="w-full p-3 border border-gray-300 rounded @error('password') border-red-500 @enderror" 
                   id="password" 
                   name="password" 
                   required>
            @error('password')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-4">
            <label for="password_confirmation" class="block text-gray-700 font-semibold mb-2">Confirm Password</label>
            <input type="password" 
                   class="w-full p-3 border border-gray-300 rounded" 
                   id="password_confirmation" 
                   name="password_confirmation" 
                   required>
        </div>

        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">
            Create User
        </button>
    </form>
</div>

<script>
document.querySelector('form').addEventListener('submit', function(e) {
    e.preventDefault();
    const emailPrefix = document.getElementById('emailInp').value;
    const fullEmail = emailPrefix + '@strartbmts.tradoc';
    
    let hiddenEmailField = document.getElementById('hidden_email');
    if (!hiddenEmailField) {
        hiddenEmailField = document.createElement('input');
        hiddenEmailField.type = 'hidden';
        hiddenEmailField.id = 'hidden_email';
        hiddenEmailField.name = 'email';
        this.appendChild(hiddenEmailField);
    }
    hiddenEmailField.value = fullEmail;
    
    this.submit();
});
</script>
@endsection