@extends('layouts.app')
@section('title', 'Weight System Setup')
@section('content')
    <div class="bg-gray-100 min-h-screen py-12">
        <div class="container mx-auto px-4">
            <!-- Page Header -->
            <div class="flex justify-between items-center mb-8">
                <div class="space-y-1">
                    <h1 class="text-4xl font-bold text-gray-800">Weight System Setup</h1>
                    <p class="text-gray-600">Exercises,Exam Weights</p>
                </div>
                <div class="flex space-x-3">
                    {{-- <a href="{{ route('phase.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded-lg shadow hover:bg-blue-700 transition duration-200 flex items-center">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                        Add Phase
                    </a> --}}
                    <a href="{{ route('exercise.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded-lg shadow hover:bg-blue-700 transition duration-200 flex items-center">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                        Add Exercise
                    </a>

                    <a href="{{ route('examweight.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded-lg shadow hover:bg-blue-700 transition duration-200 flex items-center">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                        Add  Exam Weight
                    </a>


                </div>
            </div>

            @if(session('success'))
                <div class="bg-green-500 text-white p-4 mb-6 rounded-lg shadow-md flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    {{ session('success') }}
                </div>
            @endif

            <!-- Accordion Style Display -->
            <div class="space-y-4">
           

                <div class="bg-white rounded-lg shadow-xl overflow-hidden">
                    {{-- <button id="phase-toggle" class="w-full px-6 py-4 bg-green-800 text-white text-left font-semibold flex justify-between items-center">
                        <span class="text-xl">Phases</span>
                        <svg id="phase-icon" class="w-5 h-5 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                        </svg>
                    </button> --}}
                    <div id="phase-content" class="overflow-x-auto">
                        <!-- Next Phase Button - Only shown if there are phases -->
                        {{-- @if($phases->count() > 0)
                            <div class="px-6 py-3 bg-gray-100 flex justify-end">
                           <form action="{{ route('phase.next', ['intake' => $phases->first()->intake_id]) }}" method="POST">

                                    @csrf
                                    <button type="submit" class="bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 transition-colors duration-200 flex items-center">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                                        </svg>
                                        Next Phase
                                    </button>
                                </form>
                            </div>
                        @endif --}}
                        
                   
                    </div>
                </div>
                
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const phaseToggle = document.getElementById('phase-toggle');
                        const phaseContent = document.getElementById('phase-content');
                        const phaseIcon = document.getElementById('phase-icon');
                        
                        phaseToggle.addEventListener('click', function() {
                            phaseContent.classList.toggle('hidden');
                            phaseIcon.classList.toggle('rotate-180');
                        });
                    });
                </script>


                         <!-- Battalion Section -->
                         <div class="bg-white rounded-lg shadow-xl overflow-hidden">
                            <button id="exercises-toggle" class="w-full px-6 py-4 bg-green-800 text-white text-left font-semibold flex justify-between items-center">
                                <span class="text-xl">Exercises</span>
                                <svg id="exercises-icon" class="w-5 h-5 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="exercises-content" class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phase</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Weight</th>

                                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                    @forelse($exercises as $item)
                                        <tr class="hover:bg-gray-50 transition-colors duration-200">
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->phase->name  ?? 'N/A'}}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->title ?? 'N/A' }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->weight  ?? 'N/A'}}</td>

                                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                                <div class="flex justify-end space-x-2">
                                                    <a href="{{ route('exercise.edit', $item) }}" class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600 transition-colors duration-200">
                                                        Edit
                                                    </a>
                                                    <form action="{{ route('exercise.destroy', $item) }}" method="POST" class="inline-block">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600 transition-colors duration-200" onclick="return confirm('Are you sure you want to delete this bn?')">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="2" class="px-6 py-4 text-center text-gray-500">
                                                No records found
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>

                               <!-- Battalion Section -->
                               <div class="bg-white rounded-lg shadow-xl overflow-hidden">
                                <button id="examweight-toggle" class="w-full px-6 py-4 bg-green-800 text-white text-left font-semibold flex justify-between items-center">
                                    <span class="text-xl">Exam Weight</span>
                                    <svg id="examweight-icon" class="w-5 h-5 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                    </svg>
                                </button>
                                <div id="examweight-content" class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phase</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Weight</th>

                                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                        @forelse($examWeight as $item)
                                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->phase->name  ?? 'N/A'}}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->name ?? 'N/A' }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $item->weight  ?? 'N/A'}}</td>

                                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                                    <div class="flex justify-end space-x-2">
                                                        <a href="{{ route('examweight.edit', $item) }}" class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600 transition-colors duration-200">
                                                            Edit
                                                        </a>
                                                        <form action="{{ route('examweight.destroy', $item) }}" method="POST" class="inline-block">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600 transition-colors duration-200" onclick="return confirm('Are you sure you want to delete this bn?')">
                                                                Delete
                                                            </button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="2" class="px-6 py-4 text-center text-gray-500">
                                                    No records found
                                                </td>
                                            </tr>
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>



            </div>
        </div>
    </div>

    <!-- JavaScript for accordion functionality -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get the phase section elements
            const phaseToggle = document.getElementById('phase-toggle');
            const phaseContent = document.getElementById('phase-content');
            const phaseIcon = document.getElementById('phase-icon');

            // Make sure phase section is initially visible
            if (phaseContent) {
                phaseContent.style.display = 'block';
            }

            if (phaseIcon) {
                phaseIcon.classList.add('rotate-180');
            }

            // Add click listener to phase toggle button
            if (phaseToggle) {
                phaseToggle.addEventListener('click', function() {
                    // Toggle content visibility
                    if (phaseContent.style.display === 'none' || phaseContent.classList.contains('hidden')) {
                        phaseContent.style.display = 'block';
                        phaseContent.classList.remove('hidden');
                        phaseIcon.classList.add('rotate-180');
                    } else {
                        phaseContent.style.display = 'none';
                        phaseContent.classList.add('hidden');
                        phaseIcon.classList.remove('rotate-180');
                    }
                });
            }

            // Setup other sections to be initially hidden
            const otherSections = ['exercises', 'examweight', 'cres', 'pr'];
            otherSections.forEach(section => {
                const content = document.getElementById(`${section}-content`);
                if (content) {
                    content.style.display = 'none';
                    content.classList.add('hidden');
                }
            });

            // Add toggle functionality to other sections
            otherSections.forEach(section => {
                const toggle = document.getElementById(`${section}-toggle`);
                const content = document.getElementById(`${section}-content`);
                const icon = document.getElementById(`${section}-icon`);

                if (toggle && content && icon) {
                    toggle.addEventListener('click', function() {
                        if (content.style.display === 'none' || content.classList.contains('hidden')) {
                            content.style.display = 'block';
                            content.classList.remove('hidden');
                            icon.classList.add('rotate-180');
                        } else {
                            content.style.display = 'none';
                            content.classList.add('hidden');
                            icon.classList.remove('rotate-180');
                        }
                    });
                }
            });
        });
    </script>
@endsection
