<?php

use App\Http\Controllers\AdmissionController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MarksController;
use App\Http\Controllers\MarksEntryController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SchoolController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\EntryController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\SubjectController;
use App\Http\Controllers\MarkEntryController;
use App\Http\Controllers\IntakeController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\AdmissionImportController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\AdmissionsImport;
use App\Http\Controllers\UserController;
use App\Http\Controllers\LogController;
use App\Http\Controllers\StudentPerformanceController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\RegistrationController;
use App\Http\Controllers\TwentyTwoCRController;
use App\Http\Controllers\BnController;
use App\Http\Controllers\CoyController;
use App\Http\Controllers\PlController;
use App\Http\Controllers\SecController;
use App\Http\Controllers\ExerciseController;
use App\Http\Controllers\ExamWeightController;
use App\Http\Controllers\CRAssessmentController;
use App\Http\Controllers\CRAssessment2Controller;
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\PRController;
use App\Http\Controllers\RemarkController;
use App\Http\Controllers\PhaseController;
use App\Http\Controllers\PhaseConfigController;
use App\Http\Controllers\DatabaseBackupController;
use App\Http\Controllers\RemarkTemplateController;
// use App\Http\Controllers\SsoController;


/*
|--------------------------------------------------------------------------
| SSO Authentication Routes (PUBLIC - NO MIDDLEWARE)
|--------------------------------------------------------------------------
*/

// Main entry point - SSO login handler (MUST be named 'home')
// Route::get('/', [SsoController::class, 'handleSsoLogin'])->name('home');

Route::get('/',[AuthController::class,'loginIndex'])->name('home');

// SSO processing routes (all public)
// / Main SSO login handler - handles incoming SSO requests from MCOP
// Route::get('/sso/login', [SsoController::class, 'handleSsoLogin'])
//     ->name('sso.login')
//     ->middleware('guest');

// SSO login processor - processes the actual login after loading page
// Route::get('/sso/process', [SsoController::class, 'processSsoLogin'])
//     ->name('sso.process')
//     ->middleware('guest');

// SSO logout handler - clears session and redirects to MCOP logout
// Route::post('/sso/logout', [SsoController::class, 'ssoLogout'])
//     ->name('sso.logout')
//     ->middleware('auth');

// Alternative logout route for GET requests
// Route::get('/sso/logout', [SsoController::class, 'ssoLogout'])
//     ->name('sso.logout.get')
//     ->middleware('auth');
// Route::get('/sso/redirect-mcop', [SsoController::class, 'redirectToMcop'])->name('sso.redirect-mcop');

/*
|--------------------------------------------------------------------------
| Protected Routes (Require SSO Authentication)
|--------------------------------------------------------------------------
*/

// Route::middleware(['auth', 'sso.auth'])->group(function () {

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Logout
    Route::get('logout', [AuthController::class, 'logout'])->name('logout');
    // Route::get('/sso/logout', [SsoController::class, 'ssoLogout'])->name('sso.logout');
    
    // Tradoc
    Route::get('/tradoc', function () {
        return view('tradoc');
    })->name('tradoc');

    /*
    |--------------------------------------------------------------------------
    | User Management
    |--------------------------------------------------------------------------
    */
    Route::resource('users', UserController::class);
    Route::get('/user/password/edit', [UserController::class, 'showPasswordChangeForm'])->name('user.password.edit');
    Route::put('/user/password', [UserController::class, 'updatePassword'])->name('user.password.update');

    /*
    |--------------------------------------------------------------------------
    | Database Backup
    |--------------------------------------------------------------------------
    */
    Route::prefix('backup')->name('backup.')->group(function () {
        Route::get('/', [DatabaseBackupController::class, 'index'])->name('index');
        Route::post('/create', [DatabaseBackupController::class, 'create'])->name('create');
        Route::get('/download/{filename}', [DatabaseBackupController::class, 'download'])->name('download');
        Route::delete('/delete/{filename}', [DatabaseBackupController::class, 'delete'])->name('delete');
        Route::post('/restore/{filename}', [DatabaseBackupController::class, 'restore'])->name('backup.restore');
    });

    /*
    |--------------------------------------------------------------------------
    | Marks Management
    |--------------------------------------------------------------------------
    */
    Route::prefix('marks')->name('marks.')->group(function () {
        Route::get('/edit-page', [MarksController::class, 'editMarks'])->name('editPage');
        Route::get('/filtered', [MarksController::class, 'getFilteredMarks'])->name('getFiltered');
        Route::get('/student/{admissionId}', [MarksController::class, 'getStudentMarks'])->name('getStudent');
        Route::get('/student-by-army', [MarksController::class, 'getStudentMarksByArmyNumber'])->name('getStudentByArmy');
        Route::get('/organizational-units', [MarksController::class, 'getOrganizationalUnits'])->name('getOrgUnits');
        Route::get('/stats', [MarksController::class, 'getMarkStats'])->name('stats');
        Route::put('/update/{id}', [MarksController::class, 'updateMark'])->name('update');
        Route::post('/bulk-update', [MarksController::class, 'bulkUpdateMarks'])->name('bulkUpdate');
        Route::delete('/delete/{id}', [MarksController::class, 'deleteMark'])->name('delete');
        Route::delete('/bulk-delete', [MarksController::class, 'bulkDelete'])->name('bulkDelete');
    });
    
    Route::get('/marks', [MarksController::class, 'index'])->name('marks.index');
    Route::get('/marks2', [MarksController::class, 'index2'])->name('marks.index2');
    Route::get('/marks/{id}/edit', [MarksController::class, 'edit'])->name('marks.edit');
    Route::put('/marks/{id}', [MarksController::class, 'update'])->name('marks.update');
    Route::delete('/marks/{id}', [MarksController::class, 'destroy'])->name('marks.destroy');
    Route::get('/viewmore/{id}', [MarksController::class, 'viewMoreMarks'])->name('more.marks');
    Route::get('/markshow/{id}', [MarksController::class, 'viewMoreMarks'])->name('mark.show');
    Route::get('/markshow2/{id}', [MarksController::class, 'viewMoreMarks2'])->name('mark.show2');
    
    // Marks Export
    Route::post('/marks/export/excel', [MarksController::class, 'exportExcel'])->name('marks.export.excel');
    Route::post('/marks/export/pdf', [MarksController::class, 'exportPdf'])->name('marks.export.pdf');
    Route::get('/marks/export', [MarksController::class, 'export'])->name('marks.export');
    Route::get('/marks/print', [MarksController::class, 'print'])->name('marks.print');
    
    // Marks Entry
    Route::get('/marks-entry', [MarkEntryController::class, 'create2'])->name('marks_entry.create');
    Route::get('/marks-entry2', [MarkEntryController::class, 'create'])->name('marks-entry2');
    Route::post('/marks-entry/store', [MarkEntryController::class, 'store'])->name('marks_entry.store');
    Route::get('/get-filtered-students', [MarkEntryController::class, 'fetchStudents'])->name('getFilteredStudents');
    Route::post('/save-marks', [MarkEntryController::class, 'saveMarks'])->name('saveMarks');
    Route::put('/api/marks/{id}', [MarksController::class, 'update'])->name('marks.update');

    /*
    |--------------------------------------------------------------------------
    | Admissions
    |--------------------------------------------------------------------------
    */
Route::get('/admissions/filter', [PRController::class, 'filter'])->name('admissions.filter');
    Route::resource('admissions', AdmissionController::class);
    Route::get('/admissions/import', [AdmissionController::class, 'importForm'])->name('admissions.importForm');
    Route::post('/admissions/import', [AdmissionController::class, 'import'])->name('admissions.import');
    Route::get('admissions/import', [AdmissionController::class, 'showExcel'])->name('admissions.import.show');
    Route::get('/download-template', [AdmissionController::class, 'downloadTemplate'])->name('admissions.downloadTemplate');
    Route::post('/admissions/search-reg-number', [AdmissionController::class, 'searchRegNumber'])->name('admissions.searchRegNumber');
    Route::post('/search-reg-number', [AdmissionController::class, 'searchRegNumber'])->name('searchRegNumber');
    Route::post('/search-reg-number', [AdmissionController::class, 'searchRegNumber'])->name('searchReg');
    Route::delete('/admissions/bulk-delete', [AdmissionController::class, 'bulkDelete'])->name('admissions.bulkDelete');
    Route::get('admissions/export', [AdmissionController::class, 'export'])->name('admissions.export');
    Route::get('admissions/print', [AdmissionController::class, 'printPDF'])->name('admissions.print');
    Route::get('/admissions/p/list/{type}', [AdmissionController::class, 'plList'])->name('admissions.list');
    Route::get('/get-subjects/{course}', [AdmissionController::class, 'getSubjects'])->name('admissions.getSubjects');
    Route::get('/get-subjects/{courseId}', [AdmissionController::class, 'getSubjects']);
    Route::get('/search-army-number', [AdmissionController::class, 'searchArmyNumber'])->name('searchArmyNumber');
    Route::post('/search-army-number-2', [AdmissionController::class, 'searchArmyNumber2'])->name('searchArmyNumber2');
    Route::post('/admissions/search-army-number', [AdmissionController::class, 'searchArmyNumber'])->name('admissions.searchArmyNumber');
    Route::get('generate/temp/number', [AdmissionController::class, 'generateTempNumber'])->name('generate.temp.number');
  
    /*
    |--------------------------------------------------------------------------
    | CR Assessment
    |--------------------------------------------------------------------------
    */
    Route::get('/cr/mark', [CRAssessment2Controller::class, 'markCRs'])->name('cr.mark');
    Route::post('/cr/update', [CRAssessment2Controller::class, 'updateCRs'])->name('cr.update');
    Route::get('/cr/overview', [CRAssessment2Controller::class, 'overview'])->name('cr.overview');
    Route::get('/cr/export-pdf', [CRAssessment2Controller::class, 'exportPDF'])->name('cr.export.pdf');
    Route::get('/cr/import', [CRAssessment2Controller::class, 'showImportForm'])->name('cr.import.form');
    Route::post('/cr/import', [CRAssessment2Controller::class, 'importCRs'])->name('cr.import');
    
    Route::get('/cr-assessments/22cr', [CRAssessmentController::class, 'show22CR'])->name('cr.assessments.22cr');
    Route::get('/cr-assessments/22cr/overview', [CRAssessmentController::class, 'overView22CR'])->name('cr.assessments.22cr.overview');
    Route::get('/cr-assessment/previous-f-values', [CRAssessmentController::class, 'getPreviousFValues'])->name('cr-assessment.getPreviousFValues');
    Route::get('/cr-assessment/current-f-values', [CRAssessmentController::class, 'getCurrentFValues'])->name('cr-assessment.getCurrentFValues');
    Route::post('cr-assessment/get-f-values', [CRAssessmentController::class, 'getFValues'])->name('cr-assessment.getFValues');
    Route::post('/cr-assessment/get-all-by-army-number', [CRAssessmentController::class, 'getAllByArmyNumber'])->name('cr-assessment.getAllByArmyNumber');
    Route::post('/cr-assessment/check', [CRAssessmentController::class, 'checkAssessment'])->name('cr-assessment.check');
    Route::post('/cr-assessment', [CRAssessmentController::class, 'store'])->name('cr-assessment.store');
    Route::get('cr-assessment/print', [CRAssessmentController::class, 'printPDF'])->name('cr-assessment.print');
    Route::get('/22cr/details/{assessment}', [CRAssessmentController::class, 'getDetails'])->name('22cr.details');
    Route::get('/admissions/print', [CRAssessmentController::class, 'generatePDF'])->name('admissions.print22c');

    /*
    |--------------------------------------------------------------------------
    | PR (Performance Rating)
    |--------------------------------------------------------------------------
    */
    Route::resource('pr', PRController::class);
    Route::get('/pr/mark', [PRController::class, 'markPRs'])->name('prs.mark');
    Route::get('/prs/mark', [PRController::class, 'markPRs'])->name('prs.mark');
    Route::post('/pr/update', [PRController::class, 'updatePRs'])->name('prs.update');
    Route::post('/prs/update', [PRController::class, 'updatePRs'])->name('prs.update');
    Route::get('/pr/import', [PRController::class, 'showPRImportForm'])->name('pr.import.form');
    Route::post('/pr/import', [PRController::class, 'importPRs'])->name('pr.import');
    Route::get('/pr/list/{admissionId}', [PRController::class, 'showPRList'])->name('pr.list');
    Route::get('/pr/raters', [PRController::class, 'listRaters'])->name('pr.raters');
    Route::get('/pr/create/{admissionId}', [PRController::class, 'create'])->name('pr.create');
    Route::post('/pr/update-rating', [PRController::class, 'updateRating'])->name('pr.updateRating');
    Route::get('/pr/filterPlatoon', [PRController::class, 'filterPlatoon'])->name('pr.filterPlatoon');
    Route::get('/get-coys/{bnId}', [PRController::class, 'getCoys']);
    Route::get('/get-pls/{coyId}', [PRController::class, 'getPls']);

    /*
    |--------------------------------------------------------------------------
    | Reports & Student Performance
    |--------------------------------------------------------------------------
    */
    Route::get('/reports/search', [StudentPerformanceController::class, 'search'])->name('reports.search');
    Route::get('/reports/search2', [StudentPerformanceController::class, 'search2'])->name('reports.search2');
    Route::get('/reports/search3', [StudentPerformanceController::class, 'search3'])->name('reports.search3');
    Route::post('/report/generate', [StudentPerformanceController::class, 'generate'])->name('report.generate');
    Route::post('/report/generate2', [StudentPerformanceController::class, 'generate2'])->name('report.generate2');
    Route::post('/report/generate3', [StudentPerformanceController::class, 'generate3'])->name('report.generate3');
    Route::post('/report/generate-multiple', [StudentPerformanceController::class, 'generateMultiple'])->name('report.generateMultiple');
    Route::post('/reports/generate-enhanced', [StudentPerformanceController::class, 'generateEnhancedReport'])->name('reports.generate-enhanced');
    Route::post('/reports/generate-all-transcripts', [StudentPerformanceController::class, 'generateAllTranscripts'])->name('reports.generate.all.transcripts');
    Route::get('/gpv', [StudentPerformanceController::class, 'gpv'])->name('gpv');
    Route::get('/gpv/saved-reports', [StudentPerformanceController::class, 'savedReports'])->name('gpv.saved-reports');
    Route::get('/gpv/report/{id}', [StudentPerformanceController::class, 'viewSavedReport'])->name('gpv.view-report');
    Route::delete('/gpv/report/{id}', [StudentPerformanceController::class, 'deleteSavedReport'])->name('gpv.delete-report');
    Route::get('/verify/{token}', [ReportController::class, 'verify'])->name('report.verify');

    /*
    |--------------------------------------------------------------------------
    | Remarks
    |--------------------------------------------------------------------------
    */
    Route::get('/remarks', [StudentPerformanceController::class, 'viewRemarks'])->name('viewRemarks');
    Route::get('/remarks/{admissionId}/create', [RemarkController::class, 'create'])->name('remarks.create');
    Route::get('/admissions/{admission}/remarks/create', [RemarkController::class, 'create'])->name('remarks.create');
    Route::post('/remarks', [RemarkController::class, 'store'])->name('remarks.store');
    Route::get('/remarks/{admissionId}/edit', [RemarkController::class, 'edit'])->name('remarks.edit');
    Route::put('/remarks/{remark}', [RemarkController::class, 'update'])->name('remarks.update');
    Route::get('/remarks/{admissionId}', [RemarkController::class, 'fetchRemarks'])->name('remarks.fetch');
    Route::delete('remarks/{id}', [RemarkController::class, 'destroy'])->name('remarks.destroy');
    
    // Remark Templates
    Route::resource('remark-templates', RemarkTemplateController::class);
    Route::post('remark-templates/bulk-delete', [RemarkTemplateController::class, 'bulkDelete'])->name('remark-templates.bulk-delete');

    /*
    |--------------------------------------------------------------------------
    | Phase Configuration
    |--------------------------------------------------------------------------
    */
    Route::get('/phase-config', [PhaseConfigController::class, 'index'])->name('phase-config.index');
    Route::get('/phase-config/create', [PhaseConfigController::class, 'create'])->name('phase-config.create');
    Route::post('/phase-config', [PhaseConfigController::class, 'store'])->name('phase-config.store');
    Route::get('/phase-config/{id}/edit', [PhaseConfigController::class, 'edit'])->name('phase-config.edit');
    Route::put('/phase-config/{id}', [PhaseConfigController::class, 'update'])->name('phase-config.update');
    Route::patch('/phase-config/{id}/set-active', [PhaseConfigController::class, 'setActive'])->name('phase-config.set-active');
    Route::get('/phase-config/grades', [PhaseConfigController::class, 'editGradeScales'])->name('phase-config.edit-grades');
    Route::post('/phase-config/grades', [PhaseConfigController::class, 'updateGradeScales'])->name('phase-config.update-grades');

    /*
    |--------------------------------------------------------------------------
    | Organizational Structure
    |--------------------------------------------------------------------------
    */
    Route::get('/get-pls-by-bn-coy', [PlController::class, 'getPlsByBnCoy'])->name('getPlsByBnCoy');
    Route::get('/get-pls-by-coy', [SecController::class, 'getPlsByCoy'])->name('getPlsByCoy');
    Route::get('/getCoysByBn', [PlController::class, 'getCoysByBn'])->name('getCoysByBn');
    Route::get('/get-platoons-by-coy', [PlController::class, 'getPlsByCoy'])->name('getPlsByCoy');
    Route::get('/getPlsByCoy', [PlController::class, 'getPlsByCoy'])->name('getPlsByCoy');

    /*
    |--------------------------------------------------------------------------
    | Export Routes
    |--------------------------------------------------------------------------
    */
    Route::get('/export/excel', [ExportController::class, 'exportExcel'])->name('export.excel');
    Route::get('/export/csv', [ExportController::class, 'exportCsv'])->name('export.csv');
    Route::get('/export/pdf', [ExportController::class, 'exportPdf'])->name('export.pdf');
    Route::get('/export/print', [ExportController::class, 'printView'])->name('export.print');
    Route::get('/export/excel/asse', [ExportController::class, 'exportExcelAsse'])->name('export.excel.asse');
    Route::get('/export/csv/asse', [ExportController::class, 'exportCsvAsse'])->name('export.csv.asse');
    Route::get('/export/pdf/asse', [ExportController::class, 'exportPdfAsse'])->name('export.pdf.asse');
    Route::get('/export/print/asse', [ExportController::class, 'printViewAsse'])->name('export.print.asse');

    /*
    |--------------------------------------------------------------------------
    | Resource Controllers
    |--------------------------------------------------------------------------
    */
    Route::resource('phase', PhaseController::class);
    Route::resource('intakes', IntakeController::class);
    Route::resource('schools', SchoolController::class);
    Route::resource('courses', CourseController::class);
    Route::resource('subjects', SubjectController::class);
    Route::resource('sec', SecController::class);
    Route::resource('pl', PlController::class);
    Route::resource('coy', CoyController::class);
    Route::resource('bn', BnController::class);
    Route::resource('twenty_two_cr', TwentyTwoCRController::class);
    Route::resource('registrations', RegistrationController::class);
    Route::resource('examweight', ExamWeightController::class);
    Route::resource('exercise', ExerciseController::class);

    /*
    |--------------------------------------------------------------------------
    | Phase Management
    |--------------------------------------------------------------------------
    */
    Route::get('/cres/{phase}', [PhaseController::class, 'cres'])->name('cres');
    Route::get('/pr-weight/{phase}', [PhaseController::class, 'pr'])->name('pr-weigh');
    Route::post('/phase/{phase}/start', [PhaseController::class, 'start'])->name('phase.start');
    Route::post('/phase/{phase}/end', [PhaseController::class, 'end'])->name('phase.end');
    Route::post('/intake/{intake?}/next-phase', [PhaseController::class, 'nextPhase'])->name('phase.next');

    /*
    |--------------------------------------------------------------------------
    | Helper Routes
    |--------------------------------------------------------------------------
    */
    Route::get('/get-courses', [CourseController::class, 'getCourses'])->name('getCourses');
    Route::get('/get-students', [StudentController::class, 'getStudents'])->name('getStudents');
    Route::get('/get-intakes', [IntakeController::class, 'getIntakes'])->name('getIntakes');
    Route::get('/get-subjects', [SubjectController::class, 'getSubjects'])->name('getSubjects');
    Route::get('/subjectss', [SubjectController::class, 'getSubjects'])->name('getSubjectss');
    Route::get('/wss', [SchoolController::class, 'wss'])->name('wss');

    /*
    |--------------------------------------------------------------------------
    | Activity Logs
    |--------------------------------------------------------------------------
    */
    Route::get('activitylogs/index', [ActivityLogController::class, 'index'])->name('activitylogs.index');

    /*
    |--------------------------------------------------------------------------
    | Admin Routes (Optional - may need role middleware)
    |--------------------------------------------------------------------------
    */
    // Route::middleware(['role:admin'])->group(function () {
    //     Route::get('/admin/dashboard', [AdminController::class, 'dashboard']);
    //     Route::get('/marks/report', [MarksController::class, 'generateReport'])->name('marks.report');
    // });

// });

/*
|--------------------------------------------------------------------------
| Legacy Auth Routes (DISABLED - SSO Only)
|--------------------------------------------------------------------------
| These routes are commented out to enforce SSO-only authentication
| Uncomment only if you need traditional login alongside SSO
*/

Route::get('/login', [AuthController::class, 'loginIndex'])->name('login');
Route::get('register', [AuthController::class, 'registerIndex']);
Route::post('login', [AuthController::class, 'login']);
Route::post('register', [AuthController::class, 'register']);