
<?php $__env->startSection('title', 'Edit Bn'); ?>
<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Bn</h2>

    <form action="<?php echo e(route('bn.update', $bn)); ?>" method="POST" class="bg-white max-w-lg mx-auto p-8 rounded-2xl shadow-lg">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
     


        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <div class="w-full">
                <label for="name" class="block text-gray-700 font-medium mb-2">Bn Name</label>
                <input type="text" name="name" id="name" value="<?php echo e(old('name', $bn->name)); ?>" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
            </div>
        
            <div class="w-full">
                <label for="comd_rank" class="block text-gray-700 font-medium mb-2">Rank</label>
                <select name="comd_rank" id="comd_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <?php
  $ranks = [
                    'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                    'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                    'L/Cpl', 'Pte'
                ];
                    ?>
                    <?php $__currentLoopData = $ranks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($rank); ?>" <?php echo e(old('comd_rank', $bn->comd_rank) == $rank ? 'selected' : ''); ?>><?php echo e($rank); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        
            <div class="w-full">
                <label for="comd_name" class="block text-gray-700 font-medium mb-2">Bn Comd Name</label>
                <input type="text" name="comd_name" id="comd_name" value="<?php echo e(old('comd_name', $bn->comd_name)); ?>" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400">
            </div>
        </div>
        
 
        <div class="flex flex-col sm:flex-row gap-4 mt-6">
            <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600 flex-1">Update Bn</button>
            <a href="<?php echo e(route('bn.index')); ?>" class="bg-gray-500 text-white px-6 py-3 rounded hover:bg-gray-600 text-center flex-1">Cancel</a>
        </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\bn\edit.blade.php ENDPATH**/ ?>