
<?php $__env->startSection('title', 'P'); ?>
<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-center">
        <div class="w-full">
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <div class="flex items-center justify-between px-6 py-4 border-b border-gray-200">

                
                    <h5 class="text-lg font-semibold text-gray-800">Phase Configurations</h5>
                    <div class="flex gap-2">
                        <a href="<?php echo e(route('phase-config.create')); ?>" class="bg-blue-600 text-white text-sm px-3 py-1.5 rounded hover:bg-blue-700 inline-flex items-center">
                            <i class="fas fa-plus mr-1"></i> Create New Phase
                        </a>
                        <a href="<?php echo e(route('phase-config.edit-grades')); ?>" class="bg-cyan-600 text-white text-sm px-3 py-1.5 rounded hover:bg-cyan-700 inline-flex items-center">
                            <i class="fas fa-graduation-cap mr-1"></i> Edit Grade Scales
                        </a>
                    </div>
                </div>

                <div class="px-6 py-4">
                    <div class="bg-yellow-100 text-yellow-800 px-4 py-3 rounded mb-4 flex items-start gap-2">
                        <i class="fas fa-exclamation-triangle mt-1"></i>
                        <div>
                            <strong>Warning:</strong> Editing these configurations will directly affect how student evaluations are calculated.
                            Incorrect configurations may result in erroneous assessment results. Please ensure changes are accurate and properly approved.
                        </div>
                    </div>

                    <?php if(session('success')): ?>
                        <div class="bg-green-100 text-green-800 px-4 py-3 rounded mb-4">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <h5 class="text-lg font-semibold text-gray-700 mb-3">Phase Configurations</h5>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white border border-gray-200 text-sm">
                            <thead class="bg-gray-800 text-white">
                                <tr>
                                    <th class="px-4 py-2 text-left">Phase Name</th>
                                    <th class="px-4 py-2 text-left">Theory (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">Practical (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">22CR (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">PR (Max/Pass)</th>
                                    <th class="px-4 py-2 text-left">Status</th>
                                    <th class="px-4 py-2 text-left">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-4 py-2"><?php echo e($phase->phase_name); ?></td>
                                    <td class="px-4 py-2"><?php echo e($phase->msk_theory_config['max_score']); ?> / <?php echo e($phase->msk_theory_config['pass_mark']); ?></td>
                                    <td class="px-4 py-2"><?php echo e($phase->msk_practical_config['max_score']); ?> / <?php echo e($phase->msk_practical_config['pass_mark']); ?></td>
                                    <td class="px-4 py-2"><?php echo e($phase->character_22cr_config['max_score']); ?> / <?php echo e($phase->character_22cr_config['pass_mark']); ?></td>
                                    <td class="px-4 py-2"><?php echo e($phase->character_pr_config['max_score']); ?> / <?php echo e($phase->character_pr_config['pass_mark']); ?></td>
                                    <td class="px-4 py-2">
                                        <?php if($phase->is_active): ?>
                                            <span class="inline-block px-2 py-1 text-xs font-semibold text-green-800 bg-green-200 rounded">Active</span>
                                        <?php else: ?>
                                            <span class="inline-block px-2 py-1 text-xs font-semibold text-gray-600 bg-gray-200 rounded">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-2 space-x-2">
                                        <a href="<?php echo e(route('phase-config.edit', $phase->id)); ?>" class="inline-block bg-blue-500 text-white text-xs px-3 py-1 rounded hover:bg-blue-600">
                                            <i class="fas fa-edit mr-1"></i> Edit
                                        </a>
                                        
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <h5 class="text-lg font-semibold text-gray-700 mt-8 mb-3">Grade Scales</h5>
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white border border-gray-200 text-sm">
                            <thead class="bg-gray-800 text-white">
                                <tr>
                                    <th class="px-4 py-2 text-left">Grade</th>
                                    <th class="px-4 py-2 text-left">Minimum Score (%)</th>
                                    <th class="px-4 py-2 text-left">Comment</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <?php $__currentLoopData = $gradeScales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-4 py-2"><?php echo e($grade->grade); ?></td>
                                    <td class="px-4 py-2"><?php echo e($grade->min_score); ?></td>
                                    <td class="px-4 py-2"><?php echo e($grade->comment); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/phase-config/index.blade.php ENDPATH**/ ?>