

<?php $__env->startSection('content'); ?>
<!-- Loading Overlay -->
<div id="loading-overlay" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex justify-center items-center hidden z-50">
    <div class="text-center">
        <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-white"></div>
        <p class="text-white mt-4">Importing... Please wait</p>
    </div>
</div>

<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Title and Add New Button -->
    <!-- Add this after the "Add New Admission" button -->
    <div class="flex justify-between items-center mb-6">
      
            
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-4xl font-bold text-gray-800">Admissions List</h1>
                <p class="text-gray-600">View and manage the list of admitted cadets</p>
            </div>
        </div>
        
        <div class="flex space-x-2">
            <a href="<?php echo e(route('admissions.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                Add New Admission
            </a>
            
            
        </div>
    </div>
   
        <!-- Success Message -->
        <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
        <script>
            setTimeout(function() {
                document.querySelector('.bg-green-100').style.display = 'none';
            }, 5000); // Hide success message after 5 seconds
        </script>
        <?php endif; ?>

        <!-- Import Statistics -->
        <?php if(session('stats')): ?>
        <div class="alert alert-info bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded mb-4">
            <h5>Import Statistics:</h5>
            <ul>
                <li>Total Rows Processed: <?php echo e(session('stats.total_processed')); ?></li>
                <li>Successfully Imported: <?php echo e(session('stats.successful')); ?></li>
                <li>Failed: <?php echo e(session('stats.failed')); ?></li>
                <li>Processing Time: <?php echo e(number_format(session('stats.processing_time'), 2)); ?> seconds</li>
            </ul>
        </div>
        <script>
            document.querySelector('.alert').classList.add('fade-in');
        </script>
        <?php endif; ?>

        <!-- Import File Section -->
        <div class="flex space-x-2 mb-4">
            <a href="<?php echo e(route('admissions.downloadTemplate')); ?>">
                <button class="bg-blue-500 text-white py-2 px-4 rounded hover:bg-gray-600">
                    Download Template
                </button>
            </a>

            <form action="<?php echo e(route('admissions.import')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="file">Choose File</label>
                    <input type="file" name="file" class="form-control" required>
                </div>
                <button type="submit" class="bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">
                    Import
                </button>
            </form>
        </div>
<!-- Combined Search and Filter Form -->
<form method="GET" action="<?php echo e(route('admissions.index')); ?>" class="mb-4 flex flex-wrap gap-4">
    <!-- Search input -->
    <div class="relative w-full md:w-1/3">
        <input type="text" name="search" placeholder="Search by Army Number, Name"
            value="<?php echo e(request('search')); ?>"
            class="w-full border-gray-300 rounded-lg shadow-sm p-2 pl-10">
        <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 0l7 7"></path>
        </svg>
    </div>
    
    <!-- Filters -->
    <select name="school_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by School</option>
        <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($school->id); ?>" <?php echo e(request('school_id') == $school->id ? 'selected' : ''); ?>><?php echo e($school->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <select name="course_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Course</option>
        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <select name="bn" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Bn</option>
        <?php $__currentLoopData = $bn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bns): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = [$bns]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bnRegt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($bnRegt); ?>" <?php echo e(request('bn') == $bnRegt ? 'selected' : ''); ?>><?php echo e(ucfirst($bnRegt)); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <select name="coy" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Coy</option>
        <?php $__currentLoopData = $coy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coys): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = [$coys]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coyss): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($coyss); ?>" <?php echo e(request('coy') == $coyss ? 'selected' : ''); ?>><?php echo e(strtoupper($coyss)); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
<select name="pl" class="border-gray-300 rounded-lg p-2">
    <option value="">Filter by PL</option>
    <?php for($i = 1; $i <= 3; $i++): ?>
        <option value="<?php echo e($i); ?>" <?php echo e(request('pl') == $i ? 'selected' : ''); ?>>
            <?php echo e($i); ?>

        </option>
    <?php endfor; ?>
</select>

    
    <select name="sec" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Sec</option>
        <?php $__currentLoopData = $sec; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = [$secs]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($sec); ?>" <?php echo e(request('sec') == $sec ? 'selected' : ''); ?>><?php echo e($sec); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
        Apply Filters & Search
    </button>
    
    <!-- Clear filters button -->
    <a href="<?php echo e(route('admissions.index')); ?>" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300">
        Clear All
    </a>
</form>

        <!-- Bulk Delete Form -->
        <form id="bulk-delete-form" action="<?php echo e(route('admissions.bulkDelete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <div class="flex justify-between items-center mb-4">
                <?php if(Auth::user()->type == 'admin'): ?>
                    <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700" onclick="return confirm('Are you sure you want to delete selected records?');">
                        Bulk Delete
                    </button>
                <?php endif; ?>
            </div>
            
            <div class="text-sm text-gray-700">
                Showing 
                <span class="font-medium"><?php echo e($admissions->firstItem() ?? 0); ?></span>
                to 
                <span class="font-medium"><?php echo e($admissions->lastItem() ?? 0); ?></span>
                of 
                <span class="font-medium"><?php echo e($admissions->total()); ?></span>
                results
            </div>
            <!-- Admissions Table -->
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                
                                <th class="px-6 py-3">#</th> <!-- Serial number column -->
                                <th class="px-6 py-3">
                                    <input type="checkbox" id="select-all" class="select-all-checkbox">
                                </th>
                        

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=admission_id&direction=<?php echo e(request('direction') == 'asc' ? 'desc' : 'asc'); ?>">
                                        Admission ID
                                        <?php if(request('sort') == 'admission_id'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                ▲
                                            <?php else: ?>
                                                ▼
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </a>
                                </th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=army_number&direction=<?php echo e(request('direction') == 'asc' ? 'desc' : 'asc'); ?>">
                                        Army Number
                                        <?php if(request('sort') == 'army_number'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                ▲
                                            <?php else: ?>
                                                ▼
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </a>
                                </th>
                                
                                
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rank</th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=name&direction=<?php echo e(request('direction') == 'asc' ? 'desc' : 'asc'); ?>">
                                        Cadet Name
                                        <?php if(request('sort') == 'name'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                ▲
                                            <?php else: ?>
                                                ▼
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </a>
                                </th>
                            
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">School</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Course</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $admissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $admission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <!-- Adjusted numbering based on pagination -->
                                <td class="px-6 py-4"><?php echo e($admissions->firstItem() + $index); ?></td>
                                <td class="px-6 py-4">
                                    <input type="checkbox" name="selected_ids[]" value="<?php echo e($admission->id); ?>" class="select-item">
                                </td>
                                <td class="px-6 py-4"><?php echo e($admission->admission_id); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->army_number); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->rank); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->name); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->school->name); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->course->name); ?></td>
                                <td class="px-6 py-4">
                                    <a href="<?php echo e(route('admissions.show', $admission)); ?>" class="text-green-600 hover:text-blue-900">View</a>
                                    <a href="<?php echo e(route('admissions.edit', $admission)); ?>" class="text-blue-600 hover:text-blue-900">Edit</a>
                                    <form action="<?php echo e(route('admissions.destroy', $admission)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this admission?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <?php if(Auth::user()->type == 'admin'): ?>
                                        <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                                        <?php endif; ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    
                    <!-- Pagination Links -->
                   
                    
                </div>
            </div>
        </form>

        <!-- Pagination -->
    <!-- Pagination -->

 
    <div>
        <?php echo e($admissions->withQueryString()->links()); ?>

    </div>

        <!-- Rows Per Page -->
        <form method="GET" action="<?php echo e(route('admissions.index')); ?>" class="mb-4 flex space-x-2 mt-10">
            <select name="per_page" onchange="this.form.submit()" class="border-gray-300 rounded-lg p-2">
                <?php $__currentLoopData = [25, 50, 100, 250, 500]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($size); ?>" <?php echo e(request('per_page', 25) == $size ? 'selected' : ''); ?>>
                        Show <?php echo e($size); ?> rows
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </form>
    </div>
</div>

<script>
    // Select all checkboxes logic
    document.addEventListener("DOMContentLoaded", function () {
        const selectAllCheckbox = document.getElementById('select-all');
        const rowCheckboxes = document.querySelectorAll('input[type="checkbox"].select-item');

        selectAllCheckbox.addEventListener("change", function () {
            rowCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
        });

        rowCheckboxes.forEach(checkbox => {
            checkbox.addEventListener("change", function () {
                if (![...rowCheckboxes].some(chk => chk.checked)) {
                    selectAllCheckbox.checked = false;
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/admissions/index.blade.php ENDPATH**/ ?>