

<?php $__env->startSection('title', 'Mark CR Assessments'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md">
        <div class="px-6 py-4 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-gray-800">CR Assessment Marking</h3>
                <?php
                    $activePhase = \App\Models\Phase::where('is_active', 1)->first();
                ?>
                <?php if($activePhase): ?>
                    <span class="text-sm font-medium text-blue-600 bg-blue-50 px-3 py-1 rounded-full">
                        Current Phase: <?php echo e($activePhase->name); ?>

                    </span>
                <?php endif; ?>
            </div>
            
            <!-- Warning Alert -->
            <div class="mt-3 bg-yellow-50 border border-yellow-200 rounded-md p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-yellow-800">
                            Important Notice
                        </h3>
                        <div class="mt-2 text-sm text-yellow-700">
                            <p>
                                <strong>WARNING:</strong> Anyone entering these records MUST confirm that the current phase "<?php echo e($activePhase->name ?? 'N/A'); ?>" has no existing marks for the current phase records. 
                                Ensure you are marking the correct phase to avoid data duplication.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Phase Selection Form -->
            <div class="mt-4 bg-gray-50 rounded-lg p-4">
                <form method="GET" action="<?php echo e(route('cr.mark')); ?>" class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="phase" class="block text-sm font-medium text-gray-700 mb-1">
                            Select Phase to Mark:
                        </label>
                        <select name="phase" id="phase" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <?php
                                $phases = \App\Models\Phase::all();
                                $selectedPhase = request('phase', $selectedPhaseId ?? null);
                            ?>
                            <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phaseOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($phaseOption->id); ?>" <?php echo e($selectedPhase == $phaseOption->id ? 'selected' : ''); ?>>
                                    <?php echo e($phaseOption->name); ?> 
                                    <?php if($phaseOption->is_active): ?>
                                        (Active)
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors">
                            Load Phase
                        </button>
                    </div>
                    <?php if($selectedPhase): ?>
                        <div class="text-sm text-gray-600">
                            <span class="font-medium">Selected:</span> 
                            <?php echo e($phases->firstWhere('id', $selectedPhase)->name ?? 'Unknown Phase'); ?>

                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <!-- Filters Section -->
        <div class="p-6">
            <form method="GET" action="<?php echo e(route('cr.mark')); ?>" class="mb-6">
                <input type="hidden" name="phase" value="<?php echo e($selectedPhaseId); ?>">
                <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
                    <div>
                        <label for="bn" class="block text-sm font-medium text-gray-700 mb-1">Filter by Battalion (BN):</label>
                        <select name="bn" id="bn" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Battalions</option>
                            <?php $__currentLoopData = $bns ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($bn); ?>" <?php echo e(request('bn') == $bn ? 'selected' : ''); ?>><?php echo e($bn); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="coy" class="block text-sm font-medium text-gray-700 mb-1">Filter by Company (COY):</label>
                        <select name="coy" id="coy" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Companies</option>
                            <?php $__currentLoopData = $coys ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($coy); ?>" <?php echo e(request('coy') == $coy ? 'selected' : ''); ?>><?php echo e($coy); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="pl" class="block text-sm font-medium text-gray-700 mb-1">Filter by Platoon (PL):</label>
                        <select name="pl" id="pl" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Platoons</option>
                            <?php $__currentLoopData = $pls ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($pl); ?>" <?php echo e(request('pl') == $pl ? 'selected' : ''); ?>><?php echo e($pl); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="sec" class="block text-sm font-medium text-gray-700 mb-1">Filter by Section (SEC):</label>
                        <select name="sec" id="sec" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Sections</option>
                            <?php $__currentLoopData = $secs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sec); ?>" <?php echo e(request('sec') == $sec ? 'selected' : ''); ?>><?php echo e($sec); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="marked" class="block text-sm font-medium text-gray-700 mb-1">Marked Status:</label>
                        <select name="marked" id="marked" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All</option>
                            <option value="1" <?php echo e(request('marked') == '1' ? 'selected' : ''); ?>>Marked</option>
                            <option value="0" <?php echo e(request('marked') == '0' ? 'selected' : ''); ?>>Not Marked</option>
                        </select>
                    </div>
                </div>
                <div class="mt-4 flex space-x-3">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors">
                        Apply Filters
                    </button>
                    <a href="<?php echo e(route('cr.mark')); ?>?phase=<?php echo e($selectedPhaseId); ?>" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition-colors">
                        Reset Filters
                    </a>
                </div>
            </form>

            <?php if(session('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <!-- CR Marking Form -->
            <form method="POST" action="<?php echo e(route('cr.update')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="phase_id" value="<?php echo e($selectedPhaseId); ?>">
                
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-200">
                        <thead class="bg-gray-800 text-white">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">S/No</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Army No</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Rank</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Full Name</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Sex</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Score</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Remarks</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Marked</th>
                                <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Marked By</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php $__empty_1 = true; $__currentLoopData = $admissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $admission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $existingCR = $existingCRs[$admission->id] ?? null;
                                    $currentScore = $existingCR ? $existingCR->score : 0;
                                    $isMarked = $existingCR ? true : false;
                                    $markedBy = $existingCR ? $existingCR->marked_by : null;
                                ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($index + 1); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($admission->army_number); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($admission->rank); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($admission->name); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($admission->sex ?? 'N/A'); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                               <input type="number" 
       name="scores[<?php echo e($admission->id); ?>][score]" 
       value="<?php echo e($currentScore); ?>" 
       min="0" 
       max="15" 
       step="0.1"
       class="w-20 border border-gray-300 rounded px-2 py-1 text-center focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 score-input" 
       onchange="updateRemarks(this)">

                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <span class="remarks text-sm font-semibold px-2 py-1 rounded" id="remarks-<?php echo e($admission->id); ?>">
                                            <?php
                                                echo calculateRemarks($currentScore);
                                            ?>
                                        </span>
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <?php if($isMarked): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Yes</span>
                                        <?php else: ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">No</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">
                                        <?php echo e($markedBy ?? 'Not Marked'); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="px-4 py-4 text-center text-sm text-gray-500">No records found matching your criteria.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($admissions->count() > 0): ?>
                    <div class="mt-6 flex items-center">
                        <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 transition-colors">
                            Save All CR Scores
                        </button>
                        <span class="ml-3 text-sm text-gray-500">Scores will be saved to CR Assessments table</span>
                    </div>
                <?php endif; ?>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function calculateRemarks(score) {
    if (!score) return '';
    
    const numericScore = parseFloat(score);
    if (numericScore >= 97.2) return '9.72 - EXCELLENT';
    if (numericScore >= 90) return '9.0+ - VERY GOOD';
    if (numericScore >= 80) return '8.0+ - GOOD';
    if (numericScore >= 70) return '7.0+ - AVERAGE';
    if (numericScore >= 60) return '6.0+ - BELOW AVERAGE';
    return 'FAIL';
}

function updateRemarks(input) {
    const score = input.value;
    const admissionId = input.name.match(/\d+/)[0];
    const remarksElement = document.getElementById('remarks-' + admissionId);
    
    remarksElement.textContent = calculateRemarks(score);
}

// Initialize remarks on page load
document.addEventListener('DOMContentLoaded', function() {
    const scoreInputs = document.querySelectorAll('.score-input');
    scoreInputs.forEach(input => {
        updateRemarks(input);
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php
function calculateRemarks($score) {
    if (!$score) return '';

    $numericScore = floatval($score);
    
    if ($numericScore >= 97.2) return '9.72 - EXCELLENT';
    if ($numericScore >= 90) return '9.0+ - VERY GOOD';
    if ($numericScore >= 80) return '8.0+ - GOOD';
    if ($numericScore >= 70) return '7.0+ - AVERAGE';
    if ($numericScore >= 60) return '6.0+ - BELOW AVERAGE';
    return 'FAIL';
}
?>

<style>
.remarks {
    font-weight: bold;
}
</style>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\cr\mark.blade.php ENDPATH**/ ?>