<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Military Academy')); ?></title>


    <!-- Tailwind CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/tailwindmain.css')); ?>">

    <!-- Alpine.js for interactivity -->
    <script defer src="<?php echo e(asset('js/cdn.min.js')); ?>"></script>

    <!-- jQuery (only if needed, consider if it's necessary) -->
    <script src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></script>






    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        .modal-content {
            background-color: white;
            margin: 15% auto;
            padding: 20px;
            border-radius: 10px;
            width: 90%;
            max-width: 500px;
            text-align: center;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        .close:hover {
            color: black;
        }

#global-loading-bar {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 3px;
    z-index: 9999;
    opacity: 0;
    visibility: hidden;
    transition: opacity 0.3s ease, visibility 0.3s;
}

#global-loading-bar.active {
    opacity: 1;
    visibility: visible;
}

#loading-progress {
    height: 100%;
    width: 0%;
    background: linear-gradient(90deg, #4facfe 0%, #00f2fe 100%);
    transition: width 0.4s ease;
    box-shadow: 0 0 10px rgba(79, 172, 254, 0.7);
}
    </style>
</head>

<body class="bg-gray-100 min-h-screen flex flex-col pb-2.5-">
<!-- Global Loading Bar -->

    <!-- Top Navigation Bar -->

    <nav class="bg-green-800 text-white shadow-md sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-6 sm:px-8 lg:px-10">
            <div class="flex items-center justify-between h-16">

                <!-- Logo -->
                <div class="flex items-center space-x-4">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <img src="<?php echo e(asset('bmts-logo1.png')); ?>" alt="Logo" class="h-10">
                    </a>

                    <!-- Mobile Menu Button -->
                    <button id="menu-toggle" class="md:hidden text-white focus:outline-none">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                             xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M4 6h16M4 12h16m-7 6h7"></path>
                        </svg>
                    </button>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:flex md:items-center md:space-x-6">
                    <!-- Dashboard -->
                    <a href="<?php echo e(route('dashboard')); ?>"
                       class="px-4 py-2 rounded-lg text-sm font-medium hover:bg-green-600 transition">
                        Dashboard
                    </a>

                    <!-- START Dropdown with Submenu -->
                    <div x-data="{ open: false, activeSubmenu: null }" class="relative">
                        <button @click="open = !open"
                                class="px-4 py-2 rounded-lg text-sm font-medium hover:bg-green-600 transition <?php echo e(Auth::user()->type != 'admin' ? 'opacity-50' : ''); ?>">
                            START ▼
                        </button>
                        <div x-show="open" @click.away="open = false" class="absolute left-0 mt-2 w-48 bg-white text-black rounded shadow-lg z-50">
                            <!-- Schools Submenu -->
                            <div @mouseover="activeSubmenu = 'schools'" @mouseleave="activeSubmenu = null" class="relative">
                                <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">Schools ▶</div>
                                <div x-show="activeSubmenu === 'schools'" class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">
                                    <a href="<?php echo e(route('schools.index')); ?>"
                                       class="block px-4 py-2 hover:bg-gray-200 <?php echo e(Auth::user()->type != 'admin' ? 'pointer-events-none opacity-50' : ''); ?>"
                                       <?php if(Auth::user()->type != 'admin'): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                        Schools
                                    </a>
                        
                                    
                                    <?php $__currentLoopData = [
                                        'subjects' => 'Subjects',
                                      
                                    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(route($route.'.index')); ?>"
                                           class="block px-4 py-2 hover:bg-gray-200 <?php echo e(Auth::user()->type != 'admin' ? 'pointer-events-none opacity-50' : ''); ?>"
                                           <?php if(Auth::user()->type != 'admin'): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                            <?php echo e($label); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                                    
                                    <a href="<?php echo e(route('bn.index')); ?>"
                                       class="block px-4 py-2 hover:bg-gray-200
                                       <?php echo e(!in_array(Auth::user()->type, ['admin', 'data_entry_clerk']) ? 'pointer-events-none opacity-50' : ''); ?>"
                                       <?php if(!in_array(Auth::user()->type, ['admin', 'data_entry_clerk'])): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                        Groupings
                                    </a>

                                    <a href="<?php echo e(route('twenty_two_cr.index')); ?>"
                                    class="block px-4 py-2 hover:bg-gray-200
                                    <?php echo e(!in_array(Auth::user()->type, ['admin']) ? 'pointer-events-none opacity-50' : ''); ?>"
                                    <?php if(!in_array(Auth::user()->type, ['admin'])): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                     22Cr
                                 </a>

                                    <a href="<?php echo e(route('wss')); ?>"
                                    class="block px-4 py-2 hover:bg-gray-200
                                    <?php echo e(!in_array(Auth::user()->type, ['admin']) ? 'pointer-events-none opacity-50' : ''); ?>"
                                    <?php if(!in_array(Auth::user()->type, ['admin'])): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                     WSS
                                 </a>


                                        <a href="<?php echo e(route('phase-config.index')); ?>"
                                    class="block px-4 py-2 hover:bg-gray-200
                                    <?php echo e(!in_array(Auth::user()->type, ['admin']) ? 'pointer-events-none opacity-50' : ''); ?>"
                                    <?php if(!in_array(Auth::user()->type, ['admin'])): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                    Phase Config
                                 </a>

                                

                                    <a href="<?php echo e(route('remark-templates.index')); ?>"
                                    class="block px-4 py-2 hover:bg-gray-200
                                    <?php echo e(!in_array(Auth::user()->type, ['admin']) ? 'pointer-events-none opacity-50' : ''); ?>"
                                    <?php if(!in_array(Auth::user()->type, ['admin'])): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                     Remark Templates
                                 </a>

                                </div>
                            </div>
                        
                            <!-- Students Submenu -->
                            <div @mouseover="activeSubmenu = 'students'" @mouseleave="activeSubmenu = null" class="relative">
                                <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">Cadets ▶</div>
                                <div x-show="activeSubmenu === 'students'" class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">
                                    <a href="<?php echo e(route('admissions.index')); ?>" class="block px-4 py-2 hover:bg-gray-200">
                                        Admission
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                    </div>

                    <!-- Reports Dropdown -->
                  <!-- Reports Dropdown -->


                    <!-- Assessment Dropdown -->
                    <div x-data="{ open: false, activeSubmenu: null }" class="relative">
                        <button @click="open = !open"
                                class="px-4 py-2 rounded-lg text-sm font-medium hover:bg-green-600 transition">
                            Assessment ▼
                        </button>
                        <div x-show="open" @click.away="open = false"
                             class="absolute left-0 mt-2 w-48 bg-white text-black rounded shadow-lg z-50">

                            <!-- Marks Menu -->
                            <div @mouseover="activeSubmenu = 'marks'" @mouseleave="activeSubmenu = null" class="relative">
                                <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">Marks ▶</div>
                                <div x-show="activeSubmenu === 'marks'"
                                     class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">
                                    <a href="<?php echo e(route('marks-entry2')); ?>" class="block px-4 py-2 hover:bg-gray-200">Entry</a>
                                    <a href="<?php echo e(route('marks.editPage')); ?>" class="block px-4 py-2 hover:bg-gray-200">Edit Marks</a>
                                    <a href="<?php echo e(route('marks.index')); ?>" class="block px-4 py-2 hover:bg-gray-200">Overview</a>
                                </div>
                            </div>

                            <!-- CR Menu -->
                            <div @mouseover="activeSubmenu = 'cr'" @mouseleave="activeSubmenu = null" class="relative">
                                <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">22 CR ▶</div>
                                <div x-show="activeSubmenu === 'cr'"
                                     class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">
                                    <a  href="<?php echo e(route('marks_entry.create')); ?>" class="block px-4 py-2 hover:bg-gray-200">Entry</a>
<a
    href="#"
    class="block px-4 py-2 text-gray-400 cursor-not-allowed pointer-events-none"
    aria-disabled="true"
>
    Quick Entry
</a>


                                    <a href="<?php echo e(route('cr.assessments.22cr')); ?>" class="block px-4 py-2 hover:bg-gray-200">Individual View</a>
                                    <a href="<?php echo e(route('cr.assessments.22cr.overview')); ?>" class="block px-4 py-2 hover:bg-gray-200">Overview</a>
                                </div>
                            </div>

                            <!-- PR Menu -->
                            <div @mouseover="activeSubmenu = 'pr'" @mouseleave="activeSubmenu = null" class="relative">
                                <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">PR ▶</div>
                                <div x-show="activeSubmenu === 'pr'"
                                     class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">

                                    <a href="<?php echo e(route('pr.index')); ?>" class="block px-4 py-2 hover:bg-gray-200">Entry</a>
  
<a
    href="#"
    class="block px-4 py-2 text-gray-400 cursor-not-allowed pointer-events-none"
    aria-disabled="true"
>
    Quick Entry
</a>

                                    <a href="<?php echo e(route('pr.raters')); ?>" class="block px-4 py-2 hover:bg-gray-200">List</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div x-data="{ open: false, activeSubmenu: null }" class="relative">
    <button @click="open = !open"
            class="px-4 py-2 rounded-lg text-sm font-medium hover:bg-green-600 transition">
        Reports ▼
    </button>
    
    <!-- Dropdown menu -->
    <div x-show="open" @click.away="open = false" class="absolute left-0 mt-2 w-48 bg-white text-black rounded shadow-lg z-50">
        <!-- End Phase Report submenu -->
        <div @mouseover="activeSubmenu = 'epr'" @mouseleave="activeSubmenu = null" class="relative">
            <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">End Phase Report ▶</div>
            <div x-show="activeSubmenu === 'epr'"
                 class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">
                <a href="<?php echo e(route('reports.search')); ?>" class="block px-4 py-2 hover:bg-gray-200">Single Report</a>
                <a href="<?php echo e(route('admissions.list','epr')); ?>" class="block px-4 py-2 hover:bg-gray-200">List Reports</a>



            </div>
        </div>

        <!-- Individual Summary Report submenu -->
        

        <!-- Transcript submenu -->
        <div @mouseover="activeSubmenu = 'tr'" @mouseleave="activeSubmenu = null" class="relative">
            <div class="block px-4 py-2 hover:bg-gray-200 cursor-pointer">Transcript ▶</div>
            <div x-show="activeSubmenu === 'tr'"
                 class="absolute left-full top-0 w-48 bg-white rounded shadow-lg">
                <a href="<?php echo e(route('reports.search3')); ?>" class="block px-4 py-2 hover:bg-gray-200">Single Report</a>
                <a href="<?php echo e(route('admissions.list','tr')); ?>" class="block px-4 py-2 hover:bg-gray-200">PL List Report</a>
            </div>
        </div>
        <a href="<?php echo e(route('gpv')); ?>" class="block px-4 py-2 hover:bg-gray-200">GPV Report</a>

    </div>
</div>

                    <!-- User Management Dropdown -->
                    <div x-data="{ open: false }" class="relative">
                        <button @click="open = !open"
                                class="px-4 py-2 rounded-lg text-sm font-medium hover:bg-green-600 transition <?php echo e(Auth::user()->type != 'admin' ? 'opacity-50' : ''); ?>">
                            User Management ▼
                        </button>
                        <div x-show="open" @click.away="open = false" class="absolute left-0 mt-2 w-48 bg-white text-black rounded shadow-lg z-50">
                            <a href="<?php echo e(route('users.index')); ?>"
                               class="block px-4 py-2 hover:bg-gray-200 <?php echo e(Auth::user()->type != 'admin' ? 'pointer-events-none opacity-50' : ''); ?>"
                               <?php if(Auth::user()->type != 'admin'): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
                                Users
                            </a>
                            <a href="<?php echo e(route('user.password.edit')); ?>"
                               class="block px-4 py-2 hover:bg-gray-200">
                                User Edit
                         
    <a href="<?php echo e(route('activitylogs.index')); ?>"
       class="block px-4 py-2 hover:bg-gray-200 <?php echo e(Auth::user()->type != 'admin' ? 'pointer-events-none opacity-50' : ''); ?>"
       <?php if(Auth::user()->type != 'admin'): ?> onclick="showPermissionDenied(); return false;" <?php endif; ?>>
        Track Activity
    </a>
                        </div>
                    </div>

              

                    <!-- Logout -->
             <div x-data="{ open: false }" class="relative inline-block text-left">
    <!-- Toggle button: user name -->
    <button @click="open = !open"
            class="px-4 py-2 bg-green-500 text-white rounded-lg text-sm font-medium hover:bg-green-600 transition">
        <?php echo e(Auth::user()->name); ?> ▼
    </button>

    <!-- Dropdown -->
    <div x-show="open"
         x-cloak
         x-transition
         @click.away="open = false"
         class="absolute right-0 mt-2 w-40 bg-white text-black rounded shadow-lg z-50">
        <a href="<?php echo e(url('logout')); ?>"
           class="block px-4 py-2 text-sm hover:bg-gray-200">
            Logout
        </a>
    </div>
</div>

                </div>
            </div>
        </div>
    </nav>

<!-- Mobile Menu -->
<div id="mobile-menu" class="hidden md:hidden bg-green-700 p-4 space-y-2">

    <?php if( Auth::check() && Auth::user()->type == 'admin'): ?>
        <!-- Dashboard -->
        <a href="<?php echo e(route('dashboard')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Dashboard</a>

        <!-- Academics -->
        <div class="text-white font-semibold py-2">Academics</div>
        <a href="<?php echo e(route('admissions.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Admissions</a>
        <a href="<?php echo e(route('schools.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Schools</a>
        <a href="<?php echo e(route('courses.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Courses</a>
        <a href="<?php echo e(route('subjects.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Subjects</a>
        <a href="<?php echo e(route('intakes.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Intake</a>

        <!-- Marks Management -->
        <div class="text-white font-semibold py-2">Marks Management</div>
        <a href="<?php echo e(route('marks_entry.create')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Marks Entry</a>
        <a href="<?php echo e(route('marks.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Marks List</a>

        <!-- User Management -->
        <div class="text-white font-semibold py-2">User Management</div>
        <a href="<?php echo e(route('user.password.edit')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">User Edit</a>
        <a href="<?php echo e(route('users.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Users</a>
    <?php endif; ?>



    <?php if(  Auth::check() && Auth::user()->type == 'data_entry_clerk'): ?>
        <div class="text-white font-semibold py-2">Marks Management</div>
        <a href="<?php echo e(route('marks_entry.create')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Marks Entry</a>
        <a href="<?php echo e(route('marks.index')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">Marks List</a>
        <a href="<?php echo e(route('user.password.edit')); ?>" class="block text-white py-2 hover:bg-green-600 rounded">User Edit</a>
    <?php endif; ?>

    <div class="text-center mt-4">

        <p class="text-white"><?php echo e(Auth::check() && Auth::user()->name); ?></p>
        <a class="block text-white py-2 hover:bg-red-600 rounded" href="<?php echo e(url('logout')); ?>">Logout</a>
    </div>
</div>

<!-- Toggle mobile menu script -->
<script>
    document.getElementById('menu-toggle').addEventListener('click', function () {
        document.getElementById('mobile-menu').classList.toggle('hidden');
    });
</script>



    <!-- Page Content -->
    <main class="flex-grow container mx-auto p-6">
<div id="global-loading-bar">
    <div id="loading-progress"></div>
</div>
        <?php echo $__env->yieldContent('content'); ?>
    </main>



    <!-- Scripts -->

    <?php echo $__env->yieldContent('scripts'); ?>
    <script>

function showPermissionDenied() {
    alert('You do not have permission to access this.');
    return false;
}
        // Toggle mobile menu
        document.getElementById('menu-toggle').addEventListener('click', function () {
            document.getElementById('mobile-menu').classList.toggle('hidden');
        });

    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
        <!-- Footer -->
    <footer class="bg-green-900 text-white py-6 mt-8 shadow-xl">
  <div class="max-w-7xl mx-auto flex flex-col sm:flex-row justify-between items-center px-6 sm:px-8 lg:px-10 space-y-4 sm:space-y-0">
    <!-- Left Section: Company Info or Logo -->
    <div class="flex items-center space-x-4">

    </div>

    <!-- Middle Section: Links or Information (optional) -->
    <div class="text-center sm:text-left">
      <p class="text-sm text-gray-300">&copy; <?php echo e(date('Y')); ?> MODVA-UPDF-TRADOC. All rights reserved.</p>
    </div>

    <!-- Right Section: Social Media or Contact Links (optional) -->
    <div class="flex space-x-6">
     
    </div>
  </div>
</footer>

        <?php echo $__env->yieldPushContent('scripts'); ?>
<script>
// Global loading bar functions
function showLoadingBar() {
    const loadingBar = document.getElementById('global-loading-bar');
    const progressBar = document.getElementById('loading-progress');
    
    loadingBar.classList.add('active');
    progressBar.style.width = '30%';
    
    // Simulate progress for longer loads
    const interval = setInterval(() => {
        const currentWidth = parseFloat(progressBar.style.width);
        if (currentWidth < 90) {
            progressBar.style.width = (currentWidth + 10) + '%';
        }
    }, 500);
    
    return {
        finish: function() {
            clearInterval(interval);
            progressBar.style.width = '100%';
            setTimeout(() => {
                loadingBar.classList.remove('active');
                setTimeout(() => {
                    progressBar.style.width = '0%';
                }, 300);
            }, 300);
        }
    };
}
</script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/layouts/app.blade.php ENDPATH**/ ?>