

<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Courses List</h2>

    <a href="<?php echo e(route('courses.create')); ?>" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600 mb-4 inline-block">Add Course</a>

    <?php if(session('success')): ?>
        <div class="bg-green-500 text-white p-4 mb-4 rounded">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <table class="min-w-full bg-white border border-gray-300 rounded-lg mt-6">
        <thead>
            <tr>
                <th class="px-6 py-3 text-left">Course ID</th>
                <th class="px-6 py-3 text-left">Course Name</th>
                <th class="px-6 py-3 text-left">School</th>
                <th class="px-6 py-3 text-left">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border-b border-gray-200">
                    <td class="px-6 py-4"><?php echo e($course->id); ?></td>
                    <td class="px-6 py-4"><?php echo e($course->name); ?></td>
                  
                    <td class="px-6 py-4"><?php echo e($course->school->name); ?></td>
                    <td class="px-6 py-4">
                        <a href="<?php echo e(route('courses.edit', $course)); ?>" class="bg-yellow-500 text-white px-3 py-2 rounded hover:bg-yellow-600">Edit</a>
                        <form action="<?php echo e(route('courses.destroy', $course)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="bg-red-500 text-white px-3 py-2 rounded hover:bg-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\courses\index.blade.php ENDPATH**/ ?>