<?php $__env->startSection('title', 'Login'); ?>
<?php $__env->startSection('content'); ?>

<section class="bg-gray-100 min-h-screen flex items-center justify-center">
    <div class="w-full max-w-md px-4">
        <div class="bg-white shadow-md rounded-lg py-6 px-6">
            
            
            <div class="text-center mb-6">
                <img src="<?php echo e(asset('bmts-logo1.png')); ?>" alt="Logo" class="mx-auto mb-3 w-28">
                <p class="text-sm uppercase font-bold text-gray-500">
                    Welcome To STRART v2.0
                </p>
            </div>

            
            <?php if(session('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4 flex justify-between items-center">
                    <span><?php echo e(session('error')); ?></span>
                    <button onclick="this.parentElement.remove()" class="font-bold">×</button>
                </div>
            <?php endif; ?>

            
            <?php if(session('status')): ?>
                <div class="bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded mb-4 flex justify-between items-center">
                    <span><?php echo e(session('status')); ?></span>
                    <button onclick="this.parentElement.remove()" class="font-bold">×</button>
                </div>
            <?php endif; ?>

            
            <?php if($errors->any()): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <ul class="list-disc list-inside text-sm">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            
            <form class="space-y-4" action="<?php echo e(url('login')); ?>" method="post">
                <?php echo csrf_field(); ?>

                
                <div>
                    <label for="emailInp" class="block text-sm font-medium text-gray-700">
                        Email Address
                    </label>
                    <input type="email"
                        id="emailInp"
                        name="email"
                        value="<?php echo e(old('email')); ?>"
                        required
                        autofocus
                        class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">

                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-xs text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div>
                    <label for="passInp" class="block text-sm font-medium text-gray-700">
                        Password
                    </label>
                    <div class="relative mt-1">
                        <input type="password"
                            id="passInp"
                            name="password"
                            required
                            class="w-full rounded-md border-gray-300 shadow-sm pr-10 focus:border-blue-500 focus:ring focus:ring-blue-200 <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">

                        <button type="button"
                            id="togglePassword"
                            class="absolute inset-y-0 right-0 px-3 flex items-center text-gray-500 hover:text-gray-700">
                            👁
                        </button>
                    </div>

                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-xs text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div>
                    <button type="submit"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 rounded-md transition">
                        Login
                    </button>
                </div>
            </form>

            
            <div class="mt-4 text-center text-sm">
                <p class="text-gray-600">
                    I don't have an account?
                    <a href="<?php echo e(url('register')); ?>" class="font-medium text-blue-600 hover:underline">
                        Register
                    </a>
                </p>
            </div>
        </div>

        
        <div class="mt-4 text-left">
            <small class="text-gray-500">System Version: 1.0.1</small>
        </div>
    </div>
</section>

<?php $__env->startPush('scripts'); ?>
<script>
    document.getElementById('togglePassword').addEventListener('click', function () {
        const passwordInput = document.getElementById('passInp');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            this.textContent = '🙈';
        } else {
            passwordInput.type = 'password';
            this.textContent = '👁';
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/login.blade.php ENDPATH**/ ?>