<!DOCTYPE html>
<html>
<head>
    <title>Admissions List</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .filters { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { margin-bottom: 20px; }
        .date { text-align: right; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Admissions List</h2>
        <div class="date">Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></div>
    </div>

    <?php if(!empty($filters)): ?>
    <div class="filters">
        <h4>Applied Filters:</h4>
        <ul>
            <?php if(!empty($filters['school_id'])): ?>
                <li>School: <?php echo e(App\Models\School::find($filters['school_id'])->name); ?></li>
            <?php endif; ?>
            <?php if(!empty($filters['course_id'])): ?>
                <li>Course: <?php echo e(App\Models\Course::find($filters['course_id'])->name); ?></li>
            <?php endif; ?>
            <?php if(!empty($filters['bn'])): ?>
                <li>Bn: <?php echo e($filters['bn']); ?></li>
            <?php endif; ?>
            <?php if(!empty($filters['coy'])): ?>
                <li>Coy: <?php echo e($filters['coy']); ?></li>
            <?php endif; ?>
            <?php if(!empty($filters['pl'])): ?>
                <li>Pl: <?php echo e($filters['pl']); ?></li>
            <?php endif; ?>
            <?php if(!empty($filters['sec'])): ?>
                <li>Sec: <?php echo e($filters['sec']); ?></li>
            <?php endif; ?>
            <?php if(!empty($filters['search'])): ?>
                <li>Search: <?php echo e($filters['search']); ?></li>
            <?php endif; ?>
        </ul>
    </div>
    <?php endif; ?>

    <table>
        <thead>
            <tr>
                <th>Army Number</th>
                <th>Rank</th>
                <th>Name</th>
                <th>Course</th>
                <th>Bn</th>
                <th>Coy</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $admissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($admission->army_number); ?></td>
                <td><?php echo e($admission->rank); ?></td>
                <td><?php echo e($admission->name); ?></td>
                <td><?php echo e($admission->course->name); ?></td>
                <td><?php echo e($admission->bn); ?></td>
                <td><?php echo e($admission->coy); ?></td>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div>Total Records: <?php echo e($admissions->count()); ?></div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\exports\admissions-pdf.blade.php ENDPATH**/ ?>