<!-- reports/performance.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Performance Report</title>
    <style>
        body {
            font-family: sans-serif;
        }
        .container {
            width: 80%;
            margin: 20px auto;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            display: block;
            margin: 0 auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .remarks {
            font-style: italic;
        }
        @media  print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="<?php echo e(asset('bmts-logo1.png')); ?>" alt="Logo" class="logo">
            <h1>Performance Report</h1>
        </div>

        <div class="student-details mb-4">
            <h2>Student Information</h2>
            <table>
                <tr>
                    <th>Army Number</th>
                    <td><?php echo e($student->army_number); ?></td>
                    <th>Name</th>
                    <td><?php echo e($student->name); ?></td>
                </tr>
                <tr>
                    <th>Rank</th>
                    <td><?php echo e($student->rank ?? 'N/A'); ?></td>
                    <th>Course</th>
                    <td><?php echo e($student->course_id ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Grouping</th>
                    <td colspan="3">
                        BN: <?php echo e($student->bn ?? 'N/A'); ?>,
                        COY: <?php echo e($student->coy ?? 'N/A'); ?>,
                        PL: <?php echo e($student->pl ?? 'N/A'); ?>,
                        SEC: <?php echo e($student->sec ?? 'N/A'); ?>

                    </td>
                </tr>
            </table>
        </div>

        <h2>Phase One Summary of Performance</h2>
        <table>
            <thead>
                <tr>
                    <th>S/NO</th>
                    <th>Description</th>
                    <th>Maximum Score</th>
                    <th>Pass Mark</th>
                    <th>Obtained Marks</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>MSK<br>Theory<br>Practical</td>
                    <td><?php echo e($performanceData['msk_theory']['max_score']); ?>%<br><?php echo e($performanceData['msk_practical']['max_score']); ?>%</td>
                    <td><?php echo e($performanceData['msk_theory']['pass_mark']); ?>%<br><?php echo e($performanceData['msk_practical']['pass_mark']); ?>%</td>
                    <td><?php echo e($performanceData['msk_theory']['obtained']); ?>%<br><?php echo e($performanceData['msk_practical']['obtained']); ?>%</td>
                    <td><?php echo e($performanceData['summary']['msk_status']); ?></td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Character Assessment<br>22CR<br>PR</td>
                    <td><?php echo e($performanceData['character_22cr']['max_score']); ?>%<br><?php echo e($performanceData['character_pr']['max_score']); ?>%</td>
                    <td><?php echo e($performanceData['character_22cr']['pass_mark']); ?>%<br><?php echo e($performanceData['character_pr']['pass_mark']); ?>%</td>
                    <td><?php echo e($performanceData['character_22cr']['obtained']); ?>%<br><?php echo e($performanceData['character_pr']['obtained']); ?>%</td>
                    <td><?php echo e($performanceData['summary']['character_status']); ?></td>
                </tr>
                <tr>
                    <td colspan="2"><strong>TOTAL</strong></td>
                    <td><?php echo e($performanceData['summary']['total_max_score']); ?>%</td>
                    <td><?php echo e($performanceData['summary']['total_pass_mark']); ?>%</td>
                    <td><?php echo e($performanceData['summary']['total_obtained']); ?>%</td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="2"><strong>GRADE</strong></td>
                    <td colspan="3"><?php echo e($performanceData['summary']['grade']); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="6"><strong>GENERAL REMARKS:</strong> <?php echo e($performanceData['summary']['status']); ?></td>
                </tr>
            </tbody>
        </table>

        <div class="no-print">
            <button onclick="window.print()" class="btn btn-primary">Print Report</button>
            <a href="<?php echo e(route('reports.search')); ?>" class="btn btn-secondary">Back to Search</a>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\admissions\report.blade.php ENDPATH**/ ?>