

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto mt-10 bg-white shadow-lg rounded-lg p-6">
    <h2 class="text-2xl font-bold text-center text-blue-600 mb-6">Mark Entry</h2>

    <!-- Warning Banner -->
    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                </svg>
            </div>
            <div class="ml-3">
                <p class="text-sm text-yellow-700 font-medium">
                    ⚠️ IMPORTANT: Mark entries are permanent and cannot be modified after saving. 
                    Please double-check all marks before submission.
                </p>
            </div>
        </div>
    </div>

    <div id="successMessage" style="display: none; color: green;"></div>
    <div id="errorMessage" style="display: none; color: red;"></div>

    <!-- Preview Mode Toggle -->
    <div class="mb-4 flex items-center justify-end space-x-2">
        <span class="text-sm text-gray-600">Preview Mode:</span>
        <label class="relative inline-flex items-center cursor-pointer">
            <input type="checkbox" id="previewModeToggle" class="sr-only peer" checked>
            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
            <span class="ml-3 text-sm font-medium text-gray-900">ON</span>
        </label>
    </div>

    <form id="filterForm">
        <?php echo csrf_field(); ?>

        <!-- First Grid: School / Course / Intake -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <div>
                <label class="block font-semibold">School</label>
                <select name="school_id" id="school_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select School</option>
                    <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e($name === 'BMTS' ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div id="course_container">
                <label class="block font-semibold">Course</label>
                <select name="course_id" id="course_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Course</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e($name === 'O/CDT' ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div id="intake_container">
                <label class="block font-semibold">Intake</label>
                <select name="intake_id" id="intake_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Intake</option>
                    <?php $__currentLoopData = $intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e($name === '19/25' ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <!-- Second Grid: Phase / Assessment Type / Assessment Group / Exam Type -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
  <div id="phase_container">
    <label class="block font-semibold">Phase</label>
    <select name="choose_phase" id="choose_phase" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
        <option value="">Select Phase</option>
        <option value="Phase 1" <?php if($selectedPhase && $selectedPhase == 'Phase 1'): ?> selected <?php endif; ?>>Phase 1</option>
        <option value="Phase 2" <?php if($selectedPhase && $selectedPhase == 'Phase 2'): ?> selected <?php endif; ?>>Phase 2</option>
        <option value="Phase 3" <?php if($selectedPhase && $selectedPhase == 'Phase 3'): ?> selected <?php endif; ?>>Phase 3</option>
    </select>
</div>

            <div id="assessment_type_container">
                <label class="block font-semibold">Assessment Type</label>
                <select name="choose_assessment_type" id="choose_assessment_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Assessment Type</option>
                    <option value="MSK">MSK</option>
                </select>
            </div>

            <div id="assessment_group_container" style="display: none;">
                <label class="block font-semibold">Assessment Group</label>
                <select name="choose_assessment_group" id="choose_assessment_group" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Assessment Group</option>
                </select>
            </div>

            <div id="type_container" style="display: none;">
                <label class="block font-semibold">Exam Type</label>
                <select name="choose_type" id="choose_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="">Select Exam Type</option>
                    <option value="Weekly">Weekly</option>
                    <option value="Monthly">Monthly</option>
                    <option value="End of Phase Exam">End of Phase Exam</option>
                </select>
            </div>
        </div>

        <!-- Month (shown when Monthly is selected) -->
        <div id="month_container" style="display: none;" class="mb-6">
            <label class="block font-semibold">Month</label>
            <select name="month" id="month" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                <option value="">Select Month</option>
                <option value="Jan">Jan</option>
                <option value="Feb">Feb</option>
                <option value="Mar">Mar</option>
                <option value="Apr">Apr</option>
                <option value="May">May</option>
                <option value="Jun">Jun</option>
                <option value="Jul">Jul</option>
                <option value="Aug">Aug</option>
                <option value="Sep">Sep</option>
                <option value="Oct">Oct</option>
                <option value="Nov">Nov</option>
                <option value="Dec">Dec</option>
            </select>
        </div>

        <!-- Third Grid: Exercises / Code Name / Weeks -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div id="exercises_container" style="display: none;">
                <label class="block font-semibold">Exercises</label>
                <select name="exercises" id="exercises" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Exercise</option>
                    <?php $__currentLoopData = $exercise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exercises): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($exercises); ?>"><?php echo e($exercises); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div id="code_name_container" style="display: none;">
                <label class="block font-semibold">Code Name</label>
                <input
                    type="text"
                    name="code_name"
                    id="code_name"
                    maxlength="20"
                    class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500"
                    placeholder="Enter Code Name"
                >
            </div>

         <div id="weeks_container" style="display: none;">
    <label class="block font-semibold">Weeks</label>
    <select name="weeks" id="weeks" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
        <option value="">Select Week</option>
        <?php if($phase): ?>
            <?php for($i = 1; $i <= $phase->weeks; $i++): ?>
                <option value="week<?php echo e($i); ?>">Week <?php echo e($i); ?></option>
            <?php endfor; ?>
        <?php endif; ?>
    </select>
</div>
        </div>

        <!-- Fourth Grid: Subject -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div id="subject_container" style="display: none;">
                <label class="block font-semibold">Subject</label>
                <select name="subject_id" id="subject" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Subject</option>
                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($subject->id); ?>"><?php echo e($subject->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <!-- Fifth Grid: Bn / Coy / Pl / Sec -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div id="bn_container" style="display: none;">
                <label class="block font-semibold">Bn</label>
                <select name="bn" id="bn" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Bn</option>
                    <?php $__currentLoopData = $bn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bns): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($bns); ?>"><?php echo e($bns); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div id="coy_container" style="display: none;">
                <label class="block font-semibold">Coy</label>
                <select name="coy" id="coy" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Coy</option>
                    <?php $__currentLoopData = $coy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coys): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($coys); ?>"><?php echo e($coys); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div id="pl_container" style="display: none;">
                <label class="block font-semibold">Pl</label>
                <select name="pl" id="pl" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Pl</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                </select>
            </div>

            <div id="sec_container" style="display: none;">
                <label class="block font-semibold">Sec</label>
                <select name="sec" id="sec" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Select Sec</option>
                    <option value="I">I</option>
                    <option value="II">II</option>
                    <option value="III">III</option>
                </select>
            </div>
        </div>

        <!-- Student List -->
        <div id="studentListContainer" class="mt-6">
            <h3 class="text-xl font-semibold">Filtered Cadets</h3>
            
            <!-- Summary Stats -->
            <div id="studentStats" class="hidden mt-2 p-3 bg-gray-50 rounded-lg text-sm">
                <span id="totalStudents" class="font-medium"></span> cadets found |
                <span id="enteredMarks" class="font-medium text-green-600"></span> marks entered |
                <span id="pendingMarks" class="font-medium text-yellow-600"></span> pending
            </div>
            
            <ul id="studentList" class="list-inside list-disc mt-4"></ul>
        </div>

        <!-- Preview Summary -->
        <div id="previewSummary" class="hidden mt-6 p-4 bg-blue-50 rounded-lg border border-blue-200">
            <h4 class="font-semibold text-blue-800 mb-2">📋 Preview Summary</h4>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-sm">
                <div><span class="text-gray-600">Total Cadets:</span> <span class="font-medium" id="previewTotal">0</span></div>
                <div><span class="text-gray-600">Marks Entered:</span> <span class="font-medium text-green-600" id="previewEntered">0</span></div>
                <div><span class="text-gray-600">Average Marks:</span> <span class="font-medium" id="previewAverage">0</span></div>
                <div><span class="text-gray-600">Highest Marks:</span> <span class="font-medium" id="previewHighest">0</span></div>
            </div>
        </div>

        <!-- Actions -->
        <div class="mt-6 text-center flex items-center justify-center gap-4">
            <button type="button" 
                id="reviewButton"
                class="bg-purple-600 text-white px-6 py-3 rounded-lg shadow hover:bg-purple-700 focus:outline-none"
                style="display: none;">
                <span class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                    </svg>
                    Review Marks
                </span>
            </button>

            <button type="submit"
                id="saveButton"
                class="bg-blue-600 text-white px-6 py-3 rounded-lg shadow hover:bg-blue-700 focus:outline-none"
                style="display: none;">
                <span class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Confirm & Save Marks
                </span>
            </button>

            <button type="button"
                id="printButton"
                onclick="printMarksSheet()"
                class="bg-green-600 text-white px-6 py-3 rounded-lg shadow hover:bg-green-700 focus:outline-none"
                style="display: none;">
                <span class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                    </svg>
                    Print Marks Sheet
                </span>
            </button>
        </div>
    </form>
</div>

<!-- Review Modal -->
<div id="reviewModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-lg bg-white">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-bold text-gray-900">Review Marks Entry</h3>
            <button onclick="closeReviewModal()" class="text-gray-400 hover:text-gray-600">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>

        <!-- Warning inside modal -->
        <div class="bg-red-50 border-l-4 border-red-400 p-4 mb-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-red-700">
                        ⚠️ <strong>Warning:</strong> Once saved, marks cannot be modified. Please verify all entries carefully.
                    </p>
                </div>
            </div>
        </div>

        <div id="reviewContent" class="max-h-96 overflow-y-auto mb-4">
            <!-- Review content will be dynamically inserted here -->
        </div>

        <div class="flex justify-end space-x-3">
            <button onclick="closeReviewModal()" 
                class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                Cancel
            </button>
            <button onclick="confirmSave()" 
                class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                I Confirm, Save Marks
            </button>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loading" style="display: none;" class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white p-5 rounded-lg flex items-center">
        <div class="loader ease-linear rounded-full border-4 border-t-4 border-gray-200 h-12 w-12"></div>
        <span class="ml-3 text-gray-700">Processing...</span>
    </div>
</div>

<!-- Success Toast -->
<div id="success-toast" class="hidden fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded shadow-lg z-50">
    <div class="flex items-center space-x-2">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
        </svg>
        <span>Marks saved successfully!</span>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function () {

    // ─── Preview Mode Toggle ─────────────────────────────────────────────────
    let isPreviewMode = true;

    $('#previewModeToggle').change(function() {
        isPreviewMode = $(this).is(':checked');
        if (!isPreviewMode && $('#studentList').children().length > 0) {
            $('#reviewButton').show();
            $('#saveButton').hide();
        } else {
            $('#reviewButton').hide();
            $('#saveButton').show();
        }
    });

    // ─── Helpers ────────────────────────────────────────────────────────────

    /**
     * Show or hide a container div and clear its input/select when hiding.
     */
    function toggleContainer(containerId, show) {
        const $container = $(`#${containerId}_container`);
        if (show) {
            $container.show();
        } else {
            $container.hide();
            $(`#${containerId}`).val('');
        }
    }

    /**
     * Show the loading spinner.
     */
    function showLoading() {
        $('#loading').show();
    }

    /**
     * Hide the loading spinner.
     */
    function hideLoading() {
        $('#loading').hide();
    }

    /**
     * Show an error message and auto-hide after 5 seconds.
     */
    function showError(message) {
        $('#errorMessage').text(message).show();
        setTimeout(() => $('#errorMessage').hide(), 5000);
    }

    /**
     * Show a success message.
     */
    function showSuccess(message) {
        $('#successMessage').text(message).show();
    }

    // ─── Update Stats ───────────────────────────────────────────────────────
    function updateStats() {
        const $inputs = $('#studentList input[type="number"]');
        const total = $inputs.length;
        const entered = $inputs.filter(function() { return $(this).val() !== ''; }).length;
        const pending = total - entered;

        $('#totalStudents').text(total);
        $('#enteredMarks').text(entered);
        $('#pendingMarks').text(pending);
        $('#studentStats').show();

        // Update preview summary
        const marks = $inputs.map(function() { return parseFloat($(this).val()) || 0; }).get();
        const validMarks = marks.filter(m => m > 0);
        
        $('#previewTotal').text(total);
        $('#previewEntered').text(entered);
        
        if (validMarks.length > 0) {
            const avg = validMarks.reduce((a, b) => a + b, 0) / validMarks.length;
            const highest = Math.max(...validMarks);
            $('#previewAverage').text(avg.toFixed(1));
            $('#previewHighest').text(highest);
        } else {
            $('#previewAverage').text('-');
            $('#previewHighest').text('-');
        }
        
        $('#previewSummary').show();
    }

    // ─── Cascading Dropdowns ─────────────────────────────────────────────────

    // School → fetch Courses
    $('#school_id').change(function () {
        const schoolId = $(this).val();
        toggleContainer('course', !!schoolId);
        // Reset downstream
        ['intake', 'phase', 'assessment_type', 'assessment_group', 'type',
         'weeks', 'month', 'exercises', 'code_name', 'subject', 'bn', 'coy', 'pl', 'sec'
        ].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();

        if (schoolId) {
            $.get("<?php echo e(route('getCourses')); ?>", { school_id: schoolId })
                .done(function (data) {
                    $('#course_id').html('<option value="">Select Course</option>');
                    $.each(data, function (id, name) {
                        $('#course_id').append(`<option value="${id}">${name}</option>`);
                    });
                })
                .fail(function () { showError('Failed to load courses.'); });
        }
    });

    // Course → fetch Intakes + Subjects
    $('#course_id').change(function () {
        const courseId = $(this).val();
        toggleContainer('intake', !!courseId);
        // Reset downstream
        ['phase', 'assessment_type', 'assessment_group', 'type',
         'weeks', 'month', 'exercises', 'code_name', 'subject', 'bn', 'coy', 'pl', 'sec'
        ].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();

        if (courseId) {
            // Fetch intakes
            $.get("<?php echo e(route('getIntakes')); ?>", { course_id: courseId })
                .done(function (data) {
                    $('#intake_id').html('<option value="">Select Intake</option>');
                    $.each(data, function (id, year) {
                        $('#intake_id').append(`<option value="${id}">${year}</option>`);
                    });
                })
                .fail(function () { showError('Failed to load intakes.'); });

            // Fetch subjects
            $.get("<?php echo e(route('getSubjectss')); ?>", { course_id: courseId })
                .done(function (data) {
                    $('#subject').html('<option value="">Select Subject</option>');
                    $.each(data, function (index, subject) {
                        $('#subject').append(`<option value="${subject.id}">${subject.code}</option>`);
                    });
                })
                .fail(function () { showError('Failed to load subjects.'); });
        }
    });

    // Intake → show Phase
    $('#intake_id').change(function () {
        toggleContainer('phase', !!$(this).val());
        ['assessment_type', 'assessment_group', 'type',
         'weeks', 'month', 'exercises', 'code_name', 'subject', 'bn', 'coy', 'pl', 'sec'
        ].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();
    });

    // Phase → show Assessment Type
    $('#choose_phase').change(function () {
        toggleContainer('assessment_type', !!$(this).val());
        ['assessment_group', 'type', 'weeks', 'month',
         'exercises', 'code_name', 'subject', 'bn', 'coy', 'pl', 'sec'
        ].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();
    });

    // Assessment Type → populate & show Assessment Group
    $('#choose_assessment_type').change(function () {
        const assessmentType = $(this).val();
        toggleContainer('assessment_group', !!assessmentType);
        ['type', 'weeks', 'month', 'exercises', 'code_name',
         'subject', 'bn', 'coy', 'pl', 'sec'
        ].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();

        if (assessmentType) {
            let options = '<option value="">Select Assessment Group</option>';
            if (assessmentType === 'MSK') {
                options += `
                    <option value="Theory">Theory</option>
                    <option value="Practical">Practical</option>
                `;
            } else if (assessmentType === 'Character Assessment') {
                options += `
                    <option value="22 CR">22 CR</option>
                    <option value="PR">PR</option>
                `;
            }
            $('#choose_assessment_group').html(options);
        }
    });

    // Assessment Group → populate Exam Type options
    $('#choose_assessment_group').change(function () {
        const assessmentGroup = $(this).val();
        toggleContainer('type', !!assessmentGroup);
        ['weeks', 'month', 'exercises', 'code_name',
         'subject', 'bn', 'coy', 'pl', 'sec'
        ].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();

        if (assessmentGroup === 'Theory') {
            $('#choose_type').html(`
                <option value="">Select Exam Type</option>
                <option value="Weekly">Weekly</option>
                <option value="Monthly">Monthly</option>
                <option value="End of Phase Exam">End of Phase Exam</option>
            `);
        } else if (assessmentGroup === 'Practical') {
            $('#choose_type').html(`
                <option value="">Select Exam Type</option>
                <option value="Weekly">Weekly</option>
            `);
        }
    });

    // Exam Type → show/hide Weeks, Month, Subject, Exercises, Bn
    $('#choose_type').change(function () {
        const examType = $(this).val();
        const assessmentGroup = $('#choose_assessment_group').val();

        toggleContainer('weeks', examType === 'Weekly');
        toggleContainer('month', examType === 'Monthly');

        if (assessmentGroup === 'Theory') {
            toggleContainer('subject', examType === 'End of Phase Exam');
            toggleContainer('exercises', false);
        } else if (assessmentGroup === 'Practical') {
            toggleContainer('subject', false);
            toggleContainer('exercises', examType === 'Weekly' || examType === 'End of Phase Exam');
        }

        toggleContainer('bn', ['Weekly', 'Monthly', 'End of Phase Exam'].includes(examType));

        // Reset Bn/Coy/Pl/Sec when exam type changes
        ['coy', 'pl', 'sec'].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();
    });

    // Exercises → show Code Name
    $('#exercises').change(function () {
        toggleContainer('code_name', !!$(this).val());
    });

    // Bn → Coy
    $('#bn').change(function () {
        toggleContainer('coy', !!$(this).val());
        ['pl', 'sec'].forEach(id => toggleContainer(id, false));
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();
    });

    // Coy → Pl
    $('#coy').change(function () {
        toggleContainer('pl', !!$(this).val());
        toggleContainer('sec', false);
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();
    });

    // Pl → Sec
    $('#pl').change(function () {
        toggleContainer('sec', !!$(this).val());
        $('#studentList').empty();
        $('#studentStats').hide();
        $('#previewSummary').hide();
        $('#reviewButton').hide();
        $('#saveButton').hide();
    });

    // Sec → fetch students
    $('#sec').change(function () {
        updateStudentList();
    });

    // ─── Fetch & Display Students ────────────────────────────────────────────

function updateStudentList() {
    const filters = {
        school_id:               $('#school_id').val(),
        course_id:               $('#course_id').val(),
        intake_id:               $('#intake_id').val(),
        choose_phase:            $('#choose_phase').val(),
        choose_assessment_type:  $('#choose_assessment_type').val(),
        choose_assessment_group: $('#choose_assessment_group').val(),
        choose_type:             $('#choose_type').val(),
        bn:                      $('#bn').val(),
        coy:                     $('#coy').val(),
        pl:                      $('#pl').val(),
        sec:                     $('#sec').val(),
    };

    console.log('Sending filters to server:', filters);

    // Require at minimum school, course, intake, and sec
    if (!filters.school_id || !filters.course_id || !filters.intake_id || !filters.sec) {
        console.log('Missing required filters');
        return;
    }

    showLoading();

    $.ajax({
        url: "<?php echo e(route('getFilteredStudents')); ?>",
        method: 'GET',
        data: filters,
        success: function (students) {
            console.log('Students received:', students);
            console.log('Number of students:', students.length);
            displayStudents(students);
            
            if (students.length > 0) {
                if (isPreviewMode) {
                    $('#saveButton').show();
                    $('#reviewButton').hide();
                } else {
                    $('#reviewButton').show();
                    $('#saveButton').hide();
                }
            }
            
            $('#printButton').toggle(Array.isArray(students) && students.length > 0);
        },
        error: function (xhr) {
            console.error('Error response:', xhr);
            console.error('Response text:', xhr.responseText);
            showError(xhr.responseJSON?.message || 'Error fetching students.');
        },
        complete: function () {
            hideLoading();
        }
    });
}

    function displayStudents(students) {
        const $studentList = $('#studentList');
        $studentList.empty();

        if (!Array.isArray(students) || students.length === 0) {
            $studentList.html('<li class="text-gray-500">No students found for the selected filters.</li>');
            return;
        }

        // Sort alphabetically by name
        students.sort((a, b) => (a.name || '').localeCompare(b.name || ''));

        students.forEach((student, index) => {
            const isDecommissioned = student.is_decommissioned;
            $studentList.append(`
                <div class="flex items-center justify-between py-2 ${isDecommissioned ? 'bg-red-50' : ''}">
                    <div class="flex">
                        <span class="font-medium ${isDecommissioned ? 'text-red-600' : ''}">
                            ${index + 1}. ${student.army_number || 'N/A'} | ${student.rank || 'N/A'} | ${student.name || 'N/A'}
                            ${isDecommissioned ? ' <em>(Discontinued)</em>' : ''}
                        </span>
                    </div>
                    <div class="flex items-center">
                        <input
                            type="number"
                            id="marks_${student.id}"
                            name="marks[${student.id}]"
                            class="w-24 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500
                                   ${isDecommissioned ? 'bg-gray-100 cursor-not-allowed' : ''}"
                            min="0"
                            max="100"
                            placeholder="Marks"
                            ${isDecommissioned ? 'disabled title="Decommissioned cadet - marks cannot be entered"' : ''}
                            oninput="updateStats()"
                        >
                    </div>
                </div>
            `);
        });
        
        updateStats();
    }

    // ─── Review Button Click ────────────────────────────────────────────────
    $('#reviewButton').click(function() {
        const students = [];
        let hasMarks = false;
        
        $('#studentList .flex').each(function() {
            const $input = $(this).find('input[type="number"]');
            const marks = $input.val();
            
            if (marks) hasMarks = true;
            
            const studentText = $(this).find('.font-medium').text().trim();
            const parts = studentText.split('|').map(p => p.trim());
            
            if (parts.length >= 3) {
                const armyNumber = parts[0].replace(/^\d+\.\s*/, '');
                students.push({
                    army_number: armyNumber,
                    rank: parts[1],
                    name: parts[2],
                    marks: marks || '<span class="text-red-500">Not entered</span>'
                });
            }
        });
        
        if (!hasMarks) {
            Swal.fire({
                title: 'No Marks Entered',
                text: 'Please enter marks for at least one cadet before reviewing.',
                icon: 'warning',
                confirmButtonColor: '#3085d6'
            });
            return;
        }
        
        // Sort students for display
        students.sort((a, b) => a.name.localeCompare(b.name));
        
        // Build review HTML
        let reviewHtml = '<table class="w-full text-sm">';
        reviewHtml += '<thead><tr class="bg-gray-100"><th class="p-2 text-left">#</th><th class="p-2 text-left">Army No.</th><th class="p-2 text-left">Rank</th><th class="p-2 text-left">Name</th><th class="p-2 text-left">Marks</th></tr></thead><tbody>';
        
        students.forEach((student, index) => {
            const marksClass = student.marks === '<span class="text-red-500">Not entered</span>' ? 'text-red-500' : 'font-medium';
            reviewHtml += `<tr class="${index % 2 === 0 ? 'bg-white' : 'bg-gray-50'}">
                <td class="p-2">${index + 1}</td>
                <td class="p-2">${student.army_number}</td>
                <td class="p-2">${student.rank}</td>
                <td class="p-2">${student.name}</td>
                <td class="p-2 ${marksClass}">${student.marks}</td>
            </tr>`;
        });
        
        reviewHtml += '</tbody></table>';
        
        $('#reviewContent').html(reviewHtml);
        $('#reviewModal').removeClass('hidden');
    });

    // ─── Form Submission with Preview ────────────────────────────────────────

    let isSubmitting = false;

    $('#filterForm').on('submit', function (e) {
        e.preventDefault();

        if (isSubmitting) return;

        // Check if in preview mode
        if (isPreviewMode) {
            // Show SweetAlert confirmation instead of modal
            Swal.fire({
                title: 'Confirm Save Marks',
                html: `
                    <div class="text-left">
                        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-4">
                            <p class="text-sm text-yellow-700">
                                ⚠️ <strong>Warning:</strong> Marks cannot be modified after saving.
                            </p>
                        </div>
                        <p>Are you sure you want to save these marks?</p>
                    </div>
                `,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, save marks',
                cancelButtonText: 'Review again'
            }).then((result) => {
                if (result.isConfirmed) {
                    saveMarks();
                }
            });
        } else {
            // In review mode, show the review modal first
            $('#reviewButton').click();
        }
    });

    // Save marks function
    function saveMarks() {
        // Collect marks
        const marksData = [];
        const seenIds = new Set();

        $('#studentList input[type="number"]').each(function () {
            const studentId = $(this).attr('id').replace('marks_', '');
            const marks = $(this).val();

            if (!marks || seenIds.has(studentId)) return;

            seenIds.add(studentId);
            marksData.push({
                admission_id: parseInt(studentId),
                marks: parseFloat(marks),
            });
        });

        if (marksData.length === 0) {
            showError('Please enter at least one mark.');
            return;
        }

        isSubmitting = true;
        showLoading();

        const formData = {
            _token:           $('input[name="_token"]').val(),
            marks:            marksData,
            phase:            $('#choose_phase').val(),
            assessment_type:  $('#choose_assessment_type').val(),
            assessment_group: $('#choose_assessment_group').val(),
            type:             $('#choose_type').val(),
            subject_id:       $('#subject').val()    || null,
            exercises:        $('#exercises').val()   || null,
            code_name:        $('#code_name').val()   || null,
            bn:               $('#bn').val()          || null,
            coy:              $('#coy').val()         || null,
            pl:               $('#pl').val()          || null,
            sec:              $('#sec').val()         || null,
            week:             $('#weeks').val()       || null,
            month:            $('#month').val()       || null,
        };

        $.ajax({
            url: "<?php echo e(route('saveMarks')); ?>",
            method: 'POST',
            data: formData,
            success: function (response) {
                showSuccess(response.message);
                $('#success-toast').removeClass('hidden');
                setTimeout(function () {
                    window.location.href = "<?php echo e(route('marks-entry2')); ?>";
                }, 1500);
            },
            error: function (xhr) {
                showError(xhr.responseJSON?.message || 'Error saving marks.');
            },
            complete: function () {
                isSubmitting = false;
                hideLoading();
                closeReviewModal();
            },
        });
    }

    // ─── Print ───────────────────────────────────────────────────────────────

    window.printMarksSheet = function () {
        // Collect student data from the DOM for the query string
        const students = [];
        const processedArmyNumbers = new Set();

        $('#studentList .flex').each(function () {
            const studentText = $(this).find('.font-medium').text().trim();
            const marks = $(this).find('input[type="number"]').val();
            const parts = studentText.split('|').map(p => p.trim());

            if (parts.length < 3) return;

            // Strip leading counter "1. "
            const armyNumber = parts[0].replace(/^\d+\.\s*/, '');

            if (!processedArmyNumbers.has(armyNumber)) {
                processedArmyNumbers.add(armyNumber);
                students.push({
                    army_number: armyNumber,
                    rank:        parts[1],
                    name:        parts[2],
                    marks:       marks || '',
                });
            }
        });

        // Sort for print
        students.sort((a, b) => a.name.localeCompare(b.name));

        const formData = {
            school_id:               $('#school_id').val(),
            course_id:               $('#course_id').val(),
            intake_id:               $('#intake_id').val(),
            choose_phase:            $('#choose_phase').val(),
            choose_assessment_type:  $('#choose_assessment_type').val(),
            choose_assessment_group: $('#choose_assessment_group').val(),
            code_name:               $('#code_name').val(),
            choose_type:             $('#choose_type').val(),
            subject_id:              $('#subject').val(),
            exercises:               $('#exercises').val(),
            bn:                      $('#bn').val(),
            coy:                     $('#coy').val(),
            pl:                      $('#pl').val(),
            sec:                     $('#sec').val(),
            weeks:                   $('#weeks').val(),
            month:                   $('#month').val(),
            students:                students,
        };

        const printWindow = window.open(
            "<?php echo e(route('marks.print')); ?>?" + $.param(formData),
            '_blank'
        );

        if (printWindow) {
            printWindow.onload = function () {
                printWindow.print();
            };
        }
    };

}); // end $(document).ready

// Global functions for modal
function closeReviewModal() {
    $('#reviewModal').addClass('hidden');
}

function confirmSave() {
    closeReviewModal();
    saveMarks();
}

// Make updateStats globally available
window.updateStats = function() {
    const $inputs = $('#studentList input[type="number"]');
    const total = $inputs.length;
    const entered = $inputs.filter(function() { return $(this).val() !== ''; }).length;
    
    $('#totalStudents').text(total);
    $('#enteredMarks').text(entered);
    $('#pendingMarks').text(total - entered);
    
    // Update preview summary
    const marks = $inputs.map(function() { return parseFloat($(this).val()) || 0; }).get();
    const validMarks = marks.filter(m => m > 0);
    
    $('#previewTotal').text(total);
    $('#previewEntered').text(entered);
    
    if (validMarks.length > 0) {
        const avg = validMarks.reduce((a, b) => a + b, 0) / validMarks.length;
        const highest = Math.max(...validMarks);
        $('#previewAverage').text(avg.toFixed(1));
        $('#previewHighest').text(highest);
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/marks_entry2.blade.php ENDPATH**/ ?>