<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Marks Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            /*background-color: #f4f7f6;*/
            color: #333;
            margin-top: 3.5cm;
            margin-bottom: 2.5cm;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: #fff;
            padding: 0px;
            margin-top: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        h1 {
            text-align: center;
            color: #1e4b03;
            text-transform: uppercase;
            font-size: 24px;
            margin-bottom: 20px;
        }
        .info-grid p {
            display: inline;
            margin-right: 15px;
        }
        .info-grid .line-break {
            display: block;
            margin-top: 10px;
        }
        table {
            margin-top: 10px;
            width: 100%;
            border-collapse: collapse;

        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #1e4b03;
            color: white;
            text-transform: uppercase;
            font-size: 14px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        tr:hover {
            background-color: #e1f5fe;
        }
        header {
            position: fixed;
            top: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            text-align: center; /* Optional: Center content */
            line-height: 3cm; /* Optional: Vertically center text */
        }

        /* Define the footer rules */
        footer {
            position: fixed;
            bottom: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            text-align: center; /* Optional: Center content */
            line-height: 2cm; /* Optional: Vertically center text */
        }


    </style>
</head>
<body>
<header class="site-header">
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</header>



<footer>
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</footer>


<main>

    <div class="container">






        <h1>Marks Report</h1>

        <?php
            $firstMark = $groupedMarks->first()->first() ?? null;
        ?>


        <?php if($firstMark): ?>
            <div class="info-grid">
                <?php if(!empty($firstMark->assessment_type)): ?><p><strong>Type:</strong> <?php echo e($firstMark->assessment_type); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->assessment_group)): ?><p><strong>Group:</strong> <?php echo e($firstMark->assessment_group); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->type)): ?><p><strong>Exam:</strong> <?php echo e($firstMark->type); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->month)): ?><p><strong>Month:</strong> <?php echo e($firstMark->month); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->week)): ?><p><strong>Week:</strong> Week <?php echo e(preg_replace('/[^0-9]/', '', $firstMark->week)); ?></p><?php endif; ?>
                <span class="line-break"></span>
                <?php if(!empty($firstMark->subject->code) || !empty($firstMark->exercises)): ?><p><strong>Subject / Exercise:</strong> <?php echo e($firstMark->subject->code ?? $firstMark->exercises); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->bn)): ?><p><strong>Bn:</strong> <?php echo e($firstMark->bn); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->coy)): ?><p><strong>Coy:</strong> <?php echo e($firstMark->coy); ?></p><?php endif; ?>
                <?php if(!empty($firstMark->pl)): ?><p><strong>Pl:</strong> <?php echo e($firstMark->pl); ?></p><?php endif; ?>
            </div>
        <?php endif; ?>

        <table style="width: 100%; border-collapse: collapse;">
            <thead>
            <tr>
                <th style="padding: 4px; width: 5%;">SN</th>
                <th style="padding: 4px; width: 15%;">Army Number</th>
                <th style="padding: 4px; width: 10%;">Rank</th>
                <th style="padding: 4px; width: 20%;">Names</th>
                <th style="padding: 4px; width: 5%;">Sex</th>
                <th style="padding: 4px; width: 10%;">Marks</th>
                <th style="padding: 4px; width: 10%;">Remarks</th>
            </tr>
            </thead>
            <tbody>
            <?php $sn = 1; ?>
            <?php $__currentLoopData = $groupedMarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $marks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php [$armyNumber, $rank, $name, $sex] = explode('|', $key); ?>
                <?php $__currentLoopData = $marks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="padding: 4px;"><?php echo e($sn++); ?></td>
                        <td style="padding: 4px;"><?php echo e($armyNumber); ?></td>
                        <td style="padding: 4px;"><?php echo e($rank); ?></td>
                        <td style="padding: 4px;"><?php echo e($name); ?></td>
                        <td style="padding: 4px;"><?php echo e($sex); ?></td>
                        <td style="padding: 4px;" class="font-bold"><?php echo e($mark->marks); ?></td>
                        <td style="padding: 4px;">
                            <?php if($mark->marks >= 50): ?>
                                <p style="margin: 0;">PASS</p>
                            <?php else: ?>
                                <p style="margin: 0;">Failed</p>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>



    </div>
</main>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\exports\marks-pdf.blade.php ENDPATH**/ ?>