<!DOCTYPE html>
<html>
<head>
    <title>Admissions List</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .filters { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px;}
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { margin-bottom: 20px; }
        .date { text-align: right; margin-bottom: 10px; }
        .logo { height: 60px; margin-bottom: 10px; }
        .title { text-align: center; margin-top: 100px; }
        .info { margin-bottom: 20px; }
        .info-item { margin: 5px 0; }

        header {
            position: fixed;
            top: 0cm;
            left: 0cm;
            right: 0cm;
            height: 3cm;

            text-align: center; /* Optional: Center content */
            line-height: 3cm; /* Optional: Vertically center text */
        }

        /* Define the footer rules */
        footer {
            position: fixed;
            bottom: 0cm;
            left: 0cm;
            right: 0cm;
            height: 2cm;

            text-align: center; /* Optional: Center content */
            line-height: 2cm; /* Optional: Vertically center text */
        }
    </style>
</head>
<body>

<header class="site-header">
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</header>



<footer>
    <p style="text-align: center; font-weight: bold;">RESTRICTED</p>
</footer>

<main>

    <div class="header">
        
        <h2 class="title">Admissions List</h2>

        <div class="info">
            <?php if(!empty($filters['course_id'])): ?>
                <div class="info-item"><strong>Course:</strong> <?php echo e(App\Models\Course::find($filters['course_id'])->name); ?></div>
            <?php endif; ?>
            <?php if(!empty($filters['bn'])): ?>
                <div class="info-item"><strong>Bn:</strong> <?php echo e($filters['bn']); ?></div>
            <?php endif; ?>
            <div class="date">Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></div>
        </div>
    </div>

    <?php if(!empty($filters)): ?>
        <div class="filters">
            <h4>Other Details:</h4>
            <ul>
                <?php if(!empty($filters['school_id'])): ?>
                    <li>School: <?php echo e(App\Models\School::find($filters['school_id'])->name); ?></li>
                <?php endif; ?>
                <?php if(!empty($filters['coy'])): ?>
                    <li>Coy: <?php echo e($filters['coy']); ?></li>
                <?php endif; ?>
                <?php if(!empty($filters['pl'])): ?>
                    <li>Pl: <?php echo e($filters['pl']); ?></li>
                <?php endif; ?>
                <?php if(!empty($filters['sec'])): ?>
                    <li>Sec: <?php echo e($filters['sec']); ?></li>
                <?php endif; ?>
                <?php if(!empty($filters['search'])): ?>
                    <li>Search: <?php echo e($filters['search']); ?></li>
                <?php endif; ?>
            </ul>
        </div>
    <?php endif; ?>

    <table>
        <thead>
        <tr>
            <th>Army Number</th>
            <th>Rank</th>
            <th>Name</th>
            <th>Coy</th>
            <th>Pl</th>
            <th>Sec</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $admissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($admission->army_number); ?></td>
                <td><?php echo e($admission->rank); ?></td>
                <td><?php echo e($admission->name); ?></td>
                <td><?php echo e($admission->coy); ?></td>
                <td><?php echo e($admission->pl); ?></td>
                <td><?php echo e($admission->sec); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div>Total Records: <?php echo e($admissions->count()); ?></div>
</main>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\admissions\print.blade.php ENDPATH**/ ?>