

<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">22CR</h1>
            <p class="text-gray-600">Add or filter 22CR items</p>
        </div>
        <a href="<?php echo e(route('twenty_two_cr.create')); ?>" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Add New Record</a>
    </div>

    <!-- Phase Filter Form -->
    <form method="GET" action="<?php echo e(route('twenty_two_cr.index')); ?>" class="mb-6">
        <div class="flex items-center gap-4">
            <select name="phase" class="p-3 border border-gray-300 rounded">
                <option value="">-- Filter by Phase --</option>
                <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($phase->name); ?>" <?php echo e(request('phase') == $phase->name ? 'selected' : ''); ?>>
                        <?php echo e($phase->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded hover:bg-gray-900">Filter</button>
            <a href="<?php echo e(route('twenty_two_cr.index')); ?>" class="text-blue-500 hover:underline">Reset</a>
        </div>
    </form>

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <table class="min-w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Title</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Weight</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phase</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?php echo e($index+1); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap"><?php echo e($record->title); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap"><?php echo e($record->weight); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap"><?php echo e($record->phase); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="<?php echo e(route('twenty_two_cr.edit', $record->id)); ?>" class="text-blue-600 hover:text-blue-900 mr-3">Edit</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\22cr\index.blade.php ENDPATH**/ ?>